/*
 * Decompiled with CFR 0.152.
 */
public class Board {
    public static final char MARK_RED = 'X';
    public static final char MARK_BLACK = 'O';
    public static final char UNMARKED = ' ';
    public static final char MARK_PINK = 'P';
    public static final char MARK_GRAY = 'G';
    public static final String RED = "Red";
    public static final String BLACK = "Black";
    public static final int ROWS = 6;
    public static final int COLUMNS = 7;
    public static final int[] INCREMENT = new int[]{0, 1, 4, 32, 128, 512};
    private final char[][] board = new char[6][7];
    private final int[][] moveNumbers = new int[6][7];
    private final int[] firstAvailableRow = new int[7];
    private final Cell[] winningCells = new Cell[4];
    private boolean winnerFound;
    private boolean redWinFound;
    private boolean blackWinFound;
    private int moveNumber;

    public Board() {
        this.reset();
    }

    public void reset() {
        int n;
        for (n = 0; n < 6; ++n) {
            for (int i = 0; i < 7; ++i) {
                this.board[n][i] = 32;
                this.moveNumbers[n][i] = 0;
            }
        }
        for (n = 0; n < 7; ++n) {
            this.firstAvailableRow[n] = 5;
        }
        for (n = 0; n < 4; ++n) {
            this.winningCells[n] = new Cell(0, 0);
        }
        this.winnerFound = false;
        this.moveNumber = 1;
    }

    public boolean isColumnAvailable(int n) {
        return this.firstAvailableRow[n] != -1;
    }

    public int getFirstAvailableRow(int n) {
        return this.firstAvailableRow[n];
    }

    public char get(int n, int n2) {
        return this.board[n][n2];
    }

    public char[][] getGrid() {
        char[][] cArray = new char[6][7];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                cArray[i][j] = this.board[i][j];
            }
        }
        return cArray;
    }

    public void display() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                System.out.print("|" + this.board[i][j]);
            }
            System.out.println("|");
        }
        System.out.println("---------------");
    }

    public int mark(int n, char c) throws IllegalArgumentException {
        int n2 = this.firstAvailableRow[n];
        if (n2 < 0) {
            throw new IllegalArgumentException("Column " + (n + 1) + " is already full.");
        }
        this.board[n2][n] = c;
        int n3 = n;
        this.firstAvailableRow[n3] = this.firstAvailableRow[n3] - 1;
        return n2;
    }

    public void set(int n, char c) throws IllegalArgumentException {
        int n2 = this.mark(n, c);
        this.moveNumbers[n2][n] = this.moveNumber++;
    }

    public void unset(int n) throws IllegalArgumentException {
        int n2 = this.firstAvailableRow[n];
        if (n2 >= 6) {
            throw new IllegalArgumentException("Column " + (n + 1) + " is already empty.");
        }
        int n3 = n;
        int n4 = this.firstAvailableRow[n3] + 1;
        this.firstAvailableRow[n3] = n4;
        n2 = n4;
        this.board[n2][n] = 32;
    }

    public static String getColorOfPlayer(char c) throws IllegalArgumentException {
        if (c == 'X') {
            return RED;
        }
        if (c == 'O') {
            return BLACK;
        }
        throw new IllegalArgumentException("Unknown player " + c + " received.");
    }

    public Cell[] getWinningCells() {
        return this.winnerFound ? this.winningCells : null;
    }

    public int[][] getMoveNumbers() {
        return this.moveNumbers;
    }

    public char getWinner() {
        char c;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.winnerFound = false;
        for (n5 = 0; n5 < 6; ++n5) {
            for (n4 = 3; n4 < 7; ++n4) {
                n3 = 0;
                n2 = 0;
                for (n = 0; n < 4; ++n) {
                    this.winningCells[n].row = n5;
                    this.winningCells[n].column = n4 - n;
                    c = this.board[n5][n4 - n];
                    if (c == 'X') {
                        ++n3;
                        continue;
                    }
                    if (c != 'O') continue;
                    ++n2;
                }
                if (n3 == 4) {
                    this.winnerFound = true;
                    return 'X';
                }
                if (n2 != 4) continue;
                this.winnerFound = true;
                return 'O';
            }
        }
        for (n5 = 0; n5 < 7; ++n5) {
            for (n4 = 3; n4 < 6; ++n4) {
                n3 = 0;
                n2 = 0;
                for (n = 0; n < 4; ++n) {
                    this.winningCells[n].row = n4 - n;
                    this.winningCells[n].column = n5;
                    c = this.board[n4 - n][n5];
                    if (c == 'X') {
                        ++n3;
                        continue;
                    }
                    if (c != 'O') continue;
                    ++n2;
                }
                if (n3 == 4) {
                    this.winnerFound = true;
                    return 'X';
                }
                if (n2 != 4) continue;
                this.winnerFound = true;
                return 'O';
            }
        }
        for (n5 = 2; n5 >= 0; --n5) {
            for (n4 = 3; n4 >= 0; --n4) {
                n3 = 0;
                n2 = 0;
                for (n = 3; n >= 0; --n) {
                    this.winningCells[n].row = n5 + n;
                    this.winningCells[n].column = n4 + n;
                    c = this.board[n5 + n][n4 + n];
                    if (c == 'X') {
                        ++n3;
                        continue;
                    }
                    if (c != 'O') continue;
                    ++n2;
                }
                if (n3 == 4) {
                    this.winnerFound = true;
                    return 'X';
                }
                if (n2 != 4) continue;
                this.winnerFound = true;
                return 'O';
            }
        }
        for (n5 = 2; n5 >= 0; --n5) {
            for (n4 = 3; n4 >= 0; --n4) {
                n3 = 0;
                n2 = 0;
                for (n = 3; n >= 0; --n) {
                    this.winningCells[n].row = n5 + n;
                    this.winningCells[n].column = n4 - n + 3;
                    c = this.board[n5 + n][n4 - n + 3];
                    if (c == 'X') {
                        ++n3;
                        continue;
                    }
                    if (c != 'O') continue;
                    ++n2;
                }
                if (n3 == 4) {
                    this.winnerFound = true;
                    return 'X';
                }
                if (n2 != 4) continue;
                this.winnerFound = true;
                return 'O';
            }
        }
        return ' ';
    }

    private int getScoreIncrement(int n, int n2, char c) {
        if (n == n2) {
            if (c == 'X') {
                return -1;
            }
            return 1;
        }
        if (n < n2) {
            if (c == 'X') {
                return INCREMENT[n2] - INCREMENT[n];
            }
            return INCREMENT[n2 + 1] - INCREMENT[n];
        }
        if (c == 'X') {
            return -INCREMENT[n + 1] + INCREMENT[n2];
        }
        return -INCREMENT[n] + INCREMENT[n2];
    }

    public boolean redWinFound() {
        return this.redWinFound;
    }

    public boolean blackWinFound() {
        return this.blackWinFound;
    }

    public int getHeuristicScore(char c, int n, int n2, int n3) {
        char c2;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 0;
        int n10 = this.firstAvailableRow[n] + 1;
        this.blackWinFound = false;
        this.redWinFound = false;
        int n11 = 0;
        int n12 = 0;
        char[] cArray = this.board[n10];
        int n13 = n - 3;
        int n14 = n13 >= 0 ? n13 : 0;
        int n15 = 4 - (n14 - n13);
        for (n8 = n14; n8 < n15; ++n8) {
            n11 = 0;
            n12 = 0;
            for (n7 = 0; n7 < 4; ++n7) {
                n6 = cArray[n8 + n7];
                if (n6 == 88) {
                    ++n12;
                    continue;
                }
                if (n6 != 79) continue;
                ++n11;
            }
            if (n12 == 4) {
                this.redWinFound = true;
                if (n2 <= 2) {
                    return -2147483647;
                }
            } else if (n11 == 4) {
                this.blackWinFound = true;
                if (n2 <= 2) {
                    return 0x7FFFFFFE;
                }
            }
            n9 += this.getScoreIncrement(n12, n11, c);
        }
        n11 = 0;
        n12 = 0;
        n8 = Math.min(6, n10 + 4);
        for (n7 = n10; n7 < n8; ++n7) {
            n6 = this.board[n7][n];
            if (n6 == 88) {
                ++n12;
                continue;
            }
            if (n6 != 79) continue;
            ++n11;
        }
        if (n12 == 4) {
            this.redWinFound = true;
            if (n2 <= 2) {
                return -2147483647;
            }
        } else if (n11 == 4) {
            this.blackWinFound = true;
            if (n2 <= 2) {
                return 0x7FFFFFFE;
            }
        }
        n9 += this.getScoreIncrement(n12, n11, c);
        n7 = Math.min(n10, n);
        n6 = n10 - n7;
        n14 = n - n7;
        int n16 = n6;
        for (n5 = n14; n16 <= 2 && n5 <= 3; ++n16, ++n5) {
            n11 = 0;
            n12 = 0;
            for (n4 = 0; n4 < 4; ++n4) {
                c2 = this.board[n16 + n4][n5 + n4];
                if (c2 == 'X') {
                    ++n12;
                    continue;
                }
                if (c2 != 'O') continue;
                ++n11;
            }
            if (n12 == 4) {
                this.redWinFound = true;
                if (n2 <= 2) {
                    return -2147483647;
                }
            } else if (n11 == 4) {
                this.blackWinFound = true;
                if (n2 <= 2) {
                    return 0x7FFFFFFE;
                }
            }
            n9 += this.getScoreIncrement(n12, n11, c);
        }
        n7 = Math.min(5 - n10, n);
        n6 = n10 + n7;
        n14 = n - n7;
        n16 = n6;
        for (n5 = n14; n16 >= 3 && n5 <= 3; --n16, ++n5) {
            n11 = 0;
            n12 = 0;
            for (n4 = 0; n4 < 4; ++n4) {
                c2 = this.board[n16 - n4][n5 + n4];
                if (c2 == 'X') {
                    ++n12;
                    continue;
                }
                if (c2 != 'O') continue;
                ++n11;
            }
            if (n12 == 4) {
                this.redWinFound = true;
                if (n2 <= 2) {
                    return -2147483647;
                }
            } else if (n11 == 4) {
                this.blackWinFound = true;
                if (n2 <= 2) {
                    return 0x7FFFFFFE;
                }
            }
            n9 += this.getScoreIncrement(n12, n11, c);
        }
        return n9;
    }

    public boolean isFull() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (this.board[i][j] != ' ') continue;
                return false;
            }
        }
        return true;
    }
}

