/*
 * Decompiled with CFR 0.152.
 */
import gnu.getopt.Getopt;
import java.text.NumberFormat;
import java.util.Scanner;

public class ConnectFour {
    private static final NumberFormat nf = NumberFormat.getInstance();
    private final Board board;
    private char player;
    private final int gameType;
    private final int maxDepth;
    private int plays;
    private static Scanner input = new Scanner(System.in);

    public ConnectFour(int n, int n2) throws IllegalArgumentException {
        this.gameType = n;
        this.maxDepth = n2;
        this.player = (char)88;
        this.plays = 0;
        this.board = new Board();
    }

    public int getRows() {
        return 6;
    }

    public int getGameType() {
        return this.gameType;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public int getPlays() {
        return this.plays;
    }

    public int getMaxPlays() {
        return 42;
    }

    public char getPlayer() {
        return this.player;
    }

    public Board getBoard() {
        return this.board;
    }

    public void displayBoard() {
        this.board.display();
    }

    public void switchPlayers() {
        this.player = this.player == 'O' ? (char)88 : (char)79;
    }

    public char getWinner() {
        return this.board.getWinner();
    }

    public void dropChecker(int n, char c) throws IllegalArgumentException {
        if (c != 'X' && c != 'O') {
            throw new IllegalArgumentException("Invalid player '" + c + "' attempting to mark board.");
        }
        if (n < 0 || n >= 7) {
            throw new IllegalArgumentException("Invalid column " + n + " received.");
        }
        this.board.set(n, c);
        ++this.plays;
    }

    public static int getColumn(char c, int n) throws IllegalArgumentException {
        String string = Board.getColorOfPlayer(c);
        System.out.print("Drop a " + string + " checker at column (1.." + n + "): ");
        int n2 = 0;
        String string2 = input.nextLine().trim();
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid column '" + string2 + "' received.");
        }
        if (n2 < 1 || n2 > n) {
            throw new IllegalArgumentException("Invalid column " + n2 + " received.");
        }
        return n2 - 1;
    }

    public static String getHelp(String string) {
        StringBuilder stringBuilder = new StringBuilder("Usage: java " + string + " [options]\n");
        stringBuilder.append("   -g game type [1-4], where\n");
        stringBuilder.append("      1 = HUMAN vs. HUMAN\n");
        stringBuilder.append("      2 = HUMAN vs. COMPUTER [default]\n");
        stringBuilder.append("      3 = COMPUTER vs. HUMAN\n");
        stringBuilder.append("      4 = COMPUTER vs. COMPUTER\n");
        stringBuilder.append("   -m difficulty level [1-4], where\n");
        stringBuilder.append("      1 = BEGINNER\n");
        stringBuilder.append("      2 = INTERMEDIATE\n");
        stringBuilder.append("      3 = ADVANCED\n");
        stringBuilder.append("      4 = EXPERT [default]");
        return stringBuilder.toString();
    }

    private static ConnectFourConfig parseArgs(String string, String[] stringArray) {
        int n;
        Getopt getopt = new Getopt(string, stringArray, "g:hm:");
        getopt.setOpterr(false);
        int n2 = 2;
        int n3 = 4;
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 103: {
                    String string2 = getopt.getOptarg();
                    try {
                        n2 = Integer.parseInt(string2);
                        if (n2 < 1 || n2 > 4) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println(string + ": Invalid game type '" + string2 + "'.");
                        System.exit(1);
                    }
                    break;
                }
                case 104: {
                    System.out.println(ConnectFour.getHelp(string));
                    System.exit(0);
                }
                case 100: {
                    String string2 = getopt.getOptarg();
                    try {
                        n3 = Integer.parseInt(string2);
                        if (n3 < 1 || n3 > 4) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println(string + ": Invalid max depth '" + string2 + "'.");
                        System.exit(1);
                    }
                    break;
                }
                case 63: {
                    System.err.println(string + ": Unknown option '" + (char)getopt.getOptopt() + "' received.");
                    System.exit(1);
                }
            }
        }
        return new ConnectFourConfig(n2, n3);
    }

    private static void doPlayerMove(char c, ConnectFour connectFour) {
        while (true) {
            try {
                int n = ConnectFour.getColumn(c, 7);
                connectFour.dropChecker(n, c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("Error: " + illegalArgumentException.getMessage());
                continue;
            }
            catch (Exception exception) {
                System.exit(1);
                continue;
            }
            break;
        }
    }

    private static void doComputerMove(char c, ConnectFour connectFour) {
        Minimax minimax = new Minimax(connectFour.getBoard(), connectFour.getMaxDepth());
        long l = System.currentTimeMillis();
        int n = minimax.alphaBeta(c);
        double d = (double)(System.currentTimeMillis() - l) / 1000.0;
        int n2 = minimax.getBoardsAnalyzed();
        System.out.print("Computer chose column " + (n + 1) + "; " + nf.format(n2));
        if (n2 != 1) {
            System.out.println(" boards analyzed in " + d + " seconds.");
        } else {
            System.out.println(" board analyzed in " + d + " seconds.");
        }
        connectFour.dropChecker(n, c);
    }

    public static void main(String[] stringArray) {
        ConnectFourConfig connectFourConfig = ConnectFour.parseArgs("ConnectFour", stringArray);
        ConnectFour connectFour = null;
        try {
            connectFour = new ConnectFour(connectFourConfig.getGameType(), connectFourConfig.getMaxDepth());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Error: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        connectFour.displayBoard();
        int n = connectFour.getMaxPlays();
        int n2 = connectFour.getPlays();
        int n3 = connectFour.getGameType();
        while (n2 < n) {
            char c = connectFour.getPlayer();
            if (n2 % 2 == 0) {
                if (n3 == 1 || n3 == 2) {
                    ConnectFour.doPlayerMove(c, connectFour);
                } else {
                    ConnectFour.doComputerMove(c, connectFour);
                }
            } else if (n3 == 1 || n3 == 3) {
                ConnectFour.doPlayerMove(c, connectFour);
            } else {
                ConnectFour.doComputerMove(c, connectFour);
            }
            connectFour.displayBoard();
            char c2 = connectFour.getWinner();
            if (c2 != ' ') {
                System.out.println("Player " + c2 + " wins.");
                return;
            }
            connectFour.switchPlayers();
            n2 = connectFour.getPlays();
        }
        System.out.println("Tie.");
        input.close();
    }
}

