/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;

public class GUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final ApplicationStarter applicationStarter;
    private final ConnectFourConfig config;
    private final GamePanel gamePanel;
    private final JLabel statusLabel;
    private final JLabel gameTypeDifficultyLabel;
    private JRadioButtonMenuItem humanComputerItem;
    private JRadioButtonMenuItem computerHumanItem;
    private JRadioButtonMenuItem twoPlayerItem;
    private JRadioButtonMenuItem beginnerItem;
    private JRadioButtonMenuItem intermediateItem;
    private JRadioButtonMenuItem advancedItem;
    private JRadioButtonMenuItem expertItem;
    private JRadioButtonMenuItem selectedGameType;
    private JRadioButtonMenuItem selectedDifficultyLevel;
    private JCheckBoxMenuItem showMoveNumbersItem;
    private JMenu difficultyLevelMenu;
    private ButtonGroup gameTypeGroup;
    private ButtonGroup difficultyLevelGroup;

    public GUI(ApplicationStarter applicationStarter) {
        super("Connect Four");
        this.applicationStarter = applicationStarter;
        this.config = new ConnectFourConfig(2, 4);
        this.setJMenuBar(this.getCreatedMenuBar());
        this.statusLabel = new JLabel("Welcome to Connect Four.");
        this.gameTypeDifficultyLabel = new JLabel(this.getGameTypeDifficultyStatus());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new BevelBorder(1));
        jPanel.add((Component)this.statusLabel, gridBagConstraints);
        jPanel.setPreferredSize(new Dimension(250, 25));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new BevelBorder(1));
        jPanel2.add((Component)this.gameTypeDifficultyLabel, gridBagConstraints);
        jPanel2.setPreferredSize(new Dimension(190, 25));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        this.gamePanel = new GamePanel(this.config, this.statusLabel);
        Container container = this.getContentPane();
        container.add((Component)this.gamePanel, "Center");
        container.add((Component)jPanel3, "Last");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new ClosingWindowListener(this.gamePanel));
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.setFocusable(true);
        this.requestFocus();
        this.gamePanel.requestFocusInWindow();
    }

    private String getGameTypeDifficultyStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.config.getGameType();
        if (n == 2) {
            stringBuilder.append("Human vs. Computer");
        } else if (n == 3) {
            stringBuilder.append("Computer vs. Human");
        } else {
            stringBuilder.append("Two player");
        }
        if (n != 1) {
            int n2 = this.config.getDifficultyLevel();
            switch (n2) {
                case 1: {
                    stringBuilder.append(", Beginner");
                    break;
                }
                case 2: {
                    stringBuilder.append(", Intermediate");
                    break;
                }
                case 3: {
                    stringBuilder.append(", Advanced");
                    break;
                }
                default: {
                    stringBuilder.append(", Expert");
                }
            }
        }
        return stringBuilder.toString();
    }

    private JMenuBar getCreatedMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        JMenuItem jMenuItem = new JMenuItem("New Game");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(78, 8);
        jMenuItem.setAccelerator(keyStroke);
        jMenuItem.setMnemonic(78);
        jMenuItem.addActionListener(new NewActionListener());
        jMenu.add(jMenuItem);
        jMenu.add(new JSeparator());
        JMenuItem jMenuItem2 = new JMenuItem("Exit");
        keyStroke = KeyStroke.getKeyStroke(88, 8);
        jMenuItem2.setAccelerator(keyStroke);
        jMenuItem2.setMnemonic(88);
        jMenuItem2.addActionListener(new ExitActionListener());
        jMenu.add(jMenuItem2);
        JMenu jMenu2 = new JMenu("Options");
        jMenu2.setMnemonic('O');
        JMenu jMenu3 = new JMenu("Game Type");
        jMenu3.setMnemonic('G');
        this.humanComputerItem = new JRadioButtonMenuItem("Human vs. Computer", true);
        this.humanComputerItem.setMnemonic('H');
        this.humanComputerItem.addActionListener(new GameTypeActionListener(this));
        this.selectedGameType = this.humanComputerItem;
        this.computerHumanItem = new JRadioButtonMenuItem("Computer vs. Human", false);
        this.computerHumanItem.setMnemonic('C');
        this.computerHumanItem.addActionListener(new GameTypeActionListener(this));
        this.twoPlayerItem = new JRadioButtonMenuItem("Two Player", false);
        this.twoPlayerItem.setMnemonic('T');
        this.twoPlayerItem.addActionListener(new GameTypeActionListener(this));
        jMenu3.add(this.humanComputerItem);
        jMenu3.add(this.computerHumanItem);
        jMenu3.add(this.twoPlayerItem);
        this.gameTypeGroup = new ButtonGroup();
        this.gameTypeGroup.add(this.humanComputerItem);
        this.gameTypeGroup.add(this.computerHumanItem);
        this.gameTypeGroup.add(this.twoPlayerItem);
        this.difficultyLevelMenu = new JMenu("Difficulty Level");
        this.difficultyLevelMenu.setMnemonic('D');
        this.beginnerItem = new JRadioButtonMenuItem("Beginner", false);
        this.beginnerItem.setMnemonic('B');
        this.beginnerItem.addActionListener(new DifficultyLevelActionListener(this));
        this.intermediateItem = new JRadioButtonMenuItem("Intermediate", false);
        this.intermediateItem.setMnemonic('I');
        this.intermediateItem.addActionListener(new DifficultyLevelActionListener(this));
        this.advancedItem = new JRadioButtonMenuItem("Advanced", false);
        this.advancedItem.setMnemonic('A');
        this.advancedItem.addActionListener(new DifficultyLevelActionListener(this));
        this.expertItem = new JRadioButtonMenuItem("Expert", true);
        this.expertItem.setMnemonic('E');
        this.expertItem.addActionListener(new DifficultyLevelActionListener(this));
        this.selectedDifficultyLevel = this.expertItem;
        this.difficultyLevelMenu.add(this.beginnerItem);
        this.difficultyLevelMenu.add(this.intermediateItem);
        this.difficultyLevelMenu.add(this.advancedItem);
        this.difficultyLevelMenu.add(this.expertItem);
        this.difficultyLevelGroup = new ButtonGroup();
        this.difficultyLevelGroup.add(this.beginnerItem);
        this.difficultyLevelGroup.add(this.intermediateItem);
        this.difficultyLevelGroup.add(this.advancedItem);
        this.difficultyLevelGroup.add(this.expertItem);
        this.showMoveNumbersItem = new JCheckBoxMenuItem("Show Move Numbers");
        this.showMoveNumbersItem.setMnemonic(78);
        this.showMoveNumbersItem.addActionListener(new ShowMoveNumbersActionListener());
        jMenu2.add(jMenu3);
        jMenu2.add(this.difficultyLevelMenu);
        jMenu2.add(this.showMoveNumbersItem);
        JMenuItem jMenuItem3 = new JMenuItem("About");
        jMenuItem3.setMnemonic('A');
        jMenuItem3.addActionListener(new AboutActionListener(this));
        JMenu jMenu4 = new JMenu("Help");
        jMenu4.setMnemonic('H');
        jMenu4.add(jMenuItem3);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu4);
        return jMenuBar;
    }

    private void doApplicationClosing() {
        if (this.applicationStarter != null) {
            this.gamePanel.stopGame();
            this.applicationStarter.close();
        } else {
            System.exit(0);
        }
    }

    class AboutActionListener
    implements ActionListener {
        private final JFrame parent;

        public AboutActionListener(JFrame jFrame) {
            this.parent = jFrame;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = new String[]{"Version 1.2.0", "\u00a9 2012-2014 Brian S. Borowski", "All Rights Reserved.", "Build: August 6, 2014"};
            new AboutDialog(this.parent, "Connect Four", stringArray, "images/icon.png");
        }
    }

    class ShowMoveNumbersActionListener
    implements ActionListener {
        ShowMoveNumbersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.gamePanel.setShowMoveNumbers(GUI.this.showMoveNumbersItem.getState());
            GUI.this.gamePanel.repaint();
        }
    }

    class DifficultyLevelActionListener
    implements ActionListener {
        private JFrame parent;

        public DifficultyLevelActionListener(JFrame jFrame) {
            this.parent = jFrame;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            boolean bl = GUI.this.gamePanel.isRunning();
            if (bl && (n = JOptionPane.showConfirmDialog(this.parent, "Changing the difficulty level at this time will\nrequire you to abort the current game.\nAbort game and apply settings now?\n", "Question", 0)) == 1) {
                GUI.this.selectedDifficultyLevel.setSelected(true);
                return;
            }
            Object object = actionEvent.getSource();
            if (object == GUI.this.beginnerItem) {
                GUI.this.config.setDifficulty(1);
                GUI.this.selectedDifficultyLevel = GUI.this.beginnerItem;
            } else if (object == GUI.this.intermediateItem) {
                GUI.this.config.setDifficulty(2);
                GUI.this.selectedDifficultyLevel = GUI.this.intermediateItem;
            } else if (object == GUI.this.advancedItem) {
                GUI.this.config.setDifficulty(3);
                GUI.this.selectedDifficultyLevel = GUI.this.advancedItem;
            } else {
                GUI.this.config.setDifficulty(4);
                GUI.this.selectedDifficultyLevel = GUI.this.expertItem;
            }
            GUI.this.gameTypeDifficultyLabel.setText(GUI.this.getGameTypeDifficultyStatus());
            if (bl) {
                GUI.this.gamePanel.reset();
            }
        }
    }

    class GameTypeActionListener
    implements ActionListener {
        private JFrame parent;

        public GameTypeActionListener(JFrame jFrame) {
            this.parent = jFrame;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            boolean bl = GUI.this.gamePanel.isRunning();
            if (bl && (n = JOptionPane.showConfirmDialog(this.parent, "Changing the game type level at this time will\nrequire you to abort the current game.\nAbort game and apply settings now?\n", "Question", 0)) == 1) {
                GUI.this.selectedGameType.setSelected(true);
                return;
            }
            Object object = actionEvent.getSource();
            if (object == GUI.this.twoPlayerItem) {
                GUI.this.difficultyLevelMenu.setEnabled(false);
                GUI.this.config.setGameType(1);
                GUI.this.selectedGameType = GUI.this.twoPlayerItem;
            } else {
                GUI.this.difficultyLevelMenu.setEnabled(true);
                if (object == GUI.this.humanComputerItem) {
                    GUI.this.config.setGameType(2);
                    GUI.this.selectedGameType = GUI.this.humanComputerItem;
                } else {
                    GUI.this.config.setGameType(3);
                    GUI.this.selectedGameType = GUI.this.computerHumanItem;
                }
            }
            GUI.this.gameTypeDifficultyLabel.setText(GUI.this.getGameTypeDifficultyStatus());
            if (bl) {
                GUI.this.gamePanel.reset();
            }
        }
    }

    class NewActionListener
    implements ActionListener {
        NewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.gamePanel.reset();
        }
    }

    class ExitActionListener
    implements ActionListener {
        ExitActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.doApplicationClosing();
        }
    }

    class ClosingWindowListener
    implements WindowListener {
        private final GamePanel gamePanel;

        public ClosingWindowListener(GamePanel gamePanel) {
            this.gamePanel = gamePanel;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.gamePanel.stopGame();
            GUI.this.doApplicationClosing();
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

