/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GamePanel
extends JPanel
implements KeyListener,
Runnable {
    private static final long serialVersionUID = 1L;
    private static final NumberFormat nf = NumberFormat.getInstance();
    private final Image cellImage;
    private final Image blackCheckerImage;
    private final Image redCheckerImage;
    private final Image grayCheckerImage;
    private final Image pinkCheckerImage;
    private final int cellSize;
    private final int width;
    private final int height;
    private final Font largeFont = new Font("Dialog", 0, 40);
    private final Font smallFont = new Font("Dialog", 1, 15);
    private final Font numberFont = new Font("Dialog", 1, 14);
    private final String[] help = new String[]{"Use the LEFT and RIGHT arrows to position the checker.", "Use the DOWN arrow to drop the checker.", "Go to File -> New Game to start playing."};
    private ConnectFour connectFour;
    private char[][] grid;
    private boolean isPlayerTurn;
    private boolean isComputerTurn;
    private boolean displayHelp;
    private boolean showMoveNumbers;
    private volatile boolean isRunning;
    private volatile boolean isChoiceMade;
    private int checkerColumn;
    private int yCoord;
    private ConnectFourConfig config;
    private Thread thread;
    private JLabel statusLabel;
    private String resultString;

    public GamePanel(ConnectFourConfig connectFourConfig, JLabel jLabel) {
        this.config = connectFourConfig;
        this.statusLabel = jLabel;
        this.cellImage = Utility.getImage("images/cell.png");
        this.blackCheckerImage = Utility.getImage("images/blackchecker.png");
        this.redCheckerImage = Utility.getImage("images/redchecker.png");
        this.grayCheckerImage = Utility.getImage("images/graychecker.png");
        this.pinkCheckerImage = Utility.getImage("images/pinkchecker.png");
        this.cellSize = this.cellImage.getHeight(null);
        this.width = this.cellImage.getWidth(null) * 7;
        this.height = this.cellSize * 7;
        this.displayHelp = true;
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.addKeyListener(this);
        this.setFocusable(true);
        this.repaint();
    }

    public void startGame() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
        this.grid = null;
        this.displayHelp = false;
        this.isRunning = true;
    }

    public void stopGame() {
        this.isRunning = false;
        try {
            if (this.thread != null) {
                this.thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    public void reset() {
        this.stopGame();
        this.statusLabel.setText("Welcome to Connect Four.");
        this.resultString = null;
        this.connectFour = new ConnectFour(this.config.getGameType(), this.config.getMaxDepth());
        this.startGame();
        this.repaint();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setShowMoveNumbers(boolean bl) {
        this.showMoveNumbers = bl;
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void animateMove(int n) {
        int n2 = this.cellSize * (this.connectFour.getBoard().getFirstAvailableRow(n) + 1);
        while (this.isRunning) {
            ++this.yCoord;
            this.repaint();
            if (this.yCoord >= n2) break;
            this.sleep(1);
        }
    }

    private void doPlayerMove(char c) {
        this.isPlayerTurn = true;
        this.isChoiceMade = false;
        this.yCoord = 0;
        this.checkerColumn = 3;
        this.repaint();
        while (this.isRunning) {
            this.sleep(50);
            if (!this.isChoiceMade) continue;
            if (this.connectFour.getBoard().isColumnAvailable(this.checkerColumn)) {
                this.animateMove(this.checkerColumn);
                this.connectFour.dropChecker(this.checkerColumn, c);
                this.grid = this.connectFour.getBoard().getGrid();
                break;
            }
            this.isChoiceMade = false;
        }
        this.isPlayerTurn = false;
    }

    private void doComputerMove(char c) {
        this.isComputerTurn = true;
        this.yCoord = 0;
        this.checkerColumn = 3;
        this.repaint();
        Minimax minimax = new Minimax(this.connectFour.getBoard(), this.connectFour.getMaxDepth());
        long l = System.currentTimeMillis();
        int n = minimax.alphaBeta(c);
        double d = (double)(System.currentTimeMillis() - l) / 1000.0;
        int n2 = minimax.getBoardsAnalyzed();
        String string = n2 != 1 ? nf.format(n2) + " boards analyzed in " + d + " seconds." : nf.format(n2) + " board analyzed in " + d + " seconds.";
        this.statusLabel.setText(string);
        while (this.checkerColumn < n) {
            this.sleep(200);
            ++this.checkerColumn;
            this.repaint();
        }
        while (this.checkerColumn > n) {
            this.sleep(200);
            --this.checkerColumn;
            this.repaint();
        }
        this.sleep(200);
        this.checkerColumn = n;
        this.animateMove(n);
        this.connectFour.dropChecker(n, c);
        this.grid = this.connectFour.getBoard().getGrid();
        this.isComputerTurn = false;
    }

    @Override
    public void run() {
        this.connectFour = new ConnectFour(this.config.getGameType(), this.config.getMaxDepth());
        int n = this.connectFour.getMaxPlays();
        int n2 = this.connectFour.getPlays();
        int n3 = this.connectFour.getGameType();
        while (n2 < n && this.isRunning) {
            char c = this.connectFour.getPlayer();
            if (n2 % 2 == 0) {
                if (n3 == 1 || n3 == 2) {
                    this.doPlayerMove(c);
                } else {
                    this.doComputerMove(c);
                }
            } else if (n3 == 1 || n3 == 3) {
                this.doPlayerMove(c);
            } else {
                this.doComputerMove(c);
            }
            char c2 = this.connectFour.getWinner();
            if (c2 != ' ') {
                Cell[] cellArray;
                for (Cell cell : cellArray = this.connectFour.getBoard().getWinningCells()) {
                    this.grid[cell.row][cell.column] = c2 == 'O' ? 71 : 80;
                }
                if (n3 == 1) {
                    this.resultString = Board.getColorOfPlayer(c2) + " wins!";
                } else if (n3 == 2 && c2 == 'X' || n3 == 3 && c2 == 'O') {
                    this.resultString = "You win!";
                } else if (n3 == 2 && c2 == 'O' || n3 == 3 && c2 == 'X') {
                    this.resultString = "Computer wins.";
                }
                this.repaint();
                this.isRunning = false;
                return;
            }
            this.connectFour.switchPlayers();
            n2 = this.connectFour.getPlays();
        }
        if (this.isRunning) {
            this.resultString = "Tie.";
            this.repaint();
        }
        this.isRunning = false;
    }

    private void displayDirections(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setFont(this.smallFont);
        graphics2D.setColor(Color.BLACK);
        int n = 24;
        for (String string : this.help) {
            int n2 = graphics2D.getFontMetrics().charsWidth(string.toCharArray(), 0, string.length());
            graphics2D.drawString(string, this.width - n2 >> 1, n);
            n += 20;
        }
    }

    private void displayResult(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setFont(this.largeFont);
        graphics2D.setColor(Color.BLACK);
        int n = graphics2D.getFontMetrics().charsWidth(this.resultString.toCharArray(), 0, this.resultString.length());
        graphics2D.drawString(this.resultString, this.width - n >> 1, 50);
    }

    private void displayBoard(Graphics2D graphics2D) {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                graphics2D.drawImage(this.cellImage, this.cellSize * j, this.cellSize * (i + 1), this);
            }
        }
    }

    private void displayMoveNumbers(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setFont(this.numberFont);
        graphics2D.setColor(Color.WHITE);
        int n = graphics2D.getFontMetrics().getAscent() - graphics2D.getFontMetrics().getDescent();
        int[][] nArray = this.connectFour.getBoard().getMoveNumbers();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                int n2 = nArray[i][j];
                if (n2 == 0) continue;
                String string = String.valueOf(n2);
                int n3 = graphics2D.getFontMetrics().charsWidth(string.toCharArray(), 0, string.length());
                graphics2D.drawString(string, this.cellSize * j + (this.cellSize - n3 >> 1), this.cellSize * (i + 1) + (this.cellSize + n >> 1));
            }
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.width, this.height);
        if (this.isPlayerTurn || this.isComputerTurn) {
            Image image = this.connectFour.getPlayer() == 'O' ? this.blackCheckerImage : this.redCheckerImage;
            graphics2D.drawImage(image, this.cellSize * this.checkerColumn, this.yCoord, this);
        }
        if (this.grid != null) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 7; ++j) {
                    char c = this.grid[i][j];
                    if (c == 'O') {
                        graphics2D.drawImage(this.blackCheckerImage, this.cellSize * j, this.cellSize * (i + 1), this);
                        continue;
                    }
                    if (c == 'X') {
                        graphics2D.drawImage(this.redCheckerImage, this.cellSize * j, this.cellSize * (i + 1), this);
                        continue;
                    }
                    if (c == 'G') {
                        graphics2D.drawImage(this.grayCheckerImage, this.cellSize * j, this.cellSize * (i + 1), this);
                        continue;
                    }
                    if (c != 'P') continue;
                    graphics2D.drawImage(this.pinkCheckerImage, this.cellSize * j, this.cellSize * (i + 1), this);
                }
            }
        }
        if (this.displayHelp) {
            this.displayDirections(graphics2D);
        } else if (this.resultString != null) {
            this.displayResult(graphics2D);
        }
        this.displayBoard(graphics2D);
        if (this.showMoveNumbers && this.grid != null) {
            this.displayMoveNumbers(graphics2D);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.isPlayerTurn && !this.isChoiceMade) {
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    if (this.checkerColumn != 0) {
                        --this.checkerColumn;
                    }
                    this.repaint();
                    break;
                }
                case 39: {
                    if (this.checkerColumn != 6) {
                        ++this.checkerColumn;
                    }
                    this.repaint();
                    break;
                }
                case 40: {
                    this.isChoiceMade = true;
                    break;
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

