/*
 * Decompiled with CFR 0.152.
 */
public class Minimax {
    private final Board board;
    private int column;
    private int boardsAnalyzed;
    private int maxDepth;
    private boolean redWinFound;
    private boolean blackWinFound;

    public Minimax(Board board, int n) {
        this.board = board;
        this.boardsAnalyzed = 0;
        this.maxDepth = n;
    }

    public int getBoardsAnalyzed() {
        return this.boardsAnalyzed;
    }

    public int alphaBeta(char c) {
        this.blackWinFound = false;
        this.redWinFound = false;
        if (c == 'O') {
            this.evaluateBlackMove(0, 1, -1, -2147483647, 0x7FFFFFFE);
            if (this.blackWinFound) {
                return this.column;
            }
            this.blackWinFound = false;
            this.redWinFound = false;
            this.evaluateRedMove(0, 1, -1, -2147483647, 0x7FFFFFFE);
            if (this.redWinFound) {
                return this.column;
            }
            this.evaluateBlackMove(0, this.maxDepth, -1, -2147483647, 0x7FFFFFFE);
        } else {
            this.evaluateRedMove(0, 1, -1, -2147483647, 0x7FFFFFFE);
            if (this.redWinFound) {
                return this.column;
            }
            this.blackWinFound = false;
            this.redWinFound = false;
            this.evaluateBlackMove(0, 1, -1, -2147483647, 0x7FFFFFFE);
            if (this.blackWinFound) {
                return this.column;
            }
            this.evaluateRedMove(0, this.maxDepth, -1, -2147483647, 0x7FFFFFFE);
        }
        return this.column;
    }

    private int evaluateRedMove(int n, int n2, int n3, int n4, int n5) {
        ++this.boardsAnalyzed;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        if (n3 != -1) {
            n7 = this.board.getHeuristicScore('O', n3, n, n2);
            if (this.board.blackWinFound()) {
                this.blackWinFound = true;
                return n7;
            }
        }
        if (n == n2) {
            return n7;
        }
        for (int i = 0; i < 7; ++i) {
            if (!this.board.isColumnAvailable(i)) continue;
            this.board.mark(i, 'X');
            int n8 = this.evaluateBlackMove(n + 1, n2, i, n4, n5);
            this.board.unset(i);
            if (n8 < n6) {
                n6 = n8;
                if (n == 0) {
                    this.column = i;
                }
            }
            if (n8 < n5) {
                n5 = n8;
            }
            if (n4 < n5) continue;
            return n5;
        }
        if (n6 == Integer.MAX_VALUE) {
            return 0;
        }
        return n6;
    }

    private int evaluateBlackMove(int n, int n2, int n3, int n4, int n5) {
        ++this.boardsAnalyzed;
        int n6 = Integer.MIN_VALUE;
        int n7 = 0;
        if (n3 != -1) {
            n7 = this.board.getHeuristicScore('X', n3, n, n2);
            if (this.board.redWinFound()) {
                this.redWinFound = true;
                return n7;
            }
        }
        if (n == n2) {
            return n7;
        }
        for (int i = 0; i < 7; ++i) {
            if (!this.board.isColumnAvailable(i)) continue;
            this.board.mark(i, 'O');
            int n8 = this.evaluateRedMove(n + 1, n2, i, n4, n5);
            this.board.unset(i);
            if (n8 > n6) {
                n6 = n8;
                if (n == 0) {
                    this.column = i;
                }
            }
            if (n8 > n4) {
                n4 = n8;
            }
            if (n4 < n5) continue;
            return n4;
        }
        if (n6 == Integer.MIN_VALUE) {
            return 0;
        }
        return n6;
    }

    public static void main(String[] stringArray) {
        Board board = new Board();
        board.set(0, 'X');
        board.set(0, 'X');
        board.set(1, 'O');
        board.set(1, 'X');
        board.set(1, 'O');
        board.set(1, 'O');
        board.set(1, 'X');
        board.set(1, 'X');
        board.set(2, 'X');
        board.set(2, 'X');
        board.set(2, 'X');
        board.set(2, 'O');
        board.set(2, 'X');
        board.set(3, 'X');
        board.set(3, 'O');
        board.set(3, 'X');
        board.set(3, 'O');
        board.set(3, 'O');
        board.set(3, 'O');
        board.set(4, 'O');
        board.set(4, 'X');
        board.set(4, 'O');
        board.set(4, 'X');
        board.set(6, 'O');
        board.set(6, 'O');
        board.set(6, 'O');
        board.set(6, 'X');
        board.set(6, 'O');
        board.display();
        Minimax minimax = new Minimax(board, 8);
        char c = 'X';
        int n = minimax.alphaBeta(c);
        System.out.println("Place in column: " + n);
        System.out.println("Boards analyzed: " + minimax.getBoardsAnalyzed());
        board.set(n, c);
        board.display();
    }
}

