/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui;

import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.StyleTypes;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.ILayoutUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public enum LayoutUtils implements ILayoutUtils
{
    INSTANCE;

    private final Map<TypeDescriptor, ILayoutUtils> factories = new HashMap<TypeDescriptor, ILayoutUtils>(8);

    @Override
    public Pos getMinDim(INodeRelation relation) {
        ILayoutUtils factory = this.factories.get(relation.getTarget().getType());
        if (factory != null) {
            return factory.getMinDim(relation);
        }
        return (Pos)relation.getTarget().getProperty(PropertyDescriptors.MIN_DIMENSION);
    }

    @Override
    public TypeDescriptor getStyle(INodeRelation relation) {
        ILayoutUtils factory = this.factories.get(relation.getTarget().getType());
        if (factory != null) {
            return factory.getStyle(relation);
        }
        return StyleTypes.DEFAULT_STYLE;
    }

    public Set<TypeDescriptor> getSupportedTypes() {
        return Collections.unmodifiableSet(this.factories.keySet());
    }

    @Override
    public Class<? extends Pos> getUnit(INodeRelation relation) {
        ILayoutUtils factory = this.factories.get(relation.getTarget().getType());
        if (factory != null) {
            return factory.getUnit(relation);
        }
        return Pos.class;
    }

    @Override
    public Double getZoom(INode node) {
        ILayoutUtils factory = this.factories.get(node.getType());
        if (factory != null) {
            return factory.getZoom(node);
        }
        return 1.0;
    }

    public void register(ILayoutUtils factory) {
        Assert.isTrue((factory != null && factory.getSupportedTypes() != null ? 1 : 0) != 0, (String)"factory and supported types must not be null");
        for (TypeDescriptor supportedType : factory.getSupportedTypes()) {
            this.factories.put(supportedType, factory);
        }
    }
}

