/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui;

import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class NodeClipboard {
    private static Map<TypeDescriptor, NodeClipboard> clipboards;
    private Collection<INodeRelation> relations = Collections.emptyList();
    private boolean cut;

    public static final synchronized NodeClipboard getClipboard(TypeDescriptor type) {
        if (clipboards == null || !clipboards.containsKey(type)) {
            NodeClipboard.registerClipboard(type, new NodeClipboard());
        }
        return clipboards.get(type);
    }

    private static final synchronized void registerClipboard(TypeDescriptor type, NodeClipboard clipboard) {
        if (clipboards == null) {
            clipboards = new HashMap<TypeDescriptor, NodeClipboard>(1);
        }
        clipboards.put(type, clipboard);
    }

    public synchronized Collection<INodeRelation> getRelations() {
        return this.relations;
    }

    public synchronized boolean isCut() {
        return this.cut;
    }

    public synchronized void setCut(boolean cut) {
        this.cut = cut;
    }

    public synchronized void setRelations(Collection<INodeRelation> relations) {
        this.relations = relations == null ? Collections.emptyList() : new ArrayList<INodeRelation>(relations);
    }
}

