/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.PropertiesUndoHandler;
import com.centreon.studio.client.model.ui.actions.edit.AACLRepositoryAction;
import java.util.ArrayList;

public abstract class ABooleanPropetyNodesActions
extends AACLRepositoryAction {
    private final PropertyDescriptor<Boolean> descriptor;
    private final String trueText;
    private final String falseText;

    public ABooleanPropetyNodesActions(IRepository input, PropertyDescriptor<Boolean> descriptor, String trueText, String falseText) {
        super("", input);
        this.descriptor = descriptor;
        this.trueText = trueText;
        this.falseText = falseText;
        this.setSelectionMultiAccepted(true);
        this.setSelectionSingleAccepted(true);
        this.setACLRightNeeded((PropertyDescriptor<Boolean>)ACLPropertyDescriptors.CAN_UPDATE);
    }

    public abstract int getAccelerator();

    public final String getText() {
        if (this.getValue()) {
            return this.trueText;
        }
        return this.falseText;
    }

    @Override
    protected final boolean customIsEnabled() {
        return true;
    }

    @Override
    protected abstract String getImageDescriptorPath();

    protected boolean getValue() {
        Boolean singleValue = null;
        for (INodeRelation relation : this.getInput().getSelections()) {
            boolean v = (Boolean)relation.getTarget().getProperty(this.descriptor);
            if (singleValue == null) {
                singleValue = v;
                continue;
            }
            if (singleValue == v) continue;
            return (Boolean)this.descriptor.defaulValue == false;
        }
        return singleValue == null ? !((Boolean)this.descriptor.defaulValue).booleanValue() : singleValue == false;
    }

    @Override
    protected final IUndoHandler internalRun() {
        boolean value = this.getValue();
        ArrayList<INode> nodes = new ArrayList<INode>(this.getInput().getSelections().size());
        for (INodeRelation selection : this.getInput().getSelections()) {
            nodes.add(selection.getTarget());
        }
        PropertiesUndoHandler undo = new PropertiesUndoHandler(nodes, this.descriptor);
        for (INode node : nodes) {
            node.addPropertyValue(this.descriptor, (Object)value);
        }
        return undo;
    }
}

