/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.common;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.actions.common.AbstractUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.RemoveNodeRelationUndoHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CreateNodeRelationUndoHandler
extends AbstractUndoHandler {
    protected final Map<WeakReference<INode>, Collection<INodeRelation>> parentToRelationsToRemove;
    private final Set<Long> previousIds = new HashSet<Long>();

    public CreateNodeRelationUndoHandler(Map<WeakReference<INode>, Collection<INodeRelation>> parentToCreateRelation) {
        this.parentToRelationsToRemove = new HashMap<WeakReference<INode>, Collection<INodeRelation>>();
        for (Map.Entry<WeakReference<INode>, Collection<INodeRelation>> entry : parentToCreateRelation.entrySet()) {
            INode parent = (INode)entry.getKey().get();
            if (parent == null) continue;
            for (INodeRelation relation : entry.getValue()) {
                Long previousId = (Long)relation.getProperty(PropertyDescriptors.PREVIOUS_ID);
                if (previousId == null) continue;
                this.previousIds.add((Long)relation.getProperty(PropertyDescriptors.PREVIOUS_ID));
            }
            this.parentToRelationsToRemove.put(entry.getKey(), new ArrayList(entry.getValue().size()));
            parent.registerRelationsListener((INodeRelationListener)this);
        }
    }

    @Override
    public void relationsAdded(INode node, Collection<INodeRelation> relations) {
        for (Map.Entry<WeakReference<INode>, Collection<INodeRelation>> entry : this.parentToRelationsToRemove.entrySet()) {
            INode parent = (INode)entry.getKey().get();
            if (parent == null || !parent.equals((Object)node)) continue;
            for (INodeRelation relation : relations) {
                if (!this.previousIds.contains(relation.getProperty(PropertyDescriptors.PREVIOUS_ID))) continue;
                entry.getValue().add(relation);
            }
        }
        node.unregisterRelationsListener((INodeRelationListener)this);
    }

    @Override
    public IUndoHandler undo() {
        for (Map.Entry<WeakReference<INode>, Collection<INodeRelation>> entry : this.parentToRelationsToRemove.entrySet()) {
            INode parent = (INode)entry.getKey().get();
            if (parent == null) continue;
            parent.removeRelations(entry.getValue());
        }
        return new RemoveNodeRelationUndoHandler(this.parentToRelationsToRemove);
    }
}

