/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.common;

import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.ui.actions.common.AbstractUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;

public class PropertiesUndoHandler
extends AbstractUndoHandler {
    private final Map<IObject, Collection<PropertyValue>> references;
    private final PropertyDescriptor<?>[] descriptors;
    private final boolean removeNotFound;

    public PropertiesUndoHandler(Collection<? extends IObject> objects, PropertyDescriptor<?> ... descriptors) {
        this.references = new WeakHashMap<IObject, Collection<PropertyValue>>(objects.size());
        this.descriptors = descriptors;
        this.removeNotFound = descriptors.length == 0;
        for (IObject iObject : objects) {
            ArrayList<PropertyValue> values;
            if (descriptors.length > 0) {
                values = new ArrayList<PropertyValue>(descriptors.length);
                PropertyDescriptor<?>[] propertyDescriptorArray = descriptors;
                int n = descriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor<?> descriptor = propertyDescriptorArray[n2];
                    values.add(PropertyValue.unchecked(descriptor, (Object)iObject.getProperty(descriptor)));
                    ++n2;
                }
            } else {
                values = iObject.getPropertyValues();
            }
            this.references.put(iObject, values);
        }
    }

    public PropertiesUndoHandler(IObject object, PropertyDescriptor<?> ... descriptors) {
        this(Arrays.asList(object), descriptors);
    }

    @Override
    public Map<IObject, Collection<PropertyValue>> exposeObjects() {
        return this.references;
    }

    @Override
    public IUndoHandler undo() {
        ArrayList<IObject> objects = new ArrayList<IObject>(this.references.size());
        for (Map.Entry<IObject, Collection<PropertyValue>> entry : this.references.entrySet()) {
            objects.add(entry.getKey());
        }
        PropertiesUndoHandler undoHandler = new PropertiesUndoHandler(objects, this.descriptors);
        for (Map.Entry<IObject, Collection<PropertyValue>> entry : this.references.entrySet()) {
            INodeUtils.updateProperties((IObject)entry.getKey(), entry.getValue(), (boolean)true, (boolean)this.removeNotFound, (String[])new String[0]);
        }
        return undoHandler;
    }
}

