/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.common;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.ObjectIdentifier;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.ui.actions.common.AbstractUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.CreateNodeRelationUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.utils.SequenceUtils;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class RemoveNodeRelationUndoHandler
extends AbstractUndoHandler {
    private final Map<WeakReference<INode>, Collection<INodeRelation>> removedRelations;

    private static INodeRelation createNewRelation(INodeRelation relation, INode source) {
        INode newTarget = RemoveNodeRelationUndoHandler.createNewTarget(relation.getTarget());
        INodeRelation newRelation = NodeRelationFactories.INSTANCE.create(relation.getType(), SequenceUtils.next(), source, newTarget, relation.getPropertyValues());
        newRelation.addPropertyValue(PropertyDescriptors.PREVIOUS_ID, (Object)relation.getId());
        return newRelation;
    }

    private static INode createNewTarget(INode target) {
        INode newNode = NodeFactories.INSTANCE.create(target.getType(), SequenceUtils.next(), target.getPropertyValues(), target.getRepository());
        newNode.addPropertyValue(PropertyDescriptors.PREVIOUS_ID, (Object)target.getId());
        newNode.addPropertyValue(PropertyDescriptors.NEED_UPDATE, (Object)Boolean.TRUE);
        for (INodeRelation relation : target.getRelations(new TypeDescriptor[0])) {
            newNode.addRelation(RemoveNodeRelationUndoHandler.createNewRelation(relation, newNode));
        }
        return newNode;
    }

    public RemoveNodeRelationUndoHandler(Map<WeakReference<INode>, Collection<INodeRelation>> removedRelations) {
        this.removedRelations = removedRelations;
    }

    @Override
    public void relationsAdded(INode node, Collection<INodeRelation> relations) {
        HashMap<ObjectIdentifier, Object> referenceMap = new HashMap<ObjectIdentifier, Object>(relations.size() * 2);
        for (INodeRelation relation : relations) {
            Long previousId = (Long)relation.getProperty(PropertyDescriptors.PREVIOUS_ID);
            if (previousId == null) continue;
            referenceMap.put(new ObjectIdentifier(previousId.longValue(), relation.getType()), relation);
            referenceMap.put(new ObjectIdentifier(relation.getTarget().getId().longValue(), relation.getTarget().getType()), relation.getTarget());
        }
        for (IUndoHandler undoHandler : StudioAction.UNDO_STACK) {
            if (undoHandler.exposeObjects() == null) continue;
            HashMap<IObject, Collection<PropertyValue>> newRelations = new HashMap<IObject, Collection<PropertyValue>>(undoHandler.exposeObjects().size());
            Iterator<Map.Entry<IObject, Collection<PropertyValue>>> it = undoHandler.exposeObjects().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<IObject, Collection<PropertyValue>> entry = it.next();
                IObject previous = (IObject)referenceMap.get(entry.getKey());
                if (previous == null) continue;
                newRelations.put(previous, entry.getValue());
                it.remove();
            }
            undoHandler.exposeObjects().putAll(newRelations);
        }
        for (INodeRelation relation : relations) {
            relation.getSource().unregisterRelationsListener((INodeRelationListener)this);
        }
    }

    @Override
    public IUndoHandler undo() {
        HashSet<INode> addedListenner = new HashSet<INode>(this.removedRelations.size());
        HashMap<WeakReference<INode>, Collection<INodeRelation>> relationsToCreate = new HashMap<WeakReference<INode>, Collection<INodeRelation>>();
        HashSet toCreate = new HashSet();
        for (WeakReference<INode> sourceReference : this.removedRelations.keySet()) {
            INode source = (INode)sourceReference.get();
            if (source == null) continue;
            Collection<INodeRelation> relations = this.removedRelations.get(sourceReference);
            HashSet<INodeRelation> newRelations = new HashSet<INodeRelation>(relations.size());
            for (INodeRelation relation : relations) {
                newRelations.add(RemoveNodeRelationUndoHandler.createNewRelation(relation, source));
            }
            if (!addedListenner.contains(source)) {
                source.registerRelationsListener((INodeRelationListener)this);
                addedListenner.add(source);
            }
            relationsToCreate.put(new WeakReference<INode>(source), newRelations);
            toCreate.addAll(newRelations);
        }
        CreateNodeRelationUndoHandler handler = new CreateNodeRelationUndoHandler(relationsToCreate);
        for (Map.Entry entry : relationsToCreate.entrySet()) {
            INode parent = (INode)((WeakReference)entry.getKey()).get();
            if (parent == null) continue;
            parent.addRelations((Collection)entry.getValue());
            parent.unregisterRelationsListener((INodeRelationListener)handler);
        }
        return handler;
    }
}

