/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.common;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public abstract class StudioAction
extends Action {
    private static final Map<String, ImageDescriptor> PATH_IMAGEDESCRIPTORS = new HashMap<String, ImageDescriptor>(32);
    protected static final Deque<IUndoHandler> UNDO_STACK = new ConcurrentLinkedDeque<IUndoHandler>();
    private static final Deque<IUndoHandler> REDO_STACK = new ConcurrentLinkedDeque<IUndoHandler>();
    protected Pos pos;

    public static boolean canRedo() {
        return !REDO_STACK.isEmpty();
    }

    public static boolean canUndo() {
        return !UNDO_STACK.isEmpty();
    }

    private static void historize(IUndoHandler undoHandler, Deque<IUndoHandler> stack) {
        if (undoHandler == null) {
            return;
        }
        stack.addLast(undoHandler);
        while (stack.size() > Configuration.ACTION_UNDO_QUEUE_SIZE) {
            stack.removeFirst();
        }
    }

    public static final void redo() {
        IUndoHandler redoHandler;
        IUndoHandler lastAction = REDO_STACK.pollLast();
        if (lastAction != null && (redoHandler = lastAction.undo()) != null) {
            StudioAction.historize(redoHandler, UNDO_STACK);
        }
    }

    public static final void undo() {
        IUndoHandler redoHandler;
        IUndoHandler lastAction = UNDO_STACK.pollLast();
        if (lastAction != null && (redoHandler = lastAction.undo()) != null) {
            StudioAction.historize(redoHandler, REDO_STACK);
        }
    }

    public StudioAction(String text) {
        super(text);
    }

    public final ImageDescriptor getImageDescriptor() {
        String imagePath = this.getImageDescriptorPath();
        if (imagePath == null) {
            return null;
        }
        ImageDescriptor desc = PATH_IMAGEDESCRIPTORS.get(imagePath);
        if (desc == null) {
            Image image = SWTUtils.getImageFromUrl((String)imagePath, (int)16, (int)16);
            if (image == null) {
                return null;
            }
            desc = ImageDescriptor.createFromImage((Image)image);
        }
        return desc;
    }

    protected String getImageDescriptorPath() {
        return null;
    }

    protected abstract IUndoHandler internalRun();

    public final void run() {
        if (!this.isEnabled()) {
            return;
        }
        StudioAction.historize(this.internalRun(), UNDO_STACK);
    }

    public void setMenuPos(Pos pos) {
        this.pos = pos;
    }

    public boolean showInMenu() {
        return true;
    }
}

