/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.edit;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.model.TypeHierarchy;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.CreateNodeRelationUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.edit.AACLRepositoryAction;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.swt.SWT;

public abstract class ACreateNodeRelationAction
extends AACLRepositoryAction {
    protected ACreateNodeRelationAction(String text, IRepository input) {
        super(text, input);
        this.setSelectionSingleAccepted(true);
        this.setACLRightNeeded((PropertyDescriptor<Boolean>)ACLPropertyDescriptors.CAN_CREATE);
    }

    public int getAccelerator() {
        return SWT.MOD1 | 0x4E;
    }

    protected abstract Collection<INodeRelation> createRelations();

    @Override
    protected boolean customIsEnabled() {
        INode parent = this.getParent();
        for (TypeDescriptor childType : this.getChildrenTypes()) {
            if (TypeHierarchy.isValid((TypeDescriptor)parent.getType(), (TypeDescriptor)childType)) continue;
            return false;
        }
        return true;
    }

    protected abstract Collection<TypeDescriptor> getChildrenTypes();

    @Override
    protected String getImageDescriptorPath() {
        return "platform:/plugin/com.centreon.studio.client.commons/img/add-small.png";
    }

    protected INode getParent() {
        return this.selectionEmpty() ? this.getInput() : this.getInput().getSelection().getTarget();
    }

    @Override
    protected final IUndoHandler internalRun() {
        Collection<INodeRelation> relations = this.createRelations();
        for (INodeRelation relation : relations) {
            relation.addPropertyValue(PropertyDescriptors.PREVIOUS_ID, (Object)relation.getId());
        }
        this.getParent().registerRelationsListener(new INodeRelationListener(){

            public void relationsAdded(INode node, Collection<INodeRelation> relations) {
                ACreateNodeRelationAction.this.getParent().unregisterRelationsListener((INodeRelationListener)this);
                ACreateNodeRelationAction.this.getParent().getRepository().setSelection((Object)this, relations);
            }

            public void relationsRemoved(INode node, Collection<INodeRelation> relations) {
            }
        });
        this.getParent().addRelations(relations);
        HashMap<WeakReference<INode>, Collection<INodeRelation>> parentToCreatedRelations = new HashMap<WeakReference<INode>, Collection<INodeRelation>>();
        parentToCreatedRelations.put(new WeakReference<INode>(this.getParent()), relations);
        return new CreateNodeRelationUndoHandler(parentToCreatedRelations);
    }
}

