/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.edit;

import com.centreon.studio.client.commons.jface.dialogs.MessageDialogUtils;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.model.ListOfPos;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.messages.ModelMessages;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.NodeClipboard;
import com.centreon.studio.client.model.ui.actions.edit.ACreateNodeRelationAction;
import com.centreon.studio.client.utils.SequenceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.swt.SWT;

public class PasteNodesAction
extends ACreateNodeRelationAction {
    private final NodeClipboard clipboard;
    private final boolean clearClipboard;

    private static boolean contains(INode target, Collection<INodeRelation> relations) {
        for (INodeRelation relation : relations) {
            if (!PasteNodesAction.contains(target, relation)) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(INode pasteTarget, INodeRelation copied) {
        if (pasteTarget.equals((Object)copied.getTarget())) {
            return true;
        }
        for (INodeRelation child : copied.getTarget().getRelations(new TypeDescriptor[0])) {
            if (!PasteNodesAction.contains(pasteTarget, child)) continue;
            return true;
        }
        return false;
    }

    private static Pos getCenter(Collection<INodeRelation> relations) {
        Pos base = Pos.NULL;
        for (INodeRelation relation : relations) {
            base = base.plus((Pos)relation.getProperty(PropertyDescriptors.CURRENT_POSITION));
        }
        return base.div((double)relations.size());
    }

    public PasteNodesAction(IRepository input, TypeDescriptor type, boolean clearClipboard) {
        super(CommonsMessages.keywordPaste, input);
        this.clipboard = NodeClipboard.getClipboard(type);
        this.clearClipboard = clearClipboard;
    }

    @Override
    public final int getAccelerator() {
        return SWT.MOD1 | 0x56;
    }

    @Override
    protected final Collection<INodeRelation> createRelations() {
        ArrayList<INodeRelation> copiedRelations;
        final INode pasteTarget = this.getParent();
        Collection<INodeRelation> pastedRelations = this.createRelations(pasteTarget, copiedRelations = new ArrayList<INodeRelation>(this.clipboard.getRelations()));
        if (pastedRelations.isEmpty()) {
            return Collections.emptyList();
        }
        pasteTarget.registerRelationsListener(new INodeRelationListener(){

            public void relationsAdded(INode node, Collection<INodeRelation> relations) {
                pasteTarget.unregisterRelationsListener((INodeRelationListener)this);
                if (PasteNodesAction.this.clearClipboard) {
                    PasteNodesAction.this.clipboard.setRelations(Collections.emptyList());
                } else {
                    PasteNodesAction.this.clipboard.setRelations(relations);
                }
            }

            public void relationsRemoved(INode node, Collection<INodeRelation> relations) {
            }
        });
        return pastedRelations;
    }

    protected Collection<INodeRelation> createRelations(INode pasteTarget, Collection<INodeRelation> copiedRelations) {
        Double zoom = (Double)pasteTarget.getProperty(PropertyDescriptors.CURRENT_ZOOM);
        Pos base = PasteNodesAction.getCenter(copiedRelations);
        Pos delta = this.pos == null ? Pos.create((double)30.0, (double)30.0) : this.pos.div(zoom.doubleValue()).minus(base);
        ArrayList<INodeRelation> pastedRelations = new ArrayList<INodeRelation>(copiedRelations.size());
        for (INodeRelation copiedRelation : copiedRelations) {
            if (PasteNodesAction.contains(pasteTarget, copiedRelation)) {
                MessageDialogUtils.openError((String)ModelMessages.destinationFolderIsSubFolder);
                return Collections.emptyList();
            }
            INode pastedNode = INodeUtils.copy((INode)copiedRelation.getTarget(), (boolean)false, (boolean)true, null, (PropertyValue[])new PropertyValue[0]);
            if (pastedNode == null) continue;
            pastedNode.addPropertyValue(PropertyDescriptors.BENDPOINTS, (Object)((ListOfPos)pastedNode.getProperty(PropertyDescriptors.BENDPOINTS)).plus(delta));
            INodeRelation pastedRelation = NodeRelationFactories.INSTANCE.create(copiedRelation.getType(), SequenceUtils.next(), pasteTarget, pastedNode, copiedRelation.getPropertyValues());
            pastedRelation.addPropertyValue(PropertyDescriptors.POSITION, (Object)((Pos)pastedRelation.getProperty(PropertyDescriptors.POSITION)).plus(delta));
            pastedRelations.add(pastedRelation);
        }
        return pastedRelations;
    }

    @Override
    protected final boolean customIsEnabled() {
        return super.customIsEnabled() && !this.clipboard.getRelations().isEmpty() && !PasteNodesAction.contains(this.getParent(), this.clipboard.getRelations());
    }

    @Override
    protected Collection<TypeDescriptor> getChildrenTypes() {
        HashSet<TypeDescriptor> types = new HashSet<TypeDescriptor>();
        for (INodeRelation relation : this.clipboard.getRelations()) {
            types.add(relation.getTarget().getType());
        }
        return types;
    }

    @Override
    protected final String getImageDescriptorPath() {
        return "platform:/plugin/com.centreon.studio.client.model.ui/icons/paste_edit.gif";
    }

    @Override
    protected INode getParent() {
        return this.getInput().getSelection().getTarget();
    }
}

