/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.edit;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.commons.jface.dialogs.MessageDialogUtils;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.RemoveNodeRelationUndoHandler;
import com.centreon.studio.client.model.ui.actions.edit.AACLRepositoryAction;
import com.centreon.studio.client.model.ui.messages.ModelUiMessages;
import com.centreon.studio.client.utils.CollectionsUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class RemoveNodesAction
extends AACLRepositoryAction {
    private final boolean askForConfirmation;
    private final boolean deleteFirstOnly;
    private final boolean undoable;

    public RemoveNodesAction(IRepository input) {
        this(input, false, true, true);
    }

    public RemoveNodesAction(IRepository input, boolean askForConfirmation, boolean deleteFirstOnly, boolean undoable) {
        super(CommonsMessages.keywordDel, input);
        this.askForConfirmation = askForConfirmation;
        this.deleteFirstOnly = deleteFirstOnly;
        this.undoable = undoable;
        this.setSelectionSingleAccepted(true);
        this.setSelectionMultiAccepted(!deleteFirstOnly);
        this.setACLRightNeeded((PropertyDescriptor<Boolean>)ACLPropertyDescriptors.CAN_DELETE);
    }

    public final int getAccelerator() {
        return 127;
    }

    @Override
    protected boolean customIsEnabled() {
        if (this.deleteFirstOnly) {
            return (Boolean)this.getInput().getSelection().getTarget().getProperty(PropertyDescriptors.LOCKED) == false;
        }
        for (INodeRelation relation : this.getInput().getSelections()) {
            if (!((Boolean)relation.getTarget().getProperty(PropertyDescriptors.LOCKED)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getImageDescriptorPath() {
        return "platform:/plugin/com.centreon.studio.client.commons/img/cross-small.png";
    }

    @Override
    protected IUndoHandler internalRun() {
        if (this.deleteFirstOnly) {
            return this.removeNodes(Arrays.asList(this.getInput().getSelection()));
        }
        return this.removeNodes(this.getInput().getSelections());
    }

    private final IUndoHandler removeNodes(Collection<INodeRelation> relationsToRemove) {
        if (this.askForConfirmation && !MessageDialogUtils.openConfirm((String)NLS.bind((String)ModelUiMessages.confirmDel, (Object)relationsToRemove.size()))) {
            return null;
        }
        Map sourceToRelations = CollectionsUtils.createMultiMap((int)relationsToRemove.size(), HashSet.class);
        for (INodeRelation relation : relationsToRemove) {
            ((Collection)sourceToRelations.get(relation.getSource())).add(relation);
        }
        HashMap<WeakReference<INode>, Collection<INodeRelation>> removedRelations = new HashMap<WeakReference<INode>, Collection<INodeRelation>>(sourceToRelations.size());
        for (Map.Entry entry : sourceToRelations.entrySet()) {
            ((INode)entry.getKey()).removeRelations((Collection)entry.getValue());
            removedRelations.put(new WeakReference<INode>((INode)entry.getKey()), (Collection)entry.getValue());
        }
        if (!this.undoable) {
            return null;
        }
        return new RemoveNodeRelationUndoHandler(removedRelations);
    }
}

