/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.importexport;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.popup.PopUpEvent;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.importexport.AExportAction;
import com.centreon.studio.client.utils.StringUtils;
import java.io.File;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;

public abstract class ADialogExportFilesActions
extends AExportAction {
    protected final BrokerEventManager eventManager;

    public ADialogExportFilesActions(String text, IRepository input, BrokerEventManager eventManager) {
        super(text, input);
        this.setSelectionMultiAccepted(true);
        this.setSelectionSingleAccepted(true);
        this.eventManager = eventManager;
    }

    protected abstract void export(INodeRelation var1, File var2);

    @Override
    protected IUndoHandler internalRun() {
        File folder = this.openDirectoryDialog();
        if (folder == null) {
            return null;
        }
        if (!folder.exists() && !folder.mkdirs()) {
            this.eventManager.async((StudioEvent)new PopUpEvent().setTexts("Error", "Cannot create export folder").setImagePath("platform:/plugin/com.centreon.studio.client.events/img/error.png"));
            return null;
        }
        for (INodeRelation selection : this.getInput().getSelections()) {
            this.export(selection, folder);
        }
        return null;
    }

    private File openDirectoryDialog() {
        DirectoryDialog directoryDialog = new DirectoryDialog(Display.getCurrent().getActiveShell(), 8192);
        directoryDialog.setText(this.getText());
        String selectedFileName = directoryDialog.open();
        if (StringUtils.isNullEmptyOrBlank((String)selectedFileName)) {
            return null;
        }
        return new File(selectedFileName);
    }
}

