/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.layer;

public class LayersRegistry {
    private static final String CONNECTION_LAYER = "Connection Layer";
    public static final Integer DEFAULT_LAYER = 101;
    public static final Integer BACKGROUND_LAYER = 99;
    public static final Integer MIDDLE_LAYER = 100;
    private static final int DELTA = 5;

    public static String getBottomLayer() {
        return String.valueOf(MIDDLE_LAYER - 5);
    }

    public static String getLayerForm(String layer, boolean up) {
        if (CONNECTION_LAYER.equals(layer)) {
            return layer;
        }
        Integer index = LayersRegistry.parse(layer);
        return String.valueOf(up ? Math.min(index + 1, MIDDLE_LAYER + 5) : Math.max(index - 1, MIDDLE_LAYER - 5));
    }

    public static String getTopLayer() {
        return String.valueOf(MIDDLE_LAYER + 5);
    }

    public static Integer parse(String layer) {
        try {
            switch (layer) {
                case "BACKGROUND_LAYER": {
                    return BACKGROUND_LAYER;
                }
                case "MIDDLE_LAYER": {
                    return MIDDLE_LAYER;
                }
                case "DEFAULT": 
                case "": {
                    return DEFAULT_LAYER;
                }
            }
            return Integer.parseInt(layer);
        }
        catch (NumberFormatException numberFormatException) {
            return DEFAULT_LAYER;
        }
    }

    private LayersRegistry() {
    }
}

