/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.layout.align;

import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.PropertiesUndoHandler;
import com.centreon.studio.client.model.ui.actions.layout.ALayoutAction;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.SWT;

public abstract class AAlignNodesAction
extends ALayoutAction {
    public static final int ALIGN_ON_FIRST = 1;
    public static final int ALIGN_ON_MIN = 2;
    public static final int ALIGN_ON_MAX = 3;
    private final char accelerator;
    private final String icon;
    private final int mode;

    protected AAlignNodesAction(IRepository input, String label, char accelerator, String icon, int mode) {
        super(label, input, Pos.class);
        this.accelerator = accelerator;
        this.mode = mode;
        this.icon = icon;
    }

    public final int getAccelerator() {
        return SWT.MOD1 | SWT.MOD3 | this.accelerator;
    }

    protected abstract Pos createNewPos(INodeRelation var1, Pos var2, Pos var3, Pos var4);

    @Override
    protected final String getImageDescriptorPath() {
        return "platform:/plugin/com.centreon.studio.client.model.ui/icons/" + this.icon;
    }

    @Override
    protected IUndoHandler internalRun() {
        List<INodeRelation> actualSelections = this.getActualSelection();
        PropertiesUndoHandler undoHandler = new PropertiesUndoHandler(actualSelections, PropertyDescriptors.CURRENT_POSITION, PropertyDescriptors.POSITION);
        Pos firstPosition = (Pos)actualSelections.get(0).getProperty(PropertyDescriptors.CURRENT_POSITION);
        Pos firstDimension = (Pos)actualSelections.get(0).getProperty(PropertyDescriptors.CURRENT_DIMENSION);
        Pos min = this.mode == 1 ? firstPosition.minus(firstDimension.div(2.0)) : Pos.create((double)Double.MAX_VALUE, (double)Double.MAX_VALUE);
        Pos max = this.mode == 1 ? firstPosition.plus(firstDimension.div(2.0)) : Pos.create((double)Double.MIN_VALUE, (double)Double.MIN_VALUE);
        Pos total = Pos.create((double)0.0, (double)0.0);
        for (INodeRelation selection : actualSelections) {
            Pos pos = (Pos)selection.getProperty(PropertyDescriptors.CURRENT_POSITION);
            Pos dim = (Pos)selection.getProperty(PropertyDescriptors.CURRENT_DIMENSION);
            if (this.mode != 1) {
                min = this.mode == 2 ? Pos.create((double)Math.min(min.x, pos.x - dim.x / 2.0), (double)Math.min(min.y, pos.y - dim.y / 2.0)) : Pos.create((double)Math.max(min.x, pos.x - dim.x / 2.0), (double)Math.max(min.y, pos.y - dim.y / 2.0));
                max = this.mode == 2 ? Pos.create((double)Math.max(max.x, pos.x + dim.x / 2.0), (double)Math.max(max.y, pos.y + dim.y / 2.0)) : Pos.create((double)Math.min(max.x, pos.x + dim.x / 2.0), (double)Math.min(max.y, pos.y + dim.y / 2.0));
            }
            total = total.plus(pos);
        }
        Pos avg = total.div((double)actualSelections.size());
        for (INodeRelation selection : actualSelections) {
            Pos newPos = this.createNewPos(selection, avg, min, max);
            selection.addPropertyValues(Arrays.asList(new PropertyValue(PropertyDescriptors.POSITION, (Object)newPos), new PropertyValue(PropertyDescriptors.CURRENT_POSITION, null)));
        }
        return undoHandler;
    }
}

