/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.layout.distribute;

import com.centreon.studio.client.commons.jface.validation.ControlValidators;
import com.centreon.studio.client.commons.jface.validation.field.impl.IntegerTextField;
import com.centreon.studio.client.commons.jface.validation.form.Form;
import com.centreon.studio.client.commons.jface.validation.form.IForm;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.commons.swt.MoveShellListener;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.layout.distribute.ADistributeNodesAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class CustomDistributeNodesAction
extends ADistributeNodesAction {
    private int rows;
    private int columns;
    private int spacing;
    private IntegerTextField rowsField;
    private IntegerTextField columnsField;

    public CustomDistributeNodesAction(IRepository repository) {
        super(repository);
    }

    @Override
    public final int getAccelerator() {
        return SWT.MOD1 | SWT.MOD2 | SWT.MOD3 | 0x43;
    }

    @Override
    public String getText() {
        return "Custom";
    }

    @Override
    protected int getColumns() {
        return this.columns;
    }

    @Override
    protected int getRows() {
        return this.rows;
    }

    @Override
    protected int getSpacing() {
        return this.spacing;
    }

    @Override
    protected IUndoHandler internalRun() {
        this.openShell(this.getActualSelection().size());
        if (this.getRows() == 0 && this.getColumns() == 0) {
            return null;
        }
        return super.internalRun();
    }

    private void openShell(final int numberOfSelectedElements) {
        final Shell shell = SWTUtils.createShellTool((int)1, (boolean)true, (boolean)false, (boolean)true, (int)5, (boolean)true);
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    shell.close();
                    event.detail = 0;
                    event.doit = false;
                }
            }
        });
        Form form = new Form();
        Composite fieldsComposite = SWTUtils.createComposite((Composite)shell, (int)2, (boolean)true, (int)0, (int)5);
        SWTUtils.createLabel((Composite)fieldsComposite, (String)"Rows");
        ControlValidators.AControlValidator<Text> validator = new ControlValidators.AControlValidator<Text>(){

            public String getMessage() {
                return "Number of rows and columns must fit the selection size : " + numberOfSelectedElements;
            }

            public boolean validate(Text control) {
                return CustomDistributeNodesAction.this.rowsField.getValue() * CustomDistributeNodesAction.this.columnsField.getValue() >= numberOfSelectedElements;
            }
        };
        this.rowsField = new IntegerTextField(SWTUtils.createText((Composite)fieldsComposite), null, Integer.valueOf(1), (IForm)form, (ControlValidators.IControlValidator)validator);
        ((Text)this.rowsField.getControl()).addModifyListener(e -> {
            int oldColumnFieldNumber;
            int newColumnFieldNumber = (int)Math.ceil((double)numberOfSelectedElements / (double)this.rowsField.getValue().intValue());
            if (newColumnFieldNumber != (oldColumnFieldNumber = this.columnsField.getValue().intValue())) {
                this.columnsField.setValue((Object)newColumnFieldNumber);
            }
        });
        SWTUtils.createLabel((Composite)fieldsComposite, (String)"Columns");
        this.columnsField = new IntegerTextField(SWTUtils.createText((Composite)fieldsComposite), null, Integer.valueOf(numberOfSelectedElements), (IForm)form, (ControlValidators.IControlValidator)validator);
        ((Text)this.columnsField.getControl()).addModifyListener(e -> {
            int newRowsFieldValue = (int)Math.ceil((double)numberOfSelectedElements / (double)this.columnsField.getValue().intValue());
            int oldRowsFieldValue = this.rowsField.getValue();
            if (oldRowsFieldValue != newRowsFieldValue) {
                this.rowsField.setValue((Object)newRowsFieldValue);
            }
        });
        SWTUtils.createLabel((Composite)fieldsComposite, (String)"Spacing");
        final IntegerTextField spacingField = new IntegerTextField(SWTUtils.createText((Composite)fieldsComposite), null, Integer.valueOf(10), (IForm)form, null);
        Composite buttonComposite = SWTUtils.createComposite((Composite)shell, (int)2, (boolean)true, (int)0, (int)5);
        Button ok = SWTUtils.createButtonDefault((Composite)buttonComposite, (int)0x1000008, (int)0x1000000, (String)CommonsMessages.keywordOk, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomDistributeNodesAction.this.rows = CustomDistributeNodesAction.this.rowsField.getValue();
                CustomDistributeNodesAction.this.columns = CustomDistributeNodesAction.this.columnsField.getValue();
                CustomDistributeNodesAction.this.spacing = spacingField.getValue();
                shell.close();
            }
        });
        form.registerValidationTrackingControl((Control)ok);
        SWTUtils.createButtonPush((Composite)buttonComposite, (int)0x1000008, (int)0x1000000, (String)CommonsMessages.keywordCancel, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        new MoveShellListener(shell);
        Point size = shell.computeSize(-1, -1);
        Point pt = SWTUtils.getDisplay().getCursorLocation();
        shell.setBounds(pt.x, pt.y, size.x, size.y);
        shell.open();
        while (!shell.isDisposed()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
    }
}

