/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.actions.style;

import com.centreon.studio.client.acl.ACLPropertyDescriptors;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.PropertiesUndoHandler;
import com.centreon.studio.client.model.ui.actions.edit.AACLRepositoryAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class StyleAction
extends AACLRepositoryAction {
    private static final Set<TypeDescriptor> SUPPORTED_TYPES = new HashSet<TypeDescriptor>(20);
    private final TypeDescriptor styleType;

    public static void register(TypeDescriptor type) {
        SUPPORTED_TYPES.add(type);
    }

    public StyleAction(IRepository input, TypeDescriptor styleType) {
        super(styleType.getLabel(), input);
        this.styleType = styleType;
        this.setSelectionMultiAccepted(true);
        this.setSelectionSingleAccepted(true);
        this.addSupportedTypes(SUPPORTED_TYPES);
        this.setACLRightNeeded((PropertyDescriptor<Boolean>)ACLPropertyDescriptors.CAN_UPDATE);
    }

    @Override
    public boolean customIsEnabled() {
        for (INodeRelation relation : this.getInput().getSelections()) {
            if (!this.supportedTypes.contains(relation.getTarget().getType()) || this.styleType.equals(relation.getTarget().getProperty(PropertyDescriptors.STYLE))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getImageDescriptorPath() {
        return this.styleType.getSmallImage();
    }

    @Override
    protected IUndoHandler internalRun() {
        ArrayList<INode> nodes = new ArrayList<INode>(this.getInput().getSelections().size());
        for (INodeRelation selection : this.getInput().getSelections()) {
            if (!this.supportedTypes.contains(selection.getTarget().getType())) continue;
            nodes.add(selection.getTarget());
        }
        PropertiesUndoHandler undo = new PropertiesUndoHandler(nodes, PropertyDescriptors.STYLE);
        for (INode node : nodes) {
            node.addPropertyValue(PropertyDescriptors.STYLE, (Object)this.styleType);
        }
        return undo;
    }
}

