/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.contributionmanagers;

import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.ui.actions.common.SeparatorAction;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.actions.common.StudioActionGroup;
import com.centreon.studio.client.model.ui.actionsets.ActionSetDescriptor;
import com.centreon.studio.client.model.ui.contributionmanagers.IPosProvider;
import com.centreon.studio.client.model.ui.contributions.NodeActionContributionFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class CustomMenuManager
extends MenuManager
implements IMenuListener2 {
    static final Separator SEPARATOR = new Separator();
    private final ActionSetDescriptor description;
    private final IPosProvider provider;
    private final Control control;

    public CustomMenuManager(ActionSetDescriptor actionSet, Control control) {
        this(actionSet, control, null);
    }

    public CustomMenuManager(ActionSetDescriptor actionSet, Control control, IPosProvider provider) {
        this.control = control;
        this.provider = provider;
        this.description = actionSet;
        this.setRemoveAllWhenShown(true);
        this.addMenuListener((IMenuListener)this);
        this.control.setMenu(this.createContextMenu(control));
    }

    public void add(IAction action) {
        if (!(action instanceof StudioAction)) {
            return;
        }
        super.add(action);
    }

    public void menuAboutToHide(IMenuManager manager) {
    }

    public void menuAboutToShow(IMenuManager manager) {
        Pos pos = null;
        if (this.provider != null) {
            pos = this.provider.getPos();
        } else {
            Point absoluteCursorLocation = Display.getCurrent().getCursorLocation();
            Point relativeCursorLocation = this.control.toControl(absoluteCursorLocation);
            pos = Pos.create((double)relativeCursorLocation.x, (double)relativeCursorLocation.y);
        }
        for (StudioAction action : this.description.getActions()) {
            this.add(manager, action);
            action.setMenuPos(pos);
        }
    }

    private void add(IMenuManager manager, StudioAction action) {
        if (!action.showInMenu()) {
            return;
        }
        if (SeparatorAction.INSTANCE == action) {
            manager.add((IContributionItem)SEPARATOR);
        } else if (action instanceof StudioActionGroup) {
            MenuManager subMenu = new MenuManager(action.getText());
            subMenu.setImageDescriptor(action.getImageDescriptor());
            for (StudioAction subAction : ((StudioActionGroup)action).getActions()) {
                this.add((IMenuManager)subMenu, subAction);
            }
            manager.add((IContributionItem)subMenu);
        } else {
            manager.add((IContributionItem)NodeActionContributionFactory.INSTANCE.createContribution(action));
        }
    }
}

