/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.contributionmanagers;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.IPropertiesListener;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.IRepositoryListener;
import com.centreon.studio.client.model.ui.actions.common.SeparatorAction;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.actionsets.ActionSetDescriptor;
import com.centreon.studio.client.model.ui.contributionmanagers.CustomMenuManager;
import com.centreon.studio.client.model.ui.contributions.NodeActionContributionFactory;
import java.util.Collection;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;

public class CustomToolBarManager
extends ToolBarManager
implements IRepositoryListener,
IPropertiesListener,
DisposeListener {
    private final INode input;

    public CustomToolBarManager(ActionSetDescriptor description, Composite parent, INode input) {
        this.input = input;
        GridData gd = new GridData(4, 128, true, false);
        gd.heightHint = 30;
        ToolBar tb = this.createControl(parent);
        tb.setBackground(SWTUtils.getSystemColor((int)1));
        tb.addDisposeListener((DisposeListener)this);
        tb.setLayoutData((Object)gd);
        input.registerPropertiesListener((IPropertiesListener)this);
        input.getRepository().registerSelectionListener((IRepositoryListener)this);
        for (StudioAction action : description.getActions()) {
            if (action == SeparatorAction.INSTANCE) {
                this.add((IContributionItem)CustomMenuManager.SEPARATOR);
                continue;
            }
            this.add((IContributionItem)NodeActionContributionFactory.INSTANCE.createContribution(action));
        }
    }

    public void propertiesChanged(IObject object, Collection<PropertyValue> properties) {
        SWTUtils.getDisplay().syncExec(() -> this.update(true));
    }

    public void selectionChanged(Object source, IRepository repository) {
        SWTUtils.getDisplay().syncExec(() -> this.update(true));
    }

    public void widgetDisposed(DisposeEvent e) {
        this.input.getRepository().unregisterSelectionListener((IRepositoryListener)this);
        this.input.unregisterPropertiesListener((IPropertiesListener)this);
    }
}

