/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.contributions;

import com.centreon.studio.client.model.ui.actions.zoom.IZoomable;
import com.centreon.studio.client.model.ui.actions.zoom.ZoomListAction;
import com.centreon.studio.client.model.ui.contributions.StudioActionContributionItem;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ZoomActionContributionItem
extends StudioActionContributionItem
implements FocusListener,
SelectionListener {
    private boolean forceSetText;
    private ToolItem toolitem;
    private Combo combo;

    protected ZoomActionContributionItem(ZoomListAction action) {
        super(action);
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public final void fill(Menu parent, int index) {
        Assert.isTrue((boolean)false, (String)"Can't add a control to a menu");
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        this.toolitem.setControl(this.createControl((Composite)parent));
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.refresh(false);
    }

    public ZoomListAction getAction() {
        return (ZoomListAction)super.getAction();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        IZoomable zoomable = this.getAction().getActiveZoomable();
        if (zoomable != null) {
            String zoomString = null;
            if (this.combo.getSelectionIndex() >= 0) {
                int index = this.combo.getSelectionIndex();
                zoomString = this.combo.getItem(index);
            } else {
                zoomString = this.combo.getText();
            }
            double zoom = Double.parseDouble(zoomString);
            zoomable.setZoom(-1, -1, zoom);
        }
        this.refresh(false);
    }

    public void widgetSelected(SelectionEvent e) {
        this.forceSetText = true;
        this.widgetDefaultSelected(e);
        this.forceSetText = false;
    }

    private Control createControl(Composite parent) {
        this.combo = new Combo(parent, 4);
        this.combo.addSelectionListener((SelectionListener)this);
        this.combo.addFocusListener((FocusListener)this);
        IZoomable zoomable = this.getAction().getActiveZoomable();
        if (zoomable != null) {
            double[] zooms = zoomable.getZoomLevels();
            String[] levels = new String[zooms.length];
            int i = 0;
            while (i < zooms.length) {
                levels[i] = String.valueOf(zooms[i]);
                ++i;
            }
            this.combo.setItems(levels);
        }
        this.toolitem.setWidth(StudioActionContributionItem.computeWidth((Control)this.combo));
        this.refresh(true);
        return this.combo;
    }

    private void refresh(boolean repopulateCombo) {
        block9: {
            if (this.combo == null || this.combo.isDisposed()) {
                return;
            }
            IZoomable zoomable = this.getAction().getActiveZoomable();
            try {
                if (zoomable == null) {
                    this.combo.setEnabled(false);
                    this.combo.setText("");
                } else {
                    double zoom;
                    String zoomString;
                    int index;
                    if (repopulateCombo) {
                        double[] zooms = zoomable.getZoomLevels();
                        String[] levels = new String[zooms.length];
                        int i = 0;
                        while (i < zooms.length) {
                            levels[i] = String.valueOf(zooms[i]);
                            ++i;
                        }
                    }
                    if ((index = this.combo.indexOf(zoomString = String.valueOf(zoom = zoomable.getZoom()))) == -1 || this.forceSetText) {
                        this.combo.setText(zoomString);
                    } else {
                        this.combo.select(index);
                    }
                    this.combo.setEnabled(true);
                }
            }
            catch (SWTException exception) {
                if ("gtk".equals(SWT.getPlatform())) break block9;
                throw exception;
            }
        }
    }
}

