/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.controls.abs;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.IRepositoryListener;
import com.centreon.studio.client.model.ui.controls.INodeControl;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ANodeViewer<C extends Control>
implements INodeControl<C>,
IRepositoryListener,
DisposeListener {
    private final TypeDescriptor[] relationTypes;
    private final C control;
    private final INode input;

    protected ANodeViewer(Composite parent, INode node, TypeDescriptor ... relationType) {
        this.control = this.createControl(parent);
        this.input = node;
        this.relationTypes = relationType;
        if (this.input != null) {
            this.control.addDisposeListener((DisposeListener)this);
            this.input.getRepository().registerSelectionListener((IRepositoryListener)this);
        }
    }

    @Override
    public final C getControl() {
        return this.control;
    }

    public final INode getInput() {
        return this.input;
    }

    public void selectionChanged(Object source, IRepository repository) {
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.input != null) {
            this.input.getRepository().unregisterSelectionListener((IRepositoryListener)this);
        }
    }

    protected abstract C createControl(Composite var1);

    protected TypeDescriptor[] getRelationTypes() {
        return this.relationTypes;
    }

    protected abstract void initControl();
}

