/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.controls.impl;

import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.commons.swt.MoveShellListener;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.FilterData;
import com.centreon.studio.client.model.IFilter;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.IPropertiesListener;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.ui.controls.abs.ANodeViewer;
import com.centreon.studio.client.model.ui.controls.impl.FilterContentProvider;
import com.centreon.studio.client.model.ui.messages.ModelUiMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class NodeFilterText
extends ANodeViewer<Text>
implements IPropertiesListener,
IContentProposalListener,
SelectionListener {
    private static final String FILE_IMAGE_PATH = "platform:/plugin/com.centreon.studio.client.model.ui/icons/hunk_obj.gif";
    private static final String SEARCH_IMAGE_PATH = "platform:/plugin/com.centreon.studio.client.model.ui/icons/search.gif";
    private final Set<PropertyDescriptor<?>> properties = new HashSet(8);
    private final IFilter filter;
    private Button okButton;
    private Button filterButton;

    public NodeFilterText(Composite parent, IFilter filter) {
        super(parent, null, new TypeDescriptor[0]);
        Assert.isNotNull((Object)filter, (String)"filter must not be null");
        this.filter = filter;
        ContentProposalAdapter adapter = new ContentProposalAdapter(this.getControl(), (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new FilterContentProvider(this.filter), KeyStroke.getInstance((int)0x1000002), null);
        adapter.setProposalAcceptanceStyle(2);
        adapter.addContentProposalListener((IContentProposalListener)this);
        ((Text)this.getControl()).addDisposeListener((DisposeListener)this);
        this.initControl();
    }

    public final void propertiesChanged(IObject object, Collection<PropertyValue> propertyValues) {
        this.initControl();
    }

    public void proposalAccepted(IContentProposal proposal) {
        this.filter.setFilterData(new FilterData(((Text)this.getControl()).getText(), this.filter.getFilterData()));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.filterButton) {
            this.openFilterShell(this.filter);
        } else if (e.widget == this.okButton) {
            this.filter();
        }
    }

    @Override
    protected final Text createControl(Composite parent) {
        Composite composite = SWTUtils.createComposite((Composite)parent, (int)3, (boolean)false, (int)0, (int)0, (GridData)new GridData(4, 0x1000000, true, false));
        Image imageFilter = SWTUtils.getImageFromUrl((String)FILE_IMAGE_PATH, (int)16, (int)16);
        this.filterButton = SWTUtils.createButtonPush((Composite)composite, (int)1, (int)0x1000000, (Image)imageFilter, (SelectionListener)this);
        Text text = SWTUtils.createText((Composite)composite);
        text.setMessage(ModelUiMessages.filter);
        text.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    NodeFilterText.this.filter();
                }
            }
        });
        Image imageSearch = SWTUtils.getImageFromUrl((String)SEARCH_IMAGE_PATH, (int)16, (int)16);
        this.okButton = SWTUtils.createButtonPush((Composite)composite, (int)1, (int)0x1000000, (Image)imageSearch, (SelectionListener)this);
        this.filterButton.setBackground(text.getBackground());
        this.okButton.setBackground(text.getBackground());
        composite.setBackground(text.getBackground());
        return text;
    }

    @Override
    protected final void initControl() {
        String value = this.filter.getFilterData().value;
        if (!((Text)this.getControl()).getText().equals(value)) {
            ((Text)this.getControl()).setText(value);
            ((Text)this.getControl()).setSelection(value.length());
        }
    }

    private void filter() {
        BusyIndicator.showWhile((Display)SWTUtils.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                NodeFilterText.this.filter.setFilterData(new FilterData(((Text)NodeFilterText.this.getControl()).getText(), NodeFilterText.this.filter.getFilterData()));
            }
        });
    }

    private void openFilterShell(final IFilter filter) {
        final Shell shell = SWTUtils.createShellTool((int)1, (boolean)true, (boolean)false, (boolean)true, (int)5, (boolean)true);
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    shell.close();
                    event.detail = 0;
                    event.doit = false;
                }
            }
        });
        final ArrayList<Button> checks = new ArrayList<Button>(this.filter.getCandidateProperties().size());
        if (!filter.getCandidateProperties().isEmpty()) {
            Group columnsGroup = SWTUtils.createGroup((Composite)shell, (String)"Columns", (int)-1, (int)1, (boolean)false, (GridData)SWTUtils.createGridDataFill());
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (NodeFilterText.this.okButton == null || NodeFilterText.this.okButton.isDisposed()) {
                        return;
                    }
                    boolean okEnabled = false;
                    for (Button check : checks) {
                        okEnabled |= check.getSelection();
                    }
                    NodeFilterText.this.okButton.setEnabled(okEnabled);
                }
            };
            for (PropertyDescriptor property : this.filter.getCandidateProperties()) {
                Button check = SWTUtils.createButtonCheck((Composite)columnsGroup, (String)property.label);
                check.setData((Object)property);
                check.setSelection(filter.getFilterData().descriptors.contains(property));
                check.addSelectionListener((SelectionListener)listener);
                checks.add(check);
            }
        }
        Group optionsGroup = SWTUtils.createGroup((Composite)shell, (String)"Options", (int)-1, (int)1, (boolean)false, (GridData)SWTUtils.createGridDataFill());
        final Button caseSensitive = SWTUtils.createButtonCheck((Composite)optionsGroup, (String)"Case sensitive");
        caseSensitive.setSelection(filter.getFilterData().caseSensitive);
        final Button useRegex = SWTUtils.createButtonCheck((Composite)optionsGroup, (String)"Use regex");
        useRegex.setSelection(filter.getFilterData().useRegex);
        Composite composite = SWTUtils.createComposite((Composite)shell, (int)2, (boolean)true, (int)0, (int)0);
        this.okButton = SWTUtils.createButtonDefault((Composite)composite, (int)0x1000008, (int)0x1000000, (String)CommonsMessages.keywordOk, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Button check : checks) {
                    PropertyDescriptor property = (PropertyDescriptor)check.getData();
                    if (check.getSelection()) {
                        NodeFilterText.this.properties.add(property);
                        continue;
                    }
                    NodeFilterText.this.properties.remove(property);
                }
                FilterData parameters = new FilterData(filter.getFilterData().value, caseSensitive.getSelection(), useRegex.getSelection(), (Collection)NodeFilterText.this.properties);
                filter.setFilterData(parameters);
                shell.close();
            }
        });
        SWTUtils.createButtonPush((Composite)composite, (int)0x1000008, (int)0x1000000, (String)CommonsMessages.keywordCancel, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        new MoveShellListener(shell);
        Point size = shell.computeSize(-1, -1);
        Point pt = SWTUtils.getDisplay().getCursorLocation();
        shell.setBounds(pt.x, pt.y, size.x, size.y);
        shell.open();
    }
}

