/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.controls.impl;

import com.centreon.studio.client.model.ui.controls.impl.OverlayPosition;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayIcon
extends CompositeImageDescriptor {
    private final Point fSize;
    private final ImageDescriptor fBase;
    private ImageDescriptor topLeftOverlay;
    private ImageDescriptor topRightOverlay;
    private ImageDescriptor bottomLeftOverlay;
    private ImageDescriptor bottomRightOverlay;

    public OverlayIcon(ImageDescriptor base, Point size) {
        this.fBase = base;
        this.fSize = size;
    }

    public void addOverlayIcon(OverlayPosition pos, ImageDescriptor overlay) {
        switch (pos) {
            case TOP_LEFT: {
                this.topLeftOverlay = overlay;
                break;
            }
            case TOP_RIGHT: {
                this.topRightOverlay = overlay;
                break;
            }
            case BOTTOM_LEFT: {
                this.bottomLeftOverlay = overlay;
                break;
            }
            default: {
                this.bottomRightOverlay = overlay;
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        OverlayIcon other = (OverlayIcon)((Object)obj);
        if (this.bottomLeftOverlay == null ? other.bottomLeftOverlay != null : !this.bottomLeftOverlay.equals(other.bottomLeftOverlay)) {
            return false;
        }
        if (this.bottomRightOverlay == null ? other.bottomRightOverlay != null : !this.bottomRightOverlay.equals(other.bottomRightOverlay)) {
            return false;
        }
        if (this.fBase == null ? other.fBase != null : !this.fBase.equals(other.fBase)) {
            return false;
        }
        if (this.fSize == null ? other.fSize != null : !this.fSize.equals((Object)other.fSize)) {
            return false;
        }
        if (this.topLeftOverlay == null ? other.topLeftOverlay != null : !this.topLeftOverlay.equals(other.topLeftOverlay)) {
            return false;
        }
        return !(this.topRightOverlay == null ? other.topRightOverlay != null : !this.topRightOverlay.equals(other.topRightOverlay));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.bottomLeftOverlay == null ? 0 : this.bottomLeftOverlay.hashCode());
        result = 31 * result + (this.bottomRightOverlay == null ? 0 : this.bottomRightOverlay.hashCode());
        result = 31 * result + (this.fBase == null ? 0 : this.fBase.hashCode());
        result = 31 * result + (this.fSize == null ? 0 : this.fSize.hashCode());
        result = 31 * result + (this.topLeftOverlay == null ? 0 : this.topLeftOverlay.hashCode());
        result = 31 * result + (this.topRightOverlay == null ? 0 : this.topRightOverlay.hashCode());
        return result;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg;
        if (this.fBase == null || (bg = this.fBase.getImageData()) == null) {
            bg = ImageDescriptor.DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        if (this.topLeftOverlay != null) {
            this.drawImage(this.topLeftOverlay.getImageData(), 0, 0);
        }
        if (this.topRightOverlay != null) {
            int x = this.getSize().x;
            ImageData id = this.topRightOverlay.getImageData();
            this.drawImage(id, x -= id.width, 0);
        }
        if (this.bottomLeftOverlay != null) {
            ImageData id = this.bottomLeftOverlay.getImageData();
            int y = this.getSize().y;
            this.drawImage(this.bottomLeftOverlay.getImageData(), 0, y -= id.height);
        }
        if (this.bottomRightOverlay != null) {
            ImageData id = this.bottomRightOverlay.getImageData();
            int x = this.getSize().x;
            int y = this.getSize().y;
            this.drawImage(this.bottomRightOverlay.getImageData(), x -= id.width, y -= id.height);
        }
    }

    protected Point getSize() {
        return this.fSize;
    }
}

