/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.controls.impl.listeners;

import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.actions.common.StudioActionGroup;
import com.centreon.studio.client.model.ui.actionsets.ActionSetDescriptor;
import java.util.Collection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;

public final class ActionSetDescriptorListener
implements KeyListener,
MouseListener {
    private final ActionSetDescriptor actionSet;

    private static void run(int accelerator, Collection<StudioAction> actions) {
        for (StudioAction action : actions) {
            if (action.getAccelerator() == accelerator) {
                action.run();
            }
            if (!(action instanceof StudioActionGroup)) continue;
            ActionSetDescriptorListener.run(accelerator, ((StudioActionGroup)action).getActions());
        }
    }

    public ActionSetDescriptorListener(ActionSetDescriptor actionSet) {
        this.actionSet = actionSet;
    }

    public void keyPressed(KeyEvent e) {
        int accelerator = e.stateMask | Character.toUpperCase(e.keyCode);
        ActionSetDescriptorListener.run(accelerator, this.actionSet.getActions());
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
        StudioAction defaultAction = this.actionSet.getDefaultAction();
        if (defaultAction != null) {
            defaultAction.run();
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }
}

