/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.dialogs;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.jface.validation.ControlValidators;
import com.centreon.studio.client.commons.jface.validation.field.impl.CheckField;
import com.centreon.studio.client.commons.jface.validation.field.impl.IntegerTextField;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.commons.swt.CustomScale;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.AlignmentHorizontal;
import com.centreon.studio.client.model.AlignmentVertical;
import com.centreon.studio.client.model.IImageInterface;
import com.centreon.studio.client.model.Line;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.StudioFont;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.LayoutUtils;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.model.ui.dialogs.MinimalPropertiesWizardPage;
import com.centreon.studio.client.model.ui.messages.ModelUiMessages;
import java.util.ArrayList;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class DefaultPropertiesWizardPage
extends MinimalPropertiesWizardPage {
    protected IntegerTextField xField;
    protected IntegerTextField yField;
    protected IntegerTextField widthField;
    protected IntegerTextField heightField;
    protected ColorSelector colorSelector;
    protected ColorSelector fontColorSelector;
    protected CheckField displayLabelField;
    protected CheckField opaqueField;
    private ColorSelector borderColorSelector;
    private CustomScale alphaScale;
    private CheckField keepRatioField;
    private CheckField displayImageField;
    private FontData newFontData;

    protected static void moveControlAndLabel(Control control, Control target, boolean below) {
        Control label = null;
        Control[] controlArray = control.getParent().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.equals(control)) break;
            label = child;
            ++n2;
        }
        if (label != null) {
            if (below) {
                label.moveBelow(target);
            } else {
                label.moveAbove(target);
            }
        }
        control.moveBelow(label);
    }

    public DefaultPropertiesWizardPage() {
        this(DefaultPropertiesWizardPage.class.getSimpleName());
    }

    protected DefaultPropertiesWizardPage(String name) {
        super(name);
        this.setTitle(CommonsMessages.keywordEdit);
        this.setMessage(ModelUiMessages.infoEditImage);
    }

    @Override
    public Composite customCreateControl(Composite parent) {
        Composite composite = super.customCreateControl(parent);
        if (this.hasLabel()) {
            Boolean displayLabel = (Boolean)this.getInput().getTarget().getProperty(PropertyDescriptors.DISPLAY_LABEL);
            this.displayLabelField = new CheckField(SWTUtils.createButtonCheck((Composite)composite), PropertyDescriptors.DISPLAY_LABEL.label, displayLabel, this.getForm(), null);
        }
        if (this.hasImage()) {
            Boolean displayimage = (Boolean)this.getInput().getTarget().getProperty(PropertyDescriptors.DISPLAY_IMAGE);
            this.displayImageField = new CheckField(SWTUtils.createButtonCheck((Composite)composite), PropertyDescriptors.DISPLAY_IMAGE.label, displayimage, this.getForm(), null);
        }
        if (this.hasFont()) {
            SWTUtils.createLabel((Composite)composite, (String)PropertyDescriptors.FONT.label);
            SWTUtils.createButtonPush((Composite)composite, (int)1, (int)1, (String)"Pick a font", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FontDialog dialog = new FontDialog(SWTUtils.getDisplay().getActiveShell(), 0);
                    dialog.setEffectsVisible(false);
                    StudioFont studioFont = (StudioFont)DefaultPropertiesWizardPage.this.getInput().getTarget().getProperty(PropertyDescriptors.FONT);
                    Font swtFont = StudioRegistries.fontRegistry().getSWTFontFrom(studioFont);
                    dialog.setFontList(swtFont.getFontData());
                    DefaultPropertiesWizardPage.this.newFontData = dialog.open();
                }
            });
            SWTUtils.createLabel((Composite)composite, (String)PropertyDescriptors.FONT_COLOR.label);
            this.fontColorSelector = new ColorSelector(composite);
            StudioColor fontColor = (StudioColor)this.getInput().getTarget().getProperty(PropertyDescriptors.FONT_COLOR);
            if (fontColor != null) {
                Color color = StudioRegistries.colorRegistry().getSWTColorFrom(fontColor);
                this.fontColorSelector.setColorValue(color.getRGB());
            }
        }
        if (this.hasAlignement()) {
            CustomWizardPage.createDescriptorButton((Composite)composite, (IObject)this.getInput().getTarget(), (PropertyDescriptor)PropertyDescriptors.HORIZONTAL_ALIGNMENT, (IImageInterface[])AlignmentHorizontal.values());
            CustomWizardPage.createDescriptorButton((Composite)composite, (IObject)this.getInput().getTarget(), (PropertyDescriptor)PropertyDescriptors.VERTICAL_ALIGNMENT, (IImageInterface[])AlignmentVertical.values());
        }
        Pos initialDimension = (Pos)this.getInput().getProperty(PropertyDescriptors.CURRENT_DIMENSION);
        final double ratio = initialDimension.x / initialDimension.y;
        final Button keekRatioControl = SWTUtils.createButton((Composite)composite, (int)32, (String)"", (GridData)SWTUtils.createGridData((int)1, (int)0x1000000, (int)-1, (int)-1), null);
        this.keepRatioField = new CheckField(keekRatioControl, ModelUiMessages.infoRatio, Boolean.valueOf(this.keepRatio()), this.getForm(), null);
        ControlValidators.MinMaxProvider<Integer> widthMinMaxProvider = new ControlValidators.MinMaxProvider<Integer>(){

            public Integer max() {
                return Short.MAX_VALUE;
            }

            public Integer min() {
                return LayoutUtils.INSTANCE.getMinDim((INodeRelation)DefaultPropertiesWizardPage.this.getInput()).x.intValue();
            }
        };
        this.widthField = new IntegerTextField(SWTUtils.createText((Composite)composite), ModelUiMessages.labelWidth, Integer.valueOf(initialDimension.x.intValue()), this.getForm(), ControlValidators.createIntValidator((ControlValidators.MinMaxProvider)widthMinMaxProvider));
        ((Text)this.widthField.getControl()).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DefaultPropertiesWizardPage.this.keepRatioField.getValue().booleanValue()) {
                    double newWidth = DefaultPropertiesWizardPage.this.widthField.getValue().intValue();
                    Double ratioedNewWidth = newWidth / ratio;
                    DefaultPropertiesWizardPage.this.keepRatioField.setValue((Object)false);
                    DefaultPropertiesWizardPage.this.heightField.setValue((Object)ratioedNewWidth.intValue());
                    DefaultPropertiesWizardPage.this.keepRatioField.setValue((Object)true);
                } else {
                    double currentRatio = DefaultPropertiesWizardPage.this.widthField.getValue().doubleValue() / DefaultPropertiesWizardPage.this.heightField.getValue().doubleValue();
                    keekRatioControl.setEnabled(Math.abs(ratio - currentRatio) < 0.1);
                }
            }
        });
        ControlValidators.MinMaxProvider<Integer> heightMinMaxProvider = new ControlValidators.MinMaxProvider<Integer>(){

            public Integer max() {
                return Short.MAX_VALUE;
            }

            public Integer min() {
                return LayoutUtils.INSTANCE.getMinDim((INodeRelation)DefaultPropertiesWizardPage.this.getInput()).y.intValue();
            }
        };
        this.heightField = new IntegerTextField(SWTUtils.createText((Composite)composite), ModelUiMessages.labelHeight, Integer.valueOf(initialDimension.y.intValue()), this.getForm(), ControlValidators.createIntValidator((ControlValidators.MinMaxProvider)heightMinMaxProvider));
        ((Text)this.heightField.getControl()).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DefaultPropertiesWizardPage.this.keepRatioField.getValue().booleanValue()) {
                    double newHeight = DefaultPropertiesWizardPage.this.heightField.getValue().intValue();
                    Double ratioedNewHeight = newHeight * ratio;
                    DefaultPropertiesWizardPage.this.keepRatioField.setValue((Object)false);
                    DefaultPropertiesWizardPage.this.widthField.setValue((Object)ratioedNewHeight.intValue());
                    DefaultPropertiesWizardPage.this.keepRatioField.setValue((Object)true);
                } else {
                    double currentRatio = DefaultPropertiesWizardPage.this.widthField.getValue().doubleValue() / DefaultPropertiesWizardPage.this.heightField.getValue().doubleValue();
                    keekRatioControl.setEnabled(Math.abs(ratio - currentRatio) < 0.1);
                }
            }
        });
        Pos position = (Pos)this.getInput().getProperty(PropertyDescriptors.CURRENT_POSITION);
        ControlValidators.MinMaxProvider<Integer> shortMinMaxProvider = new ControlValidators.MinMaxProvider<Integer>(){

            public Integer max() {
                return Short.MAX_VALUE;
            }

            public Integer min() {
                return Short.MIN_VALUE;
            }
        };
        this.xField = new IntegerTextField(SWTUtils.createText((Composite)composite), ModelUiMessages.labelX, Integer.valueOf(position.x.intValue()), this.getForm(), ControlValidators.createIntValidator((ControlValidators.MinMaxProvider)shortMinMaxProvider));
        this.yField = new IntegerTextField(SWTUtils.createText((Composite)composite), ModelUiMessages.labelY, Integer.valueOf(position.y.intValue()), this.getForm(), ControlValidators.createIntValidator((ControlValidators.MinMaxProvider)shortMinMaxProvider));
        Boolean opaque = (Boolean)this.getInput().getTarget().getProperty(PropertyDescriptors.OPAQUE);
        if (this.hasColor()) {
            SWTUtils.createLabel((Composite)composite, (String)PropertyDescriptors.COLOR.label);
            StudioColor color = (StudioColor)this.getInput().getTarget().getProperty(PropertyDescriptors.COLOR);
            this.colorSelector = new ColorSelector(composite);
            if (color != null) {
                this.colorSelector.setColorValue(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
            }
        }
        if (this.hasOpacity()) {
            this.opaqueField = new CheckField(SWTUtils.createButtonCheck((Composite)composite), PropertyDescriptors.OPAQUE.label, opaque, this.getForm(), null);
            ((Button)this.opaqueField.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (DefaultPropertiesWizardPage.this.alphaScale != null) {
                        DefaultPropertiesWizardPage.this.alphaScale.setEnabled(DefaultPropertiesWizardPage.this.opaqueField.getValue() == false);
                    }
                }
            });
            int alphaPercent = (int)Math.round((double)((Integer)this.getInput().getTarget().getProperty(PropertyDescriptors.ALPHA)).intValue() / 2.55);
            SWTUtils.createLabel((Composite)composite, (String)PropertyDescriptors.ALPHA.label);
            this.alphaScale = SWTUtils.createScale((Composite)composite, null, (int)alphaPercent, (int)100);
            this.alphaScale.setEnabled(opaque == false);
        }
        if (this.hasLine()) {
            CustomWizardPage.createDescriptorCombo(composite, (IObject)this.getInput().getTarget(), PropertyDescriptors.LINE, Line.values());
            final Spinner thicknessSpinner = SWTUtils.createSpiner((Composite)composite, (String)PropertyDescriptors.THICKNESS.label, (int)((Integer)this.getInput().getTarget().getProperty(PropertyDescriptors.THICKNESS)), (int)1, (int)9, (int)1, (int)5);
            thicknessSpinner.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DefaultPropertiesWizardPage.this.getInput().getTarget().addPropertyValue(PropertyDescriptors.THICKNESS, (Object)thicknessSpinner.getSelection());
                }
            });
            SWTUtils.createLabel((Composite)composite, (String)PropertyDescriptors.BORDER_COLOR.label);
            this.borderColorSelector = new ColorSelector(composite);
            StudioColor borderColor = (StudioColor)this.getInput().getTarget().getProperty(PropertyDescriptors.BORDER_COLOR);
            if (borderColor != null) {
                this.borderColorSelector.setColorValue(new RGB(borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue()));
            }
        }
        return composite;
    }

    @Override
    public Point getPageSize() {
        Point size = super.getPageSize();
        size.y += 150;
        if (this.hasLabel()) {
            size.y += 25;
        }
        if (this.hasFont()) {
            size.y += 50;
        }
        if (this.hasColor()) {
            size.y += 25;
        }
        if (this.hasLine()) {
            size.y += 75;
        }
        if (this.hasImage()) {
            size.y += 25;
        }
        return size;
    }

    protected boolean hasAlignement() {
        return false;
    }

    protected boolean hasColor() {
        return this.getInput().getTarget().getProperty(PropertyDescriptors.COLOR) != null;
    }

    protected boolean hasFont() {
        return this.hasLabel() && this.getInput().getTarget().getProperty(PropertyDescriptors.FONT) != null;
    }

    protected boolean hasImage() {
        return this.getInput().getTarget().getProperty(PropertyDescriptors.IMAGE) != null;
    }

    protected boolean hasLine() {
        return this.getInput().getTarget().getProperty(PropertyDescriptors.LINE) != null;
    }

    protected boolean hasOpacity() {
        return true;
    }

    protected boolean keepRatio() {
        return false;
    }

    @Override
    protected boolean needLabel() {
        return false;
    }

    @Override
    protected boolean performFinish() {
        Pos newDim;
        Pos newPos;
        super.performFinish();
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>(5);
        if (this.displayLabelField != null) {
            values.add(new PropertyValue(PropertyDescriptors.DISPLAY_LABEL, (Object)this.displayLabelField.getValue()));
        }
        if (this.newFontData != null) {
            StudioFont font = StudioRegistries.fontRegistry().getStudioFontFrom(this.newFontData);
            values.add(new PropertyValue(PropertyDescriptors.FONT, (Object)font));
        }
        if (this.colorSelector != null && this.colorSelector.getColorValue() != null) {
            StudioColor color = StudioRegistries.colorRegistry().getStudioColorFrom(this.colorSelector.getColorValue());
            values.add(new PropertyValue(PropertyDescriptors.COLOR, (Object)color));
        }
        if (this.fontColorSelector != null && this.fontColorSelector.getColorValue() != null) {
            StudioColor fontColor = StudioRegistries.colorRegistry().getStudioColorFrom(this.fontColorSelector.getColorValue());
            values.add(new PropertyValue(PropertyDescriptors.FONT_COLOR, (Object)fontColor));
        }
        if (this.borderColorSelector != null && this.borderColorSelector.getColorValue() != null) {
            StudioColor borderColor = StudioRegistries.colorRegistry().getStudioColorFrom(this.borderColorSelector.getColorValue());
            values.add(new PropertyValue(PropertyDescriptors.BORDER_COLOR, (Object)borderColor));
        }
        if (this.alphaScale != null) {
            int alphaValue = (int)Math.round((double)this.alphaScale.getSelection() * 2.55);
            values.add(new PropertyValue(PropertyDescriptors.ALPHA, (Object)alphaValue));
        }
        if (this.displayImageField != null && this.displayImageField.hasChanged()) {
            values.add(new PropertyValue(PropertyDescriptors.DISPLAY_IMAGE, (Object)this.displayImageField.getValue()));
        }
        if (this.opaqueField != null && this.opaqueField.hasChanged()) {
            values.add(new PropertyValue(PropertyDescriptors.OPAQUE, (Object)this.opaqueField.getValue()));
        }
        this.getInput().getTarget().addPropertyValues(values);
        ArrayList<PropertyValue> relationValues = new ArrayList<PropertyValue>(2);
        if ((this.xField.hasChanged() || this.yField.hasChanged()) && !(newPos = Pos.create((double)this.xField.getValue().intValue(), (double)this.yField.getValue().intValue())).equals(this.getInput().getProperty(PropertyDescriptors.CURRENT_POSITION))) {
            relationValues.add(new PropertyValue(PropertyDescriptors.CURRENT_POSITION, null));
            relationValues.add(new PropertyValue(PropertyDescriptors.POSITION, (Object)newPos));
        }
        if (this.widthField != null && this.heightField != null && (this.widthField.hasChanged() || this.heightField.hasChanged()) && !(newDim = Pos.create((double)this.widthField.getValue().intValue(), (double)this.heightField.getValue().intValue())).equals(this.getInput().getProperty(PropertyDescriptors.CURRENT_DIMENSION))) {
            relationValues.add(new PropertyValue(PropertyDescriptors.CURRENT_DIMENSION, null));
            relationValues.add(new PropertyValue(PropertyDescriptors.DIMENSION, (Object)newDim));
        }
        if (!relationValues.isEmpty()) {
            this.getInput().addPropertyValues(relationValues);
        }
        return true;
    }
}

