/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.dialogs;

import com.centreon.studio.client.commons.jface.validation.ControlValidators;
import com.centreon.studio.client.commons.jface.validation.field.impl.TextField;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.model.ui.messages.ModelUiMessages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class MinimalPropertiesWizardPage
extends CustomWizardPage {
    protected TextField labelField;
    private TextField descriptionField;
    private boolean useDescription;

    public MinimalPropertiesWizardPage(boolean useDescription) {
        this(MinimalPropertiesWizardPage.class.getSimpleName());
        this.useDescription = useDescription;
    }

    protected MinimalPropertiesWizardPage(String name) {
        super(name);
        this.setTitle(CommonsMessages.keywordEdit);
        this.setMessage(ModelUiMessages.infoEditImage);
    }

    @Override
    public Composite customCreateControl(Composite parent) {
        String value;
        INode target = this.getInput().getTarget();
        Composite composite = SWTUtils.createComposite((Composite)parent, (int)2, (boolean)false, (int)5, (int)5);
        if (this.hasLabel()) {
            ControlValidators.IControlValidator validator = this.needLabel() ? ControlValidators.TEXT_NON_EMPTY_VALIDATOR : null;
            value = (String)target.getProperty(AObject.LABEL);
            this.labelField = new TextField(SWTUtils.createText((Composite)composite), AObject.LABEL.label, value, this.getForm(), validator);
        }
        if (this.useDescription) {
            Text descriptionText = SWTUtils.createText((Composite)composite, (int)2626, (int)80, (int)-1);
            descriptionText.setLayoutData((Object)SWTUtils.createGridData((int)4, (int)4, (int)-1, (int)80));
            value = (String)target.getProperty(PropertyDescriptors.DESCRIPTION);
            this.descriptionField = new TextField(descriptionText, PropertyDescriptors.DESCRIPTION.label, value, this.getForm(), null);
        }
        return composite;
    }

    @Override
    public Point getPageSize() {
        if (this.useDescription) {
            return new Point(600, 100);
        }
        return new Point(300, 100);
    }

    protected boolean hasLabel() {
        return true;
    }

    protected boolean needLabel() {
        return true;
    }

    @Override
    protected boolean performFinish() {
        if (this.labelField != null) {
            this.getInput().getTarget().addPropertyValue(AObject.LABEL, (Object)this.labelField.getValue());
        }
        if (this.descriptionField != null) {
            this.getInput().getTarget().addPropertyValue(PropertyDescriptors.DESCRIPTION, (Object)this.descriptionField.getValue());
        }
        return true;
    }
}

