/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.dialogs;

import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.dialogs.CustomWizard;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardDialog;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.model.ui.dialogs.DefaultPropertiesWizardPage;
import com.centreon.studio.client.model.ui.dialogs.IWizardFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.contexts.IEclipseContext;

public enum WizardFactories implements IWizardFactory
{
    INSTANCE;

    private final Map<TypeDescriptor, IWizardFactory> factories = new HashMap<TypeDescriptor, IWizardFactory>(8);

    private static CustomWizardPage getCommon(CustomWizardPage first, CustomWizardPage second) {
        Class<?> clazz2;
        if (first == null) {
            return second;
        }
        Class<?> clazz1 = first.getClass();
        if (clazz1.equals(clazz2 = second.getClass()) || clazz1.isAssignableFrom(clazz2)) {
            return first;
        }
        if (clazz2.isAssignableFrom(clazz1)) {
            return second;
        }
        return null;
    }

    public CustomWizardDialog createDialog(Collection<INodeRelation> input, IEclipseContext context) {
        if (input == null) {
            return null;
        }
        if (input.size() == 1) {
            return this.createDialog(input.iterator().next(), context);
        }
        CustomWizardPage page = null;
        for (INodeRelation relation : input) {
            CustomWizardDialog dialog = this.createDialog(relation, context);
            if (dialog == null) {
                return null;
            }
            if ((page = WizardFactories.getCommon(page, dialog.getWizard().getPage(0))) == null) break;
        }
        if (page == null) {
            page = new DefaultPropertiesWizardPage("Multiple");
        }
        CustomWizard wizard = new CustomWizard("Multiple");
        wizard.registerPage(page);
        CustomWizardDialog dialog = new CustomWizardDialog(wizard);
        dialog.setInput(input);
        return dialog;
    }

    @Override
    public CustomWizardDialog createDialog(INodeRelation input, IEclipseContext context) {
        IWizardFactory factory = this.factories.get(input.getTarget().getType());
        if (factory != null) {
            return factory.createDialog(input, context);
        }
        return null;
    }

    public Set<TypeDescriptor> getSupportedTypes() {
        return Collections.unmodifiableSet(this.factories.keySet());
    }

    public void register(IWizardFactory factory) {
        for (TypeDescriptor type : factory.getSupportedTypes()) {
            this.factories.put(type, factory);
        }
    }
}

