/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.part;

import com.centreon.studio.client.model.ui.part.APart;
import com.centreon.studio.client.model.ui.part.PartCreationListener;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PartCreationNotifier
implements PartCreationListener {
    private final Collection<PartCreationListener> listeners = new HashSet<PartCreationListener>(2);

    @Override
    public void notifyPartCreated(APart part) {
        for (PartCreationListener listener : this.listeners) {
            listener.notifyPartCreated(part);
        }
    }

    public void registerListener(PartCreationListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(PartCreationListener listener) {
        this.listeners.remove(listener);
    }
}

