/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;

@Creatable
public enum StudioViewService implements IPartListener
{
    INSTANCE;

    public static final String PART_ID = "part.element.editor";
    public final MPart NULL_PART;
    private final List<ActiveViewChangedListener> viewChangedListeners;
    private MPart activeView;
    private EPartService partService;

    private static boolean isViewPart(MPart part) {
        return part.getElementId().startsWith(PART_ID);
    }

    private StudioViewService() {
        this.activeView = this.NULL_PART = MBasicFactory.INSTANCE.createPart();
        this.viewChangedListeners = new ArrayList<ActiveViewChangedListener>();
    }

    public MPart activeView() {
        return this.activeView;
    }

    public boolean isAnyViewActive() {
        return this.activeView != this.NULL_PART;
    }

    public void partActivated(MPart part) {
        if (!StudioViewService.isViewPart(part)) {
            return;
        }
        if (this.activeView == part) {
            return;
        }
        this.activeView = part;
        this.notifyActiveViewChanged();
    }

    public void partBroughtToTop(MPart part) {
    }

    public void partDeactivated(MPart part) {
        if (StudioViewService.isViewPart(part)) {
            return;
        }
        if (!this.isAnyViewOpened()) {
            this.activeView = this.NULL_PART;
            this.notifyActiveViewChanged();
        }
    }

    public void partHidden(MPart part) {
    }

    public void partVisible(MPart part) {
    }

    public void registrerViewChangedListener(ActiveViewChangedListener listener) {
        this.viewChangedListeners.add(listener);
    }

    public MPart retrievePart(PartIdentifier soughtPart) {
        for (MPart part : this.partService.getParts()) {
            if (!soughtPart.label.equals(part.getLabel())) continue;
            return part;
        }
        return this.NULL_PART;
    }

    public void setPartService(EPartService partService) {
        this.partService = partService;
        this.partService.addPartListener((IPartListener)this);
    }

    private boolean isAnyViewOpened() {
        boolean isAnyViewOpened = false;
        for (MPart p : this.partService.getParts()) {
            if (!StudioViewService.isViewPart(p)) continue;
            isAnyViewOpened = true;
            break;
        }
        return isAnyViewOpened;
    }

    private void notifyActiveViewChanged() {
        for (ActiveViewChangedListener listener : this.viewChangedListeners) {
            listener.notifyActiveViewChanged(this.activeView);
        }
    }

    public static interface ActiveViewChangedListener {
        public void notifyActiveViewChanged(MPart var1);
    }

    public static enum PartIdentifier {
        GATES("%labelGates"),
        ELEMENTS("%labelElements"),
        RESOURCES("%labelResources"),
        MEDIAS("%labelMedias"),
        PALETTE("%palette"),
        PROPERTIES("%properties");

        final String label;

        private PartIdentifier(String labelId) {
            this.label = labelId;
        }
    }
}

