/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.properties;

import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.properties.IPropertyDescriptor;
import com.centreon.studio.client.model.ui.properties.IPropertySource2;
import com.centreon.studio.client.model.ui.properties.PropertyDescriptorPropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

public class NodeRelationPropertiesSource
implements IPropertySource2 {
    private final INodeRelation relation;

    private static Collection<? extends IPropertyDescriptor> createDescriptors(IObject object) {
        boolean isRelation = object.adapt(INodeRelation.class) != null;
        Collection values = object.getPropertyValues();
        ArrayList<PropertyDescriptorPropertyDescriptor> result = new ArrayList<PropertyDescriptorPropertyDescriptor>(values.size());
        HashSet<PropertyDescriptor> descriptors = new HashSet<PropertyDescriptor>(values.size());
        for (PropertyValue pv : values) {
            if (Objects.equals(pv.getValue(), pv.getProperty().defaulValue)) continue;
            descriptors.add(pv.getProperty());
        }
        for (PropertyDescriptor pd : descriptors) {
            result.add(new PropertyDescriptorPropertyDescriptor(pd, isRelation));
        }
        if (object.getProperty(AObject.ID) != null) {
            result.add(new PropertyDescriptorPropertyDescriptor(AObject.ID, isRelation));
        }
        if (object.getProperty(AObject.TYPE) != null) {
            result.add(new PropertyDescriptorPropertyDescriptor(AObject.TYPE, isRelation));
        }
        return result;
    }

    public NodeRelationPropertiesSource(INodeRelation relation) {
        this.relation = relation;
    }

    @Override
    public Object getEditableValue() {
        return null;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.relation == null) {
            return new IPropertyDescriptor[0];
        }
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>();
        descriptors.addAll(NodeRelationPropertiesSource.createDescriptors((IObject)this.relation));
        descriptors.addAll(NodeRelationPropertiesSource.createDescriptors((IObject)this.relation.getTarget()));
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    @Override
    public Object getPropertyValue(Object id) {
        boolean isRelation = id.toString().startsWith(Boolean.TRUE.toString());
        String actualId = id.toString().replaceFirst(Boolean.TRUE.toString(), "").replaceFirst(Boolean.FALSE.toString(), "");
        PropertyDescriptor pd = PropertyDescriptor.getPropertyDescriptor((String)actualId);
        if (isRelation) {
            return this.relation.getProperty(pd);
        }
        return this.relation.getTarget().getProperty(pd);
    }

    @Override
    public boolean isPropertyResettable(Object id) {
        return false;
    }

    @Override
    public boolean isPropertySet(Object id) {
        PropertyDescriptor pd = PropertyDescriptor.getPropertyDescriptor((String)id.toString());
        Collection values = this.relation.getPropertyValues();
        values.addAll(this.relation.getTarget().getDefaultPropertyValues());
        for (PropertyValue pv : values) {
            if (pv.getProperty() != pd) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resetPropertyValue(Object id) {
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
    }
}

