/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.properties;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyFormatter;
import com.centreon.studio.client.model.ui.properties.IPropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class PropertyDescriptorPropertyDescriptor
extends ColumnLabelProvider
implements IPropertyDescriptor {
    private final PropertyDescriptor<?> descriptor;
    private final boolean isRelation;

    public PropertyDescriptorPropertyDescriptor(PropertyDescriptor<?> pd, boolean isRelation) {
        this.descriptor = pd;
        this.isRelation = isRelation;
    }

    @Override
    public CellEditor createPropertyEditor(Composite parent) {
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof Color) {
            return (Color)element;
        }
        Class clazz = this.descriptor.clazz;
        PropertyFormatter pf = PropertyFormatter.getPropetyFormatter((Class)clazz);
        if (pf == null) {
            return null;
        }
        String hexaColor = pf.toColor(element);
        StudioColor studioColor = StudioColor.fromHexadecimal((String)hexaColor);
        return StudioRegistries.colorRegistry().getSWTColorFrom(studioColor);
    }

    @Override
    public String getCategory() {
        if (this.isRelation) {
            return "Relation";
        }
        return this.descriptor.category;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.descriptor.label;
    }

    @Override
    public String[] getFilterFlags() {
        return new String[]{this.descriptor.category};
    }

    @Override
    public String getId() {
        return String.valueOf(Boolean.valueOf(this.isRelation).toString()) + this.descriptor.id;
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        if (!this.descriptor.id.startsWith("image")) {
            return null;
        }
        return SWTUtils.getImageFromUrl((String)element.toString(), (int)16, (int)16);
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this;
    }

    public String getText(Object element) {
        if (this.descriptor.id.startsWith("image")) {
            return "";
        }
        Class clazz = this.descriptor.clazz;
        PropertyFormatter pf = PropertyFormatter.getPropetyFormatter((Class)clazz);
        if (pf != null) {
            return pf.toString(element);
        }
        return element.toString();
    }

    @Override
    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return this.getId().equals(anotherProperty.getId());
    }
}

