/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.properties;

import com.centreon.studio.client.model.ui.properties.IPropertyDescriptor;
import com.centreon.studio.client.model.ui.properties.IPropertySheetEntry;
import com.centreon.studio.client.model.ui.properties.IPropertySheetEntryListener;
import com.centreon.studio.client.model.ui.properties.IPropertySource;
import com.centreon.studio.client.model.ui.properties.IPropertySource2;
import com.centreon.studio.client.model.ui.properties.IPropertySourceProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class PropertySheetEntry
extends EventManager
implements IPropertySheetEntry {
    private Object[] values = new Object[0];
    private Map<Object, IPropertySource> sources = new HashMap<Object, IPropertySource>(0);
    private Object editValue;
    private PropertySheetEntry parent;
    private IPropertySourceProvider propertySourceProvider;
    private IPropertyDescriptor descriptor;
    private CellEditor editor;
    private String errorText;
    private PropertySheetEntry[] childEntries;
    private final ICellEditorListener cellEditorListener = new ICellEditorListener(){

        public void applyEditorValue() {
            PropertySheetEntry.this.applyEditorValue();
        }

        public void cancelEditor() {
            PropertySheetEntry.this.setErrorText(null);
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            if (!newValidState) {
                PropertySheetEntry.this.setErrorText(PropertySheetEntry.this.editor.getErrorMessage());
            } else {
                PropertySheetEntry.this.setErrorText(null);
            }
        }
    };

    public static Object getAdapter(Object sourceObject, Class<?> adapter, boolean activatePlugins) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        if (sourceObject == null) {
            return null;
        }
        if (adapter.isInstance(sourceObject)) {
            return sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapter)) != null) {
            return result2;
        }
        if (!(sourceObject instanceof PlatformObject) && (result = activatePlugins ? Platform.getAdapterManager().loadAdapter(sourceObject, adapter.getName()) : Platform.getAdapterManager().getAdapter(sourceObject, adapter)) != null) {
            return result;
        }
        return null;
    }

    private static Map<Object, IPropertyDescriptor> computePropertyDescriptorsFor(IPropertySource source) {
        IPropertyDescriptor[] descriptors = source.getPropertyDescriptors();
        HashMap<Object, IPropertyDescriptor> result = new HashMap<Object, IPropertyDescriptor>(descriptors.length * 2 + 1);
        IPropertyDescriptor[] iPropertyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor descriptor2 = iPropertyDescriptorArray[n2];
            result.put(descriptor2.getId(), descriptor2);
            ++n2;
        }
        return result;
    }

    @Override
    public void addPropertySheetEntryListener(IPropertySheetEntryListener listener) {
        this.addListenerObject(listener);
    }

    @Override
    public void applyEditorValue() {
        if (this.editor == null) {
            return;
        }
        if (!this.editor.isValueValid()) {
            this.setErrorText(this.editor.getErrorMessage());
            return;
        }
        this.setErrorText(null);
        Object newValue = this.editor.getValue();
        boolean changed = false;
        if (this.values.length > 1) {
            changed = true;
        } else if (this.editValue == null) {
            if (newValue != null) {
                changed = true;
            }
        } else if (!this.editValue.equals(newValue)) {
            changed = true;
        }
        if (changed) {
            this.setValue(newValue);
        }
    }

    @Override
    public void dispose() {
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        PropertySheetEntry[] entriesToDispose = this.childEntries;
        this.childEntries = null;
        if (entriesToDispose != null) {
            PropertySheetEntry[] propertySheetEntryArray = entriesToDispose;
            int n = entriesToDispose.length;
            int n2 = 0;
            while (n2 < n) {
                PropertySheetEntry element = propertySheetEntryArray[n2];
                if (element != null) {
                    element.dispose();
                }
                ++n2;
            }
        }
    }

    @Override
    public String getCategory() {
        return this.descriptor.getCategory();
    }

    @Override
    public IPropertySheetEntry[] getChildEntries() {
        if (this.childEntries == null) {
            this.createChildEntries();
        }
        return this.childEntries;
    }

    @Override
    public String getDescription() {
        return this.descriptor.getDescription();
    }

    @Override
    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    @Override
    public CellEditor getEditor(Composite parent) {
        if (this.editor == null) {
            this.editor = this.descriptor.createPropertyEditor(parent);
            if (this.editor != null) {
                this.editor.addListener(this.cellEditorListener);
            }
        }
        if (this.editor != null) {
            this.editor.setValue(this.editValue);
            this.setErrorText(this.editor.getErrorMessage());
        }
        return this.editor;
    }

    @Override
    public String getErrorText() {
        return this.errorText;
    }

    @Override
    public String[] getFilters() {
        return this.descriptor.getFilterFlags();
    }

    @Override
    public String getId() {
        return this.descriptor.getId();
    }

    @Override
    public Image getImage() {
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider == null) {
            return null;
        }
        return provider.getImage(this.editValue);
    }

    @Override
    public String getValueAsString() {
        if (this.editValue == null) {
            return "";
        }
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider == null) {
            return this.editValue.toString();
        }
        String text = provider.getText(this.editValue);
        if (text == null) {
            return "";
        }
        return text;
    }

    public Object[] getValues() {
        return this.values;
    }

    @Override
    public boolean hasChildEntries() {
        if (this.childEntries != null && this.childEntries.length > 0) {
            return true;
        }
        return !this.computeMergedPropertyDescriptors().isEmpty();
    }

    @Override
    public void removePropertySheetEntryListener(IPropertySheetEntryListener listener) {
        this.removeListenerObject(listener);
    }

    @Override
    public void resetPropertyValue() {
        Object[] objects;
        if (this.parent == null) {
            return;
        }
        boolean change = false;
        Object[] objectArray = objects = this.parent.getValues();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertySource2 extendedSource;
            Object object = objectArray[n2];
            IPropertySource source = this.getPropertySource(object);
            if (source.isPropertySet(this.descriptor.getId()) && (!(source instanceof IPropertySource2) || (extendedSource = (IPropertySource2)source).isPropertyResettable(this.descriptor.getId()))) {
                source.resetPropertyValue(this.descriptor.getId());
                change = true;
            }
            ++n2;
        }
        if (change) {
            this.refreshFromRoot();
        }
    }

    public void setPropertySourceProvider(IPropertySourceProvider provider) {
        this.propertySourceProvider = provider;
    }

    @Override
    public void setValues(Object[] objects) {
        this.values = Arrays.copyOf(objects, objects.length);
        this.sources = new HashMap<Object, IPropertySource>(this.values.length * 2 + 1);
        if (this.values.length == 0) {
            this.editValue = null;
        } else {
            Object newValue = this.values[0];
            IPropertySource source = this.getPropertySource(newValue);
            if (source != null) {
                newValue = source.getEditableValue();
            }
            this.editValue = newValue;
        }
        this.refreshChildEntries();
        this.fireValueChanged();
    }

    protected PropertySheetEntry createChildEntry() {
        return new PropertySheetEntry();
    }

    protected Color getBackground() {
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider instanceof IColorProvider) {
            return ((IColorProvider)provider).getBackground(this.editValue);
        }
        return null;
    }

    protected IPropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected Object getEditValue(int index) {
        Object value = this.values[index];
        IPropertySource source = this.getPropertySource(value);
        if (source != null) {
            value = source.getEditableValue();
        }
        return value;
    }

    protected Font getFont() {
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider instanceof IFontProvider) {
            return ((IFontProvider)provider).getFont((Object)this);
        }
        return null;
    }

    protected Color getForeground() {
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider instanceof IColorProvider) {
            return ((IColorProvider)provider).getForeground((Object)this);
        }
        return null;
    }

    protected PropertySheetEntry getParent() {
        return this.parent;
    }

    protected IPropertySource getPropertySource(Object object) {
        if (this.sources.containsKey(object)) {
            return this.sources.get(object);
        }
        IPropertySource result = null;
        IPropertySourceProvider provider = this.propertySourceProvider;
        if (provider == null && object != null) {
            provider = (IPropertySourceProvider)PropertySheetEntry.getAdapter(object, IPropertySourceProvider.class, false);
        }
        result = provider != null ? provider.getPropertySource(object) : (IPropertySource)PropertySheetEntry.getAdapter(object, IPropertySource.class, false);
        this.sources.put(object, result);
        return result;
    }

    protected void refreshFromRoot() {
        if (this.parent == null) {
            this.refreshChildEntries();
        } else {
            this.parent.refreshFromRoot();
        }
    }

    protected void valueChanged(PropertySheetEntry child) {
        int i = 0;
        while (i < this.values.length) {
            IPropertySource source = this.getPropertySource(this.values[i]);
            source.setPropertyValue(child.getDescriptor().getId(), child.getEditValue(i));
            ++i;
        }
        if (this.parent != null) {
            this.parent.valueChanged(this);
        }
    }

    private List<IPropertyDescriptor> computeMergedPropertyDescriptors() {
        IPropertyDescriptor[] firstDescs;
        if (this.values.length == 0) {
            return new ArrayList<IPropertyDescriptor>(0);
        }
        IPropertySource firstSource = this.getPropertySource(this.values[0]);
        if (firstSource == null) {
            return new ArrayList<IPropertyDescriptor>(0);
        }
        if (this.values.length == 1) {
            return Arrays.asList(firstSource.getPropertyDescriptors());
        }
        Map[] propertyDescriptorMaps = new Map[this.values.length];
        int i = 0;
        while (i < this.values.length) {
            Object object = this.values[i];
            IPropertySource source = this.getPropertySource(object);
            if (source == null) {
                return new ArrayList<IPropertyDescriptor>(0);
            }
            propertyDescriptorMaps[i] = PropertySheetEntry.computePropertyDescriptorsFor(source);
            ++i;
        }
        Map intersection = propertyDescriptorMaps[0];
        int i2 = 1;
        while (i2 < propertyDescriptorMaps.length) {
            Object[] ids = intersection.keySet().toArray();
            int j = 0;
            while (j < ids.length) {
                Object object = propertyDescriptorMaps[i2].get(ids[j]);
                if (object == null || !((IPropertyDescriptor)intersection.get(ids[j])).isCompatibleWith((IPropertyDescriptor)object)) {
                    intersection.remove(ids[j]);
                }
                ++j;
            }
            ++i2;
        }
        ArrayList<IPropertyDescriptor> result = new ArrayList<IPropertyDescriptor>(intersection.size());
        IPropertyDescriptor[] iPropertyDescriptorArray = firstDescs = firstSource.getPropertyDescriptors();
        int n = firstDescs.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor desc = iPropertyDescriptorArray[n2];
            if (intersection.containsKey(desc.getId())) {
                result.add(desc);
            }
            ++n2;
        }
        return result;
    }

    private void createChildEntries() {
        List<IPropertyDescriptor> descriptors = this.computeMergedPropertyDescriptors();
        PropertySheetEntry[] newEntries = new PropertySheetEntry[descriptors.size()];
        int i = 0;
        while (i < descriptors.size()) {
            IPropertyDescriptor d = descriptors.get(i);
            PropertySheetEntry entry = this.createChildEntry();
            entry.setDescriptor(d);
            entry.setParent(this);
            entry.setPropertySourceProvider(this.propertySourceProvider);
            entry.refreshValues();
            newEntries[i] = entry;
            ++i;
        }
        this.childEntries = newEntries;
    }

    private void fireChildEntriesChanged() {
        Object[] array;
        Object[] objectArray = array = this.getListeners();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)element;
            listener.childEntriesChanged(this);
            ++n2;
        }
    }

    private void fireErrorMessageChanged() {
        Object[] array;
        Object[] objectArray = array = this.getListeners();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)element;
            listener.errorMessageChanged(this);
            ++n2;
        }
    }

    private void fireValueChanged() {
        Object[] array;
        Object[] objectArray = array = this.getListeners();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IPropertySheetEntryListener listener = (IPropertySheetEntryListener)element;
            listener.valueChanged(this);
            ++n2;
        }
    }

    private void refreshChildEntries() {
        if (this.childEntries == null) {
            return;
        }
        List<IPropertyDescriptor> descriptors = this.computeMergedPropertyDescriptors();
        HashMap<String, PropertySheetEntry> entryCache = new HashMap<String, PropertySheetEntry>(this.childEntries.length * 2 + 1);
        PropertySheetEntry[] propertySheetEntryArray = this.childEntries;
        int n = this.childEntries.length;
        int n2 = 0;
        while (n2 < n) {
            PropertySheetEntry childEntry = propertySheetEntryArray[n2];
            if (childEntry != null) {
                entryCache.put(childEntry.getDescriptor().getId(), childEntry);
            }
            ++n2;
        }
        ArrayList<PropertySheetEntry> entriesToDispose = new ArrayList<PropertySheetEntry>(Arrays.asList(this.childEntries));
        this.childEntries = null;
        PropertySheetEntry[] newEntries = new PropertySheetEntry[descriptors.size()];
        boolean entriesChanged = descriptors.size() != entryCache.size();
        int i = 0;
        while (i < descriptors.size()) {
            IPropertyDescriptor d = descriptors.get(i);
            PropertySheetEntry entry = (PropertySheetEntry)entryCache.get(d.getId());
            if (entry != null) {
                entry.setDescriptor(d);
                entriesToDispose.remove(entry);
            } else {
                entry = this.createChildEntry();
                entry.setDescriptor(d);
                entry.setParent(this);
                entry.setPropertySourceProvider(this.propertySourceProvider);
                entriesChanged = true;
            }
            entry.refreshValues();
            newEntries[i] = entry;
            ++i;
        }
        this.childEntries = newEntries;
        if (entriesChanged) {
            this.fireChildEntriesChanged();
        }
        i = 0;
        while (i < entriesToDispose.size()) {
            ((IPropertySheetEntry)entriesToDispose.get(i)).dispose();
            ++i;
        }
    }

    private void refreshValues() {
        Object[] currentSources = this.parent.getValues();
        Object[] newValues = new Object[currentSources.length];
        int i = 0;
        while (i < currentSources.length) {
            IPropertySource source = this.parent.getPropertySource(currentSources[i]);
            newValues[i] = source.getPropertyValue(this.descriptor.getId());
            ++i;
        }
        this.setValues(newValues);
    }

    private void setDescriptor(IPropertyDescriptor newDescriptor) {
        if (this.descriptor != newDescriptor && this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        this.descriptor = newDescriptor;
    }

    private void setErrorText(String newErrorText) {
        this.errorText = newErrorText;
        this.fireErrorMessageChanged();
    }

    private void setParent(PropertySheetEntry propertySheetEntry) {
        this.parent = propertySheetEntry;
    }

    private void setValue(Object newValue) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = newValue;
            ++i;
        }
        this.parent.valueChanged(this);
        this.refreshFromRoot();
    }
}

