/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.ui.tooltips;

import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.tooltips.ATooltip;
import com.centreon.studio.client.model.ui.tooltips.ITooltipFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.contexts.IEclipseContext;

public enum TooltipFactories implements ITooltipFactory
{
    INSTANCE;

    private final Map<TypeDescriptor, ITooltipFactory> factories = new HashMap<TypeDescriptor, ITooltipFactory>(8);

    @Override
    public ATooltip create(INodeRelation relation, IEclipseContext context) {
        TypeDescriptor typeOfTarget = relation.getTarget().getType();
        ITooltipFactory factory = this.factories.get(typeOfTarget);
        return factory == null ? null : factory.create(relation, context);
    }

    public Set<TypeDescriptor> getSupportedTypes() {
        return Collections.unmodifiableSet(this.factories.keySet());
    }

    public void register(ITooltipFactory factory) {
        for (TypeDescriptor type : factory.getSupportedTypes()) {
            this.factories.put(type, factory);
        }
    }
}

