/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.about;

import com.centreon.studio.client.workbench.Activator;
import com.centreon.studio.client.workbench.about.AboutData;
import com.centreon.studio.client.workbench.about.WorkbenchMessages;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class AboutBundleData
extends AboutData {
    private final Bundle bundle;
    private boolean isSignedDetermined = false;
    private boolean isSigned;

    private static String getResourceString(Bundle bundle, String headerName) {
        String value = (String)bundle.getHeaders().get(headerName);
        return value == null ? null : Platform.getResourceString((Bundle)bundle, (String)value);
    }

    public AboutBundleData(Bundle bundle) {
        super(AboutBundleData.getResourceString(bundle, "Bundle-Vendor"), AboutBundleData.getResourceString(bundle, "Bundle-Name"), AboutBundleData.getResourceString(bundle, "Bundle-Version"), bundle.getSymbolicName());
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public int getState() {
        return this.bundle.getState();
    }

    public String getStateName() {
        switch (this.getState()) {
            case 2: {
                return WorkbenchMessages.AboutPluginsDialog_state_installed;
            }
            case 4: {
                return WorkbenchMessages.AboutPluginsDialog_state_resolved;
            }
            case 8: {
                return WorkbenchMessages.AboutPluginsDialog_state_starting;
            }
            case 16: {
                return WorkbenchMessages.AboutPluginsDialog_state_stopping;
            }
            case 1: {
                return WorkbenchMessages.AboutPluginsDialog_state_uninstalled;
            }
            case 32: {
                return WorkbenchMessages.AboutPluginsDialog_state_active;
            }
        }
        return WorkbenchMessages.AboutPluginsDialog_state_unknown;
    }

    public boolean isSigned() {
        if (this.isSignedDetermined) {
            return this.isSigned;
        }
        BundleContext bundleContext = Activator.getContext();
        ServiceReference factoryRef = bundleContext.getServiceReference(SignedContentFactory.class.getName());
        if (factoryRef == null) {
            throw new IllegalStateException();
        }
        SignedContentFactory contentFactory = (SignedContentFactory)bundleContext.getService(factoryRef);
        try {
            SignedContent signedContent = contentFactory.getSignedContent(this.bundle);
            this.isSigned = signedContent != null && signedContent.isSigned();
            this.isSignedDetermined = true;
            boolean bl = this.isSigned;
            return bl;
        }
        catch (IOException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (GeneralSecurityException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        finally {
            bundleContext.ungetService(factoryRef);
        }
    }

    public boolean isSignedDetermined() {
        return this.isSignedDetermined;
    }
}

