/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.about;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.workbench.Activator;
import com.centreon.studio.client.workbench.about.AboutBundleData;
import com.centreon.studio.client.workbench.about.BundlePatternFilter;
import com.centreon.studio.client.workbench.about.BundleSigningInfo;
import com.centreon.studio.client.workbench.about.ProductInfoPage;
import com.centreon.studio.client.workbench.about.TableComparator;
import com.centreon.studio.client.workbench.about.WorkbenchJob;
import com.centreon.studio.client.workbench.about.WorkbenchMessages;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.SequencedCollection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.ConfigureColumns;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class AboutPluginsPage
extends ProductInfoPage {
    private static final String ID = "productInfo.plugins";
    private static final int TABLE_HEIGHT = 200;
    private static final int MORE_ID = 1025;
    private static final int SIGNING_ID = 1026;
    private static final int COLUMNS_ID = 1027;
    private static final IPath BASE_NL_PATH = new Path("$nl$");
    private static final String PLUGININFO = "about.html";
    private static final int PLUGIN_NAME_COLUMN_INDEX = 2;
    private static final int SIGNING_AREA_PERCENTAGE = 30;
    private static final String[] COLUMN_TITLES = new String[]{WorkbenchMessages.AboutPluginsDialog_signed, WorkbenchMessages.AboutPluginsDialog_provider, WorkbenchMessages.AboutPluginsDialog_pluginName, WorkbenchMessages.AboutPluginsDialog_version, WorkbenchMessages.AboutPluginsDialog_pluginId};
    private Bundle[] bundles = Activator.getContext().getBundles();
    private TableViewer vendorInfo;
    private AboutBundleData[] bundleInfos;
    private SashForm sashForm;
    private BundleSigningInfo signingArea;
    private Button moreInfo;
    private Button signingInfo;
    private String message;

    private static URL getMoreInfoURL(AboutBundleData bundleInfo, boolean makeLocal) {
        Bundle bundle = Platform.getBundle((String)bundleInfo.getId());
        if (bundle == null) {
            return null;
        }
        URL aboutUrl = Platform.find((Bundle)bundle, (IPath)BASE_NL_PATH.append(PLUGININFO), null);
        if (!makeLocal) {
            return aboutUrl;
        }
        if (aboutUrl != null) {
            try {
                URL result = Platform.asLocalURL((URL)aboutUrl);
                try {
                    new URL(aboutUrl, "about_files");
                }
                catch (IOException iOException) {}
                return result;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static boolean isReady(int bundleState) {
        return (bundleState & 0x3C) != 0;
    }

    private static boolean selectionHasInfo(AboutBundleData bundleInfo) {
        URL infoURL = AboutPluginsPage.getMoreInfoURL(bundleInfo, false);
        if (infoURL == null) {
            System.err.println("Problem reading plugin info for: " + bundleInfo.getName());
        }
        return infoURL != null;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        HashMap<String, AboutBundleData> map = new HashMap<String, AboutBundleData>();
        Bundle[] bundleArray = this.bundles;
        int n = this.bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            AboutBundleData data = new AboutBundleData(bundle);
            if (AboutPluginsPage.isReady(data.getState()) && !map.containsKey(data.getVersionedId())) {
                map.put(data.getVersionedId(), data);
            }
            ++n2;
        }
        this.bundleInfos = map.values().toArray(new AboutBundleData[0]);
        Activator.class.getSigners();
        this.sashForm = new SashForm(parent, 65792);
        FillLayout layout = new FillLayout();
        this.sashForm.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData data = new GridData(1808);
        this.sashForm.setLayoutData((Object)data);
        Composite outer = this.createOuterComposite((Composite)this.sashForm);
        if (this.message != null) {
            Label label = new Label(outer, 0);
            label.setLayoutData((Object)new GridData(768));
            label.setFont(parent.getFont());
            label.setText(this.message);
        }
        this.createTable(outer);
        this.setControl((Control)outer);
    }

    @Override
    public void createPageButtons(Composite parent) {
        this.moreInfo = this.createButton(parent, 1025, WorkbenchMessages.AboutPluginsDialog_moreInfo);
        this.moreInfo.setEnabled(false);
        this.signingInfo = this.createButton(parent, 1026, WorkbenchMessages.AboutPluginsDialog_signingInfo_show);
        this.signingInfo.setEnabled(false);
        this.createButton(parent, 1027, WorkbenchMessages.AboutPluginsDialog_columns);
    }

    public void setBundles(Bundle[] bundles) {
        this.bundles = Arrays.copyOf(bundles, bundles.length);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.handleMoreInfoPressed();
                break;
            }
            case 1026: {
                this.handleSigningInfoPressed();
                break;
            }
            case 1027: {
                this.handleColumnsPressed();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    @Override
    String getId() {
        return ID;
    }

    private void checkEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.vendorInfo.getSelection();
        if (selection.getFirstElement() instanceof AboutBundleData) {
            AboutBundleData selected = (AboutBundleData)selection.getFirstElement();
            this.moreInfo.setEnabled(AboutPluginsPage.selectionHasInfo(selected));
            this.signingInfo.setEnabled(true);
            if (this.signingArea != null) {
                this.signingArea.setData(selected);
            }
        } else {
            this.signingInfo.setEnabled(false);
            this.moreInfo.setEnabled(false);
        }
    }

    private void createTable(Composite parent) {
        final Text filterText = new Text(parent, 2432);
        filterText.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        filterText.setMessage(WorkbenchMessages.AboutPluginsDialog_filterTextMessage);
        filterText.setFocus();
        this.vendorInfo = new TableViewer(parent, 68356);
        this.vendorInfo.setUseHashlookup(true);
        this.vendorInfo.getTable().setHeaderVisible(true);
        this.vendorInfo.getTable().setLinesVisible(true);
        this.vendorInfo.getTable().setFont(parent.getFont());
        this.vendorInfo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AboutPluginsPage.this.checkEnablement();
            }
        });
        TableComparator comparator = new TableComparator();
        this.vendorInfo.setComparator((ViewerComparator)comparator);
        int[] columnWidths = new int[]{this.convertHorizontalDLUsToPixels(30), this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(70), this.convertHorizontalDLUsToPixels(130)};
        int i = 0;
        while (i < COLUMN_TITLES.length) {
            TableColumn column = new TableColumn(this.vendorInfo.getTable(), 0);
            if (i == 2) {
                this.updateTableSorting(i);
            }
            column.setWidth(columnWidths[i]);
            column.setText(COLUMN_TITLES[i]);
            final int columnIndex = i++;
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AboutPluginsPage.this.updateTableSorting(columnIndex);
                }
            });
        }
        this.vendorInfo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.vendorInfo.setLabelProvider((IBaseLabelProvider)new BundleTableLabelProvider());
        final BundlePatternFilter searchFilter = new BundlePatternFilter();
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                searchFilter.setPattern(filterText.getText());
                AboutPluginsPage.this.vendorInfo.refresh();
            }
        });
        this.vendorInfo.addFilter((ViewerFilter)searchFilter);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertVerticalDLUsToPixels(200);
        this.vendorInfo.getTable().setLayoutData((Object)gridData);
        this.vendorInfo.setInput((Object)this.bundleInfos);
    }

    private void handleColumnsPressed() {
        ConfigureColumns.forTable((Table)this.vendorInfo.getTable(), (IShellProvider)this);
    }

    private void handleMoreInfoPressed() {
        if (this.vendorInfo == null) {
            return;
        }
        if (this.vendorInfo.getSelection().isEmpty()) {
            return;
        }
        AboutBundleData bundleInfo = (AboutBundleData)((IStructuredSelection)this.vendorInfo.getSelection()).getFirstElement();
        if (!Program.launch((String)AboutPluginsPage.getMoreInfoURL(bundleInfo, true).toString())) {
            String errorMessage = NLS.bind((String)WorkbenchMessages.AboutPluginsDialog_unableToOpenFile, (Object)PLUGININFO, (Object)bundleInfo.getId());
            System.err.println(String.valueOf(WorkbenchMessages.AboutPluginsDialog_errorTitle) + ": " + errorMessage);
        }
    }

    private void handleSigningInfoPressed() {
        if (this.signingArea == null) {
            this.signingArea = new BundleSigningInfo();
            AboutBundleData bundleInfo = (AboutBundleData)((IStructuredSelection)this.vendorInfo.getSelection()).getFirstElement();
            this.signingArea.setData(bundleInfo);
            this.signingArea.createContents((Composite)this.sashForm);
            this.sashForm.setWeights(new int[]{70, 30});
            this.signingInfo.setText(WorkbenchMessages.AboutPluginsDialog_signingInfo_hide);
        } else {
            this.signingInfo.setText(WorkbenchMessages.AboutPluginsDialog_signingInfo_show);
            this.signingArea.dispose();
            this.signingArea = null;
            this.sashForm.setWeights(new int[]{100});
        }
    }

    private void updateTableSorting(int columnIndex) {
        TableComparator comparator = (TableComparator)this.vendorInfo.getComparator();
        if (columnIndex == comparator.getSortColumn()) {
            comparator.setAscending(!comparator.isAscending());
        }
        comparator.setSortColumn(columnIndex);
        this.vendorInfo.getTable().setSortColumn(this.vendorInfo.getTable().getColumn(columnIndex));
        this.vendorInfo.getTable().setSortDirection(comparator.isAscending() ? 128 : 1024);
        this.vendorInfo.refresh(false);
    }

    private class BundleTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final Deque<AboutBundleData> resolveQueue = new LinkedList<AboutBundleData>();
        private final List<AboutBundleData> updateQueue = new ArrayList<AboutBundleData>();
        private final Job resolveJob = new Job(AboutPluginsPage.class.getName()){
            {
                this.setSystem(true);
                this.setPriority(20);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                while (AboutPluginsPage.this.vendorInfo != null) {
                    Table table = AboutPluginsPage.this.vendorInfo.getTable();
                    if (table == null || table.isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    AboutBundleData data = null;
                    SequencedCollection sequencedCollection = BundleTableLabelProvider.this.resolveQueue;
                    synchronized (sequencedCollection) {
                        if (BundleTableLabelProvider.this.resolveQueue.isEmpty()) {
                            return Status.OK_STATUS;
                        }
                        data = (AboutBundleData)BundleTableLabelProvider.this.resolveQueue.removeFirst();
                    }
                    try {
                        data.isSigned();
                        sequencedCollection = BundleTableLabelProvider.this.updateQueue;
                        synchronized (sequencedCollection) {
                            BundleTableLabelProvider.this.updateQueue.add(data);
                        }
                        BundleTableLabelProvider.this.updateJob.schedule();
                        continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        continue;
                    }
                    break;
                }
                return Status.OK_STATUS;
            }
        };
        private final Job updateJob = new WorkbenchJob(SWTUtils.getDisplay(), AboutPluginsPage.class.getName()){
            {
                this.setSystem(true);
                this.setPriority(50);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                Control page;
                while ((page = AboutPluginsPage.this.getControl()) != null && !page.isDisposed()) {
                    Object[] data = null;
                    List list = BundleTableLabelProvider.this.updateQueue;
                    synchronized (list) {
                        if (BundleTableLabelProvider.this.updateQueue.isEmpty()) {
                            return Status.OK_STATUS;
                        }
                        data = BundleTableLabelProvider.this.updateQueue.toArray(new AboutBundleData[BundleTableLabelProvider.this.updateQueue.size()]);
                        BundleTableLabelProvider.this.updateQueue.clear();
                    }
                    BundleTableLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)BundleTableLabelProvider.this, data));
                }
                return Status.OK_STATUS;
            }
        };

        private BundleTableLabelProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof AboutBundleData) {
                AboutBundleData data = (AboutBundleData)element;
                if (data.isSignedDetermined()) {
                    if (data.isSigned()) {
                        return SWTUtils.getImageFromUrl((String)"platform:/plugin/com.centreon.studio.client.workbench/icons/signed_yes_tbl.png");
                    }
                    return SWTUtils.getImageFromUrl((String)"platform:/plugin/com.centreon.studio.client.workbench/icons/signed_no_tbl.png");
                }
                Deque<AboutBundleData> deque = this.resolveQueue;
                synchronized (deque) {
                    this.resolveQueue.add(data);
                }
                this.resolveJob.schedule();
                return SWTUtils.getImageFromUrl((String)"platform:/plugin/com.centreon.studio.client.workbench/icons/signed_unkn_tbl.png");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof AboutBundleData) {
                AboutBundleData data = (AboutBundleData)element;
                switch (columnIndex) {
                    case 1: {
                        return data.getProviderName();
                    }
                    case 2: {
                        return data.getName();
                    }
                    case 3: {
                        return data.getVersion();
                    }
                    case 4: {
                        return data.getId();
                    }
                }
            }
            return "";
        }
    }
}

