/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.properties;

import com.centreon.studio.client.workbench.properties.Cell;
import com.centreon.studio.client.workbench.properties.CellInfo;
import com.centreon.studio.client.workbench.properties.MainView;
import com.centreon.studio.client.workbench.properties.ResourceManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class CellListener
extends MouseAdapter {
    private MainView view = null;
    private List<CellInfo> list = null;
    private boolean grayed = false;

    public CellListener(MainView view) {
        this.view = view;
    }

    public void mouseDown(MouseEvent e) {
        if (this.view.getController().getPreferences().isSoundEnabled()) {
            ResourceManager.INSTANCE.getSound("bip.wav").play();
        }
        if (!this.view.getTimer().isRunning()) {
            this.view.getTimer().start();
            this.view.getPauseAction().setIsGamePaused(false);
        }
        if (((Cell)((Object)e.getSource())).isButton()) {
            this.mouseDownForButtonType(e);
        } else {
            this.mouseDownForLabelType(e);
        }
    }

    public void mouseUp(MouseEvent e) {
        if (((Cell)((Object)e.getSource())).isButton()) {
            this.mouseUpForButtonType(e);
        } else {
            this.mouseUpForLabelType();
        }
    }

    public void mouseUpForLabelType() {
        Control[] cells = null;
        CellInfo cellInfo = null;
        Cell cell = null;
        this.view.getMainButton().setImage(ResourceManager.INSTANCE.getImage("smile.gif"));
        if (this.grayed) {
            this.grayed = false;
            cells = this.view.getMinesField().getChildren();
            int i = 0;
            while (i < this.list.size()) {
                cellInfo = this.list.get(i);
                cell = (Cell)cells[cellInfo.getLocation().y + cellInfo.getLocation().x * this.view.getController().getPreferences().getColumns()];
                if (cell.isShadow()) {
                    if (cellInfo.isQuestion()) {
                        cell.setImage(ResourceManager.INSTANCE.getImage("question.gif"));
                    }
                    cell.setType(1);
                    cell.redraw();
                }
                ++i;
            }
            this.list = null;
        }
        if (this.view.getController().isGameFinished()) {
            this.view.getController().finishGame();
        }
    }

    private void mouseDownForButtonType(MouseEvent e) {
        Cell cell = null;
        CellInfo cellInfo = null;
        if (e.button == 1) {
            cell = (Cell)((Object)e.getSource());
            cellInfo = (CellInfo)cell.getData();
            if (!cellInfo.isFlag()) {
                this.view.getMainButton().setImage(ResourceManager.INSTANCE.getImage("surprise.gif"));
            }
        } else {
            cell = (Cell)((Object)e.getSource());
            cellInfo = (CellInfo)cell.getData();
            if (!(cellInfo.isFlag() || cellInfo.isQuestion() || this.view.getCounter().isZero())) {
                cellInfo.setFlag(true);
                cell.setImage(ResourceManager.INSTANCE.getImage("flag.gif"));
                this.view.getCounter().decrease();
            } else if (cellInfo.isFlag()) {
                cellInfo.setFlag(false);
                cellInfo.setQuestion(true);
                cell.setImage(ResourceManager.INSTANCE.getImage("question.gif"));
                this.view.getCounter().increase();
            } else {
                cellInfo.setQuestion(false);
                cell.setImage(null);
            }
            cell.redraw();
        }
    }

    private void mouseDownForLabelType(MouseEvent e) {
        CellInfo cellInfo = null;
        Control[] cells = null;
        Cell cell = null;
        CellInfo aux = null;
        this.view.getMainButton().setImage(ResourceManager.INSTANCE.getImage("surprise.gif"));
        if (e.button == 3 && e.stateMask == 524288) {
            this.list = new ArrayList<CellInfo>();
            this.list = this.view.getController().showAllCellsAround((CellInfo)((Cell)((Object)e.getSource())).getData());
            cellInfo = (CellInfo)((Cell)((Object)e.getSource())).getData();
            int warnings = cellInfo.getWarning();
            int check = 0;
            int i = 0;
            while (i < this.list.size()) {
                cellInfo = this.list.get(i);
                if (cellInfo.isFlag()) {
                    ++check;
                }
                ++i;
            }
            if (warnings == check) {
                cells = this.view.getMinesField().getChildren();
                i = 0;
                while (i < this.list.size()) {
                    cellInfo = this.list.get(i);
                    cell = (Cell)cells[cellInfo.getLocation().y + cellInfo.getLocation().x * this.view.getController().getPreferences().getColumns()];
                    if (cell.isButton() && !cellInfo.isFlag()) {
                        cell.setType(2);
                        if (cellInfo.isMine()) {
                            this.view.getTimer().stop();
                            cell.setImage(ResourceManager.INSTANCE.getImage("explosion.gif"));
                            cell.setBackground(Display.getCurrent().getSystemColor(3));
                            if (this.view.getController().getPreferences().isSoundEnabled()) {
                                ResourceManager.INSTANCE.getSound("explode.wav").play();
                            }
                            this.view.getMainButton().setImage(ResourceManager.INSTANCE.getImage("sad.gif"));
                        } else if (cellInfo.getWarning() != 0) {
                            cell.setImage(ResourceManager.INSTANCE.getImage(String.valueOf(Integer.toString(cellInfo.getWarning())) + "mines.gif"));
                        } else {
                            aux = cellInfo;
                        }
                        cell.redraw();
                        if (cellInfo.isMine()) {
                            this.view.getController().showAllMines();
                        }
                    }
                    ++i;
                }
                this.list = null;
                if (aux != null) {
                    this.list = new ArrayList<CellInfo>();
                    this.view.getController().showAllZeroWarningsAround(aux, this.list);
                    cells = this.view.getMinesField().getChildren();
                    i = 1;
                    while (i < this.list.size()) {
                        cellInfo = this.list.get(i);
                        if (!cellInfo.isFlag()) {
                            cell = (Cell)cells[cellInfo.getLocation().y + cellInfo.getLocation().x * this.view.getController().getPreferences().getColumns()];
                            cell.setType(2);
                            if (cellInfo.getWarning() != 0) {
                                cell.setImage(ResourceManager.INSTANCE.getImage(String.valueOf(Integer.toString(cellInfo.getWarning())) + "mines.gif"));
                            }
                            cell.redraw();
                        }
                        ++i;
                    }
                    this.list = null;
                }
            } else {
                this.grayed = true;
                cells = this.view.getMinesField().getChildren();
                i = 0;
                while (i < this.list.size()) {
                    cellInfo = this.list.get(i);
                    cell = (Cell)cells[cellInfo.getLocation().y + cellInfo.getLocation().x * this.view.getController().getPreferences().getColumns()];
                    if (cell.isButton() && !cellInfo.isFlag()) {
                        cell.setImage(null);
                        cell.setType(4);
                        cell.redraw();
                    }
                    ++i;
                }
            }
        }
    }

    private void mouseUpForButtonType(MouseEvent e) {
        Control[] cells = null;
        CellInfo cellInfo = null;
        Cell cell = null;
        if (e.button == 1 && !(cellInfo = (CellInfo)(cell = (Cell)((Object)e.getSource())).getData()).isFlag()) {
            cell.setType(2);
            if (cellInfo.isMine()) {
                this.view.getTimer().stop();
                cell.setImage(ResourceManager.INSTANCE.getImage("explosion.gif"));
                cell.setBackground(Display.getCurrent().getSystemColor(3));
                cell.redraw();
                if (this.view.getController().getPreferences().isSoundEnabled()) {
                    ResourceManager.INSTANCE.getSound("explode.wav").play();
                }
                this.view.getMainButton().setImage(ResourceManager.INSTANCE.getImage("sad.gif"));
                this.view.getController().showAllMines();
            } else {
                if (cellInfo.getWarning() == 0) {
                    if (cellInfo.isQuestion()) {
                        cell.setImage(null);
                    }
                    cell.redraw();
                    this.list = new ArrayList<CellInfo>();
                    this.view.getController().showAllZeroWarningsAround(cellInfo, this.list);
                    cells = this.view.getMinesField().getChildren();
                    int i = 1;
                    while (i < this.list.size()) {
                        cellInfo = this.list.get(i);
                        if (!cellInfo.isFlag()) {
                            cell = (Cell)cells[cellInfo.getLocation().y + cellInfo.getLocation().x * this.view.getController().getPreferences().getColumns()];
                            cell.setType(2);
                            if (cellInfo.getWarning() != 0) {
                                cell.setImage(ResourceManager.INSTANCE.getImage(String.valueOf(Integer.toString(cellInfo.getWarning())) + "mines.gif"));
                            } else if (cellInfo.isQuestion()) {
                                cell.setImage(null);
                            }
                            cell.redraw();
                        }
                        ++i;
                    }
                    this.list = null;
                } else {
                    cell.setImage(ResourceManager.INSTANCE.getImage(String.valueOf(Integer.toString(cellInfo.getWarning())) + "mines.gif"));
                    cell.redraw();
                }
                this.view.getMainButton().setImage(ResourceManager.INSTANCE.getImage("smile.gif"));
                if (this.view.getController().isGameFinished()) {
                    this.view.getController().finishGame();
                }
            }
        }
    }
}

