/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.properties.dialogs;

import com.centreon.studio.client.workbench.properties.MainView;
import com.centreon.studio.client.workbench.properties.MinesweeperMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CustomGameDialog
extends Dialog {
    private MainView view = null;
    private Text rowsValue = null;
    private Text columnsValue = null;
    private Text minesValue = null;
    private Label range = null;
    private Button ok = null;

    public CustomGameDialog(Shell shell, MainView view) {
        super(shell);
        this.view = view;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MinesweeperMessages.getString("CustomGameDialog.custom"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.ok = this.createButton(parent, 0, MinesweeperMessages.getString("CustomGameDialog.ok"), true);
        this.ok.setEnabled(false);
        this.createButton(parent, 1, MinesweeperMessages.getString("CustomGameDialog.cancel"), false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 25;
        gridLayout.marginWidth = 20;
        composite.setLayout((Layout)gridLayout);
        Label rows = new Label(composite, 0);
        rows.setText(MinesweeperMessages.getString("CustomGameDialog.rows"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        rows.setLayoutData((Object)gridData);
        this.rowsValue = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.rowsValue.setLayoutData((Object)gridData);
        this.rowsValue.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CustomGameDialog.this.checkValuesAfterFocus();
            }
        });
        this.rowsValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomGameDialog.this.checkValuesAfterModify();
            }
        });
        this.range = new Label(composite, 0);
        this.range.setText("(4 - 40)");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.range.setLayoutData((Object)gridData);
        Label columns = new Label(composite, 0);
        columns.setText(MinesweeperMessages.getString("CustomGameDialog.columns"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        columns.setLayoutData((Object)gridData);
        this.columnsValue = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.columnsValue.setLayoutData((Object)gridData);
        this.columnsValue.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CustomGameDialog.this.checkValuesAfterFocus();
            }
        });
        this.columnsValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomGameDialog.this.checkValuesAfterModify();
            }
        });
        this.range = new Label(composite, 0);
        this.range.setText("(4 - 40)");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.range.setLayoutData((Object)gridData);
        Label mines = new Label(composite, 0);
        mines.setText(MinesweeperMessages.getString("CustomGameDialog.mines"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        mines.setLayoutData((Object)gridData);
        this.minesValue = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.minesValue.setLayoutData((Object)gridData);
        this.minesValue.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CustomGameDialog.this.checkValuesAfterFocus();
            }
        });
        this.minesValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomGameDialog.this.checkValuesAfterModify();
            }
        });
        this.range = new Label(composite, 0);
        this.range.setText("(1 - ?)");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 48;
        this.range.setLayoutData((Object)gridData);
        return composite;
    }

    protected void okPressed() {
        this.view.updateActionsUI("custom");
        this.view.getController().refresh(Integer.valueOf(this.minesValue.getText()), Integer.valueOf(this.rowsValue.getText()), Integer.valueOf(this.columnsValue.getText()));
        this.view.getController().changeMode("custom");
        this.view.getComposite().layout();
        super.okPressed();
    }

    private void checkValuesAfterFocus() {
        boolean sw = true;
        int rows = 0;
        int columns = 0;
        int mines = 0;
        try {
            rows = Integer.parseInt(this.rowsValue.getText());
            if (rows < 4 || rows > 40) {
                this.rowsValue.setText("");
                rows = 0;
                sw = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            sw = false;
        }
        try {
            columns = Integer.parseInt(this.columnsValue.getText());
            if (columns < 4 || columns > 40) {
                this.columnsValue.setText("");
                columns = 0;
                sw = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            sw = false;
        }
        if (rows * columns == 0) {
            this.range.setText("(1 - ?)");
        } else {
            this.range.setText("(1 - " + rows * columns + ")");
        }
        try {
            mines = Integer.parseInt(this.minesValue.getText());
            if (rows * columns < mines || mines < 1) {
                this.minesValue.setText("");
                sw = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            sw = false;
        }
        if (sw) {
            this.ok.setEnabled(true);
        } else {
            this.ok.setEnabled(false);
        }
    }

    private void checkValuesAfterModify() {
        boolean sw = true;
        try {
            int columns;
            int rows = Integer.parseInt(this.rowsValue.getText());
            if (rows < 4 || rows > 40) {
                rows = 0;
                sw = false;
            }
            if ((columns = Integer.parseInt(this.columnsValue.getText())) < 4 || columns > 40) {
                columns = 0;
                sw = false;
            }
            if (rows * columns == 0) {
                this.range.setText("(1 - ?)");
            } else {
                this.range.setText("(1 - " + rows * columns + ")");
            }
            int mines = Integer.parseInt(this.minesValue.getText());
            if (rows * columns < mines || mines < 1) {
                sw = false;
            }
            if (sw) {
                this.ok.setEnabled(true);
            } else {
                this.ok.setEnabled(false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.ok.setEnabled(false);
        }
    }
}

