/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.properties.dialogs;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.workbench.properties.MainView;
import com.centreon.studio.client.workbench.properties.MinesweeperMessages;
import com.centreon.studio.client.workbench.properties.dialogs.RecordsDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewRecordDialog
extends Dialog
implements ModifyListener {
    private final MainView view;
    private Button ok;
    private Text name;

    public NewRecordDialog(Shell shell, MainView view) {
        super(shell);
        this.view = view;
    }

    public void modifyText(ModifyEvent e) {
        this.ok.setEnabled(!this.name.getText().equals(""));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MinesweeperMessages.getString("NewRecordDialog.label1"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.ok = this.createButton(parent, 0, MinesweeperMessages.getString("NewRecordDialog.ok"), true);
        this.ok.setEnabled(false);
        this.createButton(parent, 1, MinesweeperMessages.getString("NewRecordDialog.cancel"), false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 20;
        gridLayout.marginWidth = 45;
        composite.setLayout((Layout)gridLayout);
        Label aux = new Label(composite, 0x1000000);
        StringBuffer buf = new StringBuffer(MinesweeperMessages.getString("NewRecordDialog.label2"));
        if (this.view.getController().getPreferences().getMode().compareTo("beginner") == 0) {
            buf.append(MinesweeperMessages.getString("NewRecordDialog.beginner"));
        } else if (this.view.getController().getPreferences().getMode().compareTo("intermediate") == 0) {
            buf.append(MinesweeperMessages.getString("NewRecordDialog.intermediate"));
        } else if (this.view.getController().getPreferences().getMode().compareTo("expert") == 0) {
            buf.append(MinesweeperMessages.getString("NewRecordDialog.expert"));
        }
        buf.append(MinesweeperMessages.getString("NewRecordDialog.label3"));
        aux.setText(buf.toString());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        aux.setLayoutData((Object)gridData);
        aux = new Label(composite, 0x1000000);
        aux.setText(MinesweeperMessages.getString("NewRecordDialog.name"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        aux.setLayoutData((Object)gridData);
        this.name = new Text(composite, 0x1000800);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.name.setLayoutData((Object)gridData);
        this.name.addModifyListener((ModifyListener)this);
        return composite;
    }

    protected void okPressed() {
        String mode = this.view.getController().getPreferences().getMode();
        if (mode.equals("expert")) {
            this.view.getController().getRecords().put("nameExpert", this.name.getText());
            this.view.getController().getRecords().put("timeExpert", new Integer(this.view.getTimer().getTime()));
        } else if (mode.equals("intermediate")) {
            this.view.getController().getRecords().put("nameIntermediate", this.name.getText());
            this.view.getController().getRecords().put("timeIntermediate", new Integer(this.view.getTimer().getTime()));
        } else if (mode.equals("beginner")) {
            this.view.getController().getRecords().put("nameBeginner", this.name.getText());
            this.view.getController().getRecords().put("timeBeginner", new Integer(this.view.getTimer().getTime()));
        }
        super.okPressed();
        new RecordsDialog(SWTUtils.getDisplay().getActiveShell(), this.view).open();
    }
}

