/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.authentication;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.authentication.Activator;
import com.centreon.studio.client.authentication.AuthenticationExceptionEventHandler;
import com.centreon.studio.client.authentication.CustomProxySelector;
import com.centreon.studio.client.authentication.messages.AuthenticationMessages;
import com.centreon.studio.client.authentication.model.AuthenticationPropertyDescriptors;
import com.centreon.studio.client.authentication.model.AuthenticationTypes;
import com.centreon.studio.client.authentication.model.object.Proxy;
import com.centreon.studio.client.authentication.model.object.Server;
import com.centreon.studio.client.authentication.model.repository.ProfileRepository;
import com.centreon.studio.client.authentication.model.repository.ProxyRepository;
import com.centreon.studio.client.authentication.model.repository.ServerRepository;
import com.centreon.studio.client.authentication.model.service.ws.AuthenticationWebService;
import com.centreon.studio.client.authentication.model.service.ws.ClientServerCompatibility;
import com.centreon.studio.client.authentication.model.service.ws.DisconnectionWebService;
import com.centreon.studio.client.authentication.ui.AuthenticationSplash;
import com.centreon.studio.client.commons.ContextUtils;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEvent;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.events.popup.PopUpEvent;
import com.centreon.studio.client.events.update.UpdateEvent;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertySerializer;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.utils.BlowFishUtils;
import com.centreon.studio.client.utils.SequenceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.ws.soap.SOAPFaultException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

@Creatable
@Singleton
public final class AuthenticationAddon
extends AuthenticationEventHandler {
    public static final List<String> SERVER_LICENSE_ERROR_MSGS = Arrays.asList("Cannot create local fingerprint", "Error loading license", "Error decrypting public key", "Error verifying license signature");
    private static final String FIRST_START = "first.start";
    private static final Collection<String> SYSTEM_PROPERTIES = new ArrayList<String>();
    private final AuthenticationWebService authenticationService;
    private final DisconnectionWebService disconnectionService;
    private final BrokerEventManager eventManager;
    private final IEclipseContext context;
    private AuthenticationExceptionEventHandler exceptionEventHandler;
    private AuthenticationSplash authenticationSplash;
    private ProfileRepository profileRepository;
    private boolean loggedIn;

    static {
        SYSTEM_PROPERTIES.add("os.arch");
        SYSTEM_PROPERTIES.add("os.name");
        SYSTEM_PROPERTIES.add("os.version");
        SYSTEM_PROPERTIES.add("java.version");
        SYSTEM_PROPERTIES.add("java.vm.name");
    }

    @Inject
    public AuthenticationAddon(IEclipseContext context, BrokerEventManager eventManager, AuthenticationWebService authenticationService, DisconnectionWebService disconnectionService, final ServerRepository serverRepository, final ProxyRepository proxyRepository) {
        new PropertySerializer<Server>(Server.class){

            public Server toObject(String input) {
                return (Server)INodeUtils.findNode((INode)serverRepository, (TypeDescriptor)AuthenticationTypes.SERVER, (Long)Long.parseLong(input), (PropertyValue[])new PropertyValue[0]);
            }

            public String toString(Server input) {
                return input.getId().toString();
            }
        };
        new PropertySerializer<Proxy>(Proxy.class){

            public Proxy toObject(String input) {
                return (Proxy)INodeUtils.findNode((INode)proxyRepository, (TypeDescriptor)AuthenticationTypes.PROXY, (Long)Long.parseLong(input), (PropertyValue[])new PropertyValue[0]);
            }

            public String toString(Proxy input) {
                return input.getId().toString();
            }
        };
        this.context = context;
        this.eventManager = eventManager;
        this.disconnectionService = disconnectionService;
        this.authenticationService = authenticationService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doLogin(INode profile) {
        if (this.loggedIn) {
            return true;
        }
        if (profile == null) {
            this.eventManager.async((StudioEvent)new PopUpEvent().setTexts("Error", "No profile selected").setImagePath("platform:/plugin/com.centreon.studio.client.events/img/error.png"));
            return false;
        }
        try {
            CustomProxySelector.setConfiguration(profile);
            String url = (String)profile.getProperty(AuthenticationPropertyDescriptors.COMPLETE_URL);
            this.authenticationService.init(url, null);
            Version serverVersion = null;
            try {
                serverVersion = this.authenticationService.getServerVersion();
            }
            catch (SOAPFaultException e) {
                String errorMsg = e.getMessage();
                if (SERVER_LICENSE_ERROR_MSGS.stream().anyMatch(errorMsg::contains)) {
                    String message = String.valueOf(AuthenticationMessages.error) + " " + AuthenticationMessages.licenseProblem;
                    AuthenticationEvent event = new AuthenticationEvent(AuthenticationEvent.Type.LOGGED_FAILED).setMessage(message).setColor(StudioColor.RED.toSWT());
                    this.eventManager.async((StudioEvent)event);
                    return false;
                }
                serverVersion = new Version(e.getMessage());
            }
            Version clientVersion = Activator.getContext().getBundle().getVersion();
            ClientServerCompatibility compatibility = ClientServerCompatibility.compute(clientVersion, serverVersion);
            if (ClientServerCompatibility.SAME_VERSION == compatibility) {
                ACLUser user = this.authenticationService.authenticate(url, this.lastEvent.getLogin(), this.lastEvent.getPwd());
                if (user == null) return false;
                this.loggedIn = true;
                this.eventManager.async((StudioEvent)new AuthenticationEvent(AuthenticationEvent.Type.LOGGED_IN).setProfile(profile).setId(user.getId()));
                SWTUtils.getDisplay().syncExec(() -> ContextUtils.getTopContext((IEclipseContext)this.context).set(ACLUser.class, (Object)user));
                this.exceptionEventHandler.setUrl(url);
                return true;
            }
            if (ClientServerCompatibility.CLIENT_MORE_RECENT == compatibility) {
                String message = String.valueOf(AuthenticationMessages.error) + " " + AuthenticationMessages.updateServerNeeded;
                AuthenticationEvent event = new AuthenticationEvent(AuthenticationEvent.Type.LOGGED_FAILED).setMessage(message).setColor(StudioColor.RED.toSWT());
                this.eventManager.async((StudioEvent)event);
                return false;
            }
            this.eventManager.async((StudioEvent)new UpdateEvent(UpdateEvent.UpdateEventType.REQUEST_UPDATE, serverVersion, true));
            return false;
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            this.eventManager.async((StudioEvent)new AuthenticationEvent(AuthenticationEvent.Type.LOGGED_FAILED).setMessage(e.getMessage()));
            CustomProxySelector.disabledLast();
        }
        return false;
    }

    protected void doLogout() {
        if (!this.loggedIn) {
            return;
        }
        this.disconnectionService.disconnect();
        CustomProxySelector.disabledLast();
        this.loggedIn = false;
        this.eventManager.async((StudioEvent)new AuthenticationEvent(AuthenticationEvent.Type.LOGGED_OUT));
    }

    protected void doQuit() {
        Job doQuitJob = Job.create((String)"Do Quit job ... ", monitor -> this.disconnectionService.disconnect());
        doQuitJob.schedule();
        try {
            Thread.sleep(3000L);
            doQuitJob.cancel();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void forcedLogout() {
        if (!this.loggedIn) {
            return;
        }
        CustomProxySelector.disabledLast();
        this.loggedIn = false;
        this.eventManager.async((StudioEvent)new AuthenticationEvent(AuthenticationEvent.Type.LOGGED_OUT));
    }

    @PostConstruct
    public void postConstruct(ProfileRepository profileRepository, AuthenticationSplash authenticationSplash) {
        this.profileRepository = profileRepository;
        this.authenticationSplash = authenticationSplash;
        this.eventManager.subscribe("studio/authentication", true, (StudioEventHandler)this);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Authentication addon loaded", (Object[])new Object[0]));
        this.eventManager.async((StudioEvent)ExceptionEvent.addPattern((String)"407: Proxy Authentication Required", (String)AuthenticationMessages.testProfileProxyNeedAuth));
        this.eventManager.async((StudioEvent)ExceptionEvent.addPattern((String)"Connection refused: connect", (String)AuthenticationMessages.testProfileFailConnectionRefused));
        this.eventManager.async((StudioEvent)ExceptionEvent.addPattern((String)AuthenticationMessages.testProfileFailAuthenticate, (String)AuthenticationMessages.testProfileFailAuthenticate));
        this.eventManager.async((StudioEvent)ExceptionEvent.addPattern((String)AuthenticationMessages.testProfileFailResolveProxy, (String)AuthenticationMessages.testProfileFailResolveProxy));
        this.eventManager.async((StudioEvent)ExceptionEvent.addPattern((String)AuthenticationMessages.testProfileFailConnectProxy, (String)AuthenticationMessages.testProfileFailConnectProxy));
        this.eventManager.async((StudioEvent)ExceptionEvent.addPattern((String)AuthenticationMessages.testProfileFailConnectServer, (String)AuthenticationMessages.testProfileFailConnectServer));
        this.exceptionEventHandler = new AuthenticationExceptionEventHandler(this.eventManager);
        this.eventManager.subscribe("studio/exceptions", true, (StudioEventHandler)this.exceptionEventHandler);
        SWTUtils.getDisplay().asyncExec(() -> this.authenticationSplash.open());
        IEclipsePreferences eclipsePreferences = InstanceScope.INSTANCE.getNode(Activator.getContext().getBundle().getSymbolicName());
        if (eclipsePreferences.getBoolean(FIRST_START, Boolean.TRUE.booleanValue())) {
            ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(5);
            properties.add(new PropertyValue(PropertyDescriptors.ADDRESS, (Object)"demo.centreon.com"));
            properties.add(new PropertyValue(AuthenticationPropertyDescriptors.LOGIN, (Object)"map"));
            properties.add(new PropertyValue(AuthenticationPropertyDescriptors.PWD, (Object)BlowFishUtils.encrypt((String)"centreon")));
            properties.add(new PropertyValue(AuthenticationPropertyDescriptors.USE_SSL, (Object)Boolean.TRUE));
            properties.add(new PropertyValue(AuthenticationPropertyDescriptors.PORT, (Object)443));
            properties.add(new PropertyValue(AuthenticationPropertyDescriptors.URL, (Object)"/map/"));
            INode demoProfile = NodeFactories.INSTANCE.create(AuthenticationTypes.PROFILE, SequenceUtils.next(), properties, (IRepository)profileRepository);
            INodeRelation demoProfileRelation = NodeRelationFactories.INSTANCE.create((INode)profileRepository, demoProfile);
            profileRepository.addRelation(demoProfileRelation);
            profileRepository.setSelection((Object)this, Arrays.asList(demoProfileRelation));
            try {
                eclipsePreferences.putBoolean(FIRST_START, Boolean.FALSE.booleanValue());
                eclipsePreferences.flush();
            }
            catch (BackingStoreException e) {
                this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            }
        }
    }

    @PreDestroy
    public void preDestroy() {
        this.eventManager.async((StudioEvent)ExceptionEvent.removePattern((String)"407: Proxy Authentication Required"));
        this.eventManager.async((StudioEvent)ExceptionEvent.removePattern((String)AuthenticationMessages.testProfileFailAuthenticate));
        this.eventManager.async((StudioEvent)ExceptionEvent.removePattern((String)AuthenticationMessages.testProfileFailResolveProxy));
        this.eventManager.async((StudioEvent)ExceptionEvent.removePattern((String)AuthenticationMessages.testProfileFailConnectProxy));
        this.eventManager.async((StudioEvent)ExceptionEvent.removePattern((String)AuthenticationMessages.testProfileFailConnectServer));
        this.eventManager.unsubscribe((StudioEventHandler)this.exceptionEventHandler);
        this.eventManager.unsubscribe((StudioEventHandler)this);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Authentication addon destroyed", (Object[])new Object[0]));
    }

    protected void requestLogin() {
        if (this.loggedIn) {
            return;
        }
        INodeRelation selection = this.profileRepository.getSelection();
        if (selection != null) {
            INode profile = selection.getTarget();
            profile.addPropertyValue(AuthenticationPropertyDescriptors.LAST_CONNEXION, (Object)System.currentTimeMillis());
            this.eventManager.async((StudioEvent)new AuthenticationEvent(AuthenticationEvent.Type.DO_LOGIN).setProfile(profile));
        }
    }
}

