/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.authentication;

import com.centreon.studio.client.authentication.messages.AuthenticationMessages;
import com.centreon.studio.client.authentication.model.AuthenticationPropertyDescriptors;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.utils.BlowFishUtils;
import com.centreon.studio.client.utils.StringUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class CustomProxySelector
extends ProxySelector {
    private static CustomProxySelector current;
    private final List<Proxy> proxys;
    private final INode profile;
    private ProxySelector last;
    private InetSocketAddress socketAdress;

    public static void disabledLast() {
        if (current != null) {
            current.deactivate();
        }
        current = null;
    }

    public static void setConfiguration(INode profile) {
        CustomProxySelector.disabledLast();
        current = new CustomProxySelector(profile);
        current.activate();
    }

    private CustomProxySelector(INode profile) {
        this.profile = profile;
        this.proxys = new ArrayList<Proxy>(1);
        String proxyAddress = (String)profile.getProperty(AuthenticationPropertyDescriptors.PROXY_ADDRESS);
        if (!StringUtils.isNullEmptyOrBlank((String)proxyAddress)) {
            try {
                InetAddress address = InetAddress.getByName(proxyAddress);
                Integer port = (Integer)profile.getProperty(AuthenticationPropertyDescriptors.PROXY_PORT);
                this.socketAdress = new InetSocketAddress(address, (int)port);
                this.proxys.add(new Proxy(Proxy.Type.HTTP, this.socketAdress));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (this.socketAdress != null && this.socketAdress.equals(sa)) {
            throw new RuntimeException(AuthenticationMessages.testProfileFailConnectProxy, ioe);
        }
        throw new RuntimeException(ioe);
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (!StringUtils.isNullEmptyOrBlank((String)uri.getHost()) && (uri.getHost().startsWith((String)this.profile.getProperty(PropertyDescriptors.ADDRESS)) ? !StringUtils.isNullEmptyOrBlank((String)((String)this.profile.getProperty(AuthenticationPropertyDescriptors.PROXY_ADDRESS))) && (Boolean)this.profile.getProperty(AuthenticationPropertyDescriptors.USE_PROXY_SERVER) != false : !StringUtils.isNullEmptyOrBlank((String)((String)this.profile.getProperty(AuthenticationPropertyDescriptors.PROXY_ADDRESS))) && (Boolean)this.profile.getProperty(AuthenticationPropertyDescriptors.USE_PROXY_INTERNET) != false)) {
            return this.proxys;
        }
        return this.last.select(uri);
    }

    private void activate() {
        this.last = ProxySelector.getDefault();
        ProxySelector.setDefault(this);
        if (!StringUtils.isNullEmptyOrBlank((String)((String)this.profile.getProperty(AuthenticationPropertyDescriptors.PROXY_ADDRESS))) && !StringUtils.isNullEmptyOrBlank((String)((String)this.profile.getProperty(AuthenticationPropertyDescriptors.PROXY_LOGIN)))) {
            System.setProperty("http.proxyUser", (String)this.profile.getProperty(AuthenticationPropertyDescriptors.PROXY_LOGIN));
            System.setProperty("https.proxyUser", (String)this.profile.getProperty(AuthenticationPropertyDescriptors.PROXY_LOGIN));
            System.setProperty("http.proxyPassword", BlowFishUtils.decrypt((String)((String)this.profile.getProperty(AuthenticationPropertyDescriptors.PROXY_PASSWORD))));
            System.setProperty("https.proxyPassword", BlowFishUtils.decrypt((String)((String)this.profile.getProperty(AuthenticationPropertyDescriptors.PROXY_PASSWORD))));
        }
    }

    private void deactivate() {
        ProxySelector.setDefault(this.last);
        if (!StringUtils.isNullEmptyOrBlank((String)((String)this.profile.getProperty(AuthenticationPropertyDescriptors.PROXY_ADDRESS))) && !StringUtils.isNullEmptyOrBlank((String)((String)this.profile.getProperty(AuthenticationPropertyDescriptors.PROXY_LOGIN)))) {
            System.clearProperty("http.proxyUser");
            System.clearProperty("http.proxyPassword");
        }
    }
}

