/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.authentication.handlers;

import com.centreon.studio.client.authentication.messages.AuthenticationMessages;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEvent;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public final class AuthenticationHandler
extends AuthenticationEventHandler {
    private static final String MENU_ITEM_ID = "com.centreon.studio.client.authentication.handledmenuitems.disconnect";
    private final MApplication application;
    private boolean isLoggedId;

    @Inject
    public AuthenticationHandler(BrokerEventManager eventManager, MApplication application) {
        this.application = application;
        eventManager.subscribe("studio/authentication", false, (StudioEventHandler)this);
    }

    @Execute
    public void execute(BrokerEventManager eventManager) {
        if (this.isLoggedId) {
            if (MessageDialog.openConfirm((Shell)SWTUtils.getDisplay().getActiveShell(), (String)"Confirmation", (String)AuthenticationMessages.logoutConfirmationMessage)) {
                eventManager.async((StudioEvent)new AuthenticationEvent(AuthenticationEvent.Type.REQUEST_LOGOUT));
            }
        } else {
            eventManager.async((StudioEvent)new AuthenticationEvent(AuthenticationEvent.Type.REQUEST_LOGIN));
        }
    }

    @PreDestroy
    public void preDestroy(BrokerEventManager eventManager) {
        eventManager.unsubscribe((StudioEventHandler)this);
    }

    protected void loggedIn() {
        this.update(AuthenticationMessages.keywordDisconnect);
        this.isLoggedId = true;
    }

    protected void loggedOut() {
        this.update(AuthenticationMessages.keywordConnect);
        this.isLoggedId = false;
    }

    private void update(String label) {
        for (MWindow window : this.application.getChildren()) {
            for (MMenuElement menuElement : window.getMainMenu().getChildren()) {
                if (!(menuElement instanceof MMenu)) continue;
                MMenu menu = (MMenu)menuElement;
                for (MMenuElement item : menu.getChildren()) {
                    if (!item.getElementId().equals(MENU_ITEM_ID)) continue;
                    item.setLabel(label);
                    return;
                }
            }
        }
    }
}

