/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.authentication.model;

import com.centreon.studio.client.authentication.messages.AuthenticationMessages;
import com.centreon.studio.client.authentication.model.AuthenticationTypes;
import com.centreon.studio.client.authentication.model.service.ws.AuthenticationWebService;
import com.centreon.studio.client.authentication.model.service.ws.DisconnectionWebService;
import com.centreon.studio.client.authentication.ui.wizard.ProfileWizardPage;
import com.centreon.studio.client.commons.Scheduler;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.dialogs.CustomWizard;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardDialog;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.model.ui.dialogs.IWizardFactory;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public enum AuthenticationWizardFactory implements IWizardFactory
{
    INSTANCE;


    public CustomWizardDialog createDialog(INodeRelation input, IEclipseContext context) {
        Scheduler scheduler = (Scheduler)ContextInjectionFactory.make(Scheduler.class, (IEclipseContext)context);
        BrokerEventManager eventManager = (BrokerEventManager)ContextInjectionFactory.make(BrokerEventManager.class, (IEclipseContext)context);
        DisconnectionWebService dws = (DisconnectionWebService)((Object)ContextInjectionFactory.make(DisconnectionWebService.class, (IEclipseContext)context));
        AuthenticationWebService aws = (AuthenticationWebService)((Object)ContextInjectionFactory.make(AuthenticationWebService.class, (IEclipseContext)context));
        if (input.getTarget().getType() != AuthenticationTypes.PROFILE) {
            return null;
        }
        CustomWizard wizard = new CustomWizard(AuthenticationMessages.createProfile);
        wizard.registerPage((CustomWizardPage)new ProfileWizardPage(scheduler, aws, dws, eventManager));
        CustomWizardDialog dialog = new CustomWizardDialog(wizard);
        dialog.setInput(Arrays.asList(input));
        return dialog;
    }

    public Collection<TypeDescriptor> getSupportedTypes() {
        return Arrays.asList(AuthenticationTypes.PROFILE);
    }
}

