/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.authentication.model.repository;

import com.centreon.studio.client.authentication.ProfileMigration;
import com.centreon.studio.client.authentication.messages.AuthenticationMessages;
import com.centreon.studio.client.authentication.model.repository.ProxyRepository;
import com.centreon.studio.client.authentication.model.repository.ServerRepository;
import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.XMLRepository;
import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public final class ProfileRepository
extends XMLRepository {
    private static final String FILE_NAME = "ProfileRepository.xml";
    private static final File FILE = new File(Configuration.APPLI_HOME, "ProfileRepository.xml");
    private final ProxyRepository proxyRepository;
    private final ServerRepository serverRepository;

    @Inject
    public ProfileRepository(ProxyRepository proxyRepository, ServerRepository serverRepository) {
        super(AuthenticationMessages.labelProfiles, FILE, null);
        this.proxyRepository = proxyRepository;
        this.serverRepository = serverRepository;
    }

    public void load() throws Exception {
        this.serverRepository.load();
        this.proxyRepository.load();
        super.load();
        ProfileMigration.migrateOldProfiles((IRepository)this);
    }

    @PostConstruct
    public void postConstruct() {
        try {
            this.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PreDestroy
    public void preDestroy() {
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() throws IOException {
        this.serverRepository.save();
        this.proxyRepository.save();
        super.save();
    }
}

