/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importexport;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.commons.jface.validation.field.impl.FileField;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.client.importexport.messages.ImportExportMessages;
import java.io.File;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public abstract class AImportExportWizardPage
extends CustomWizardPage {
    private static final String[] EXTENSION_LABELS = new String[]{"XML Files"};
    private static final String[] EXTENSIONS = new String[]{"*.xml"};
    protected final IRepository input;
    protected final IEclipseContext context;
    protected final BrokerEventManager eventManager;
    protected final String prefixName;
    protected FileField fileField;
    protected Button prefYes;
    protected Button aclYes;
    protected Button mediaGate;
    protected Button mediaAll;
    protected Button templateGate;
    protected Button templateAll;
    private final int style;

    private static final Group createGroup(Composite parent, String message) {
        return SWTUtils.createGroup((Composite)parent, (String)message, (int)5, (int)1, (boolean)false, (GridData)new GridData(4, 0x1000000, true, true, 2, 1));
    }

    protected AImportExportWizardPage(String pageName, String prefixName, IRepository input, IEclipseContext context, BrokerEventManager eventManager, int style) {
        super(pageName);
        this.style = style;
        this.input = input;
        this.context = context;
        this.prefixName = prefixName;
        this.eventManager = eventManager;
        this.setDescription(String.valueOf(ImportExportMessages.description) + prefixName.toLowerCase());
    }

    public Composite customCreateControl(Composite parent) {
        Composite composite = SWTUtils.createComposite((Composite)parent, (int)2, (boolean)false, (int)5, (int)5, (GridData)SWTUtils.createGridData((int)1, (int)0x1000000, (int)200, (int)500));
        StringBuilder sb = new StringBuilder("");
        if (this.input.getSelections() != null && !this.input.getSelections().isEmpty()) {
            int i = 0;
            for (INodeRelation relation : this.input.getSelections()) {
                sb.append(relation.getTarget().getLabel());
                if (i < this.input.getSelections().size() - 1) {
                    sb.append("-");
                }
                ++i;
            }
            sb.append(".xml");
        }
        String fileName = StringUtils.alphaNumeric((String)sb.toString());
        String title = String.valueOf(this.prefixName) + " " + ImportExportMessages.file;
        String path = String.valueOf(Configuration.APPLI_HOME.getAbsolutePath()) + File.separator + fileName;
        this.fileField = new FileField(composite, title, path, null, null, this.style, EXTENSIONS, EXTENSION_LABELS);
        Group prefGroup = AImportExportWizardPage.createGroup(composite, String.valueOf(this.prefixName) + " " + ImportExportMessages.preference);
        this.prefYes = SWTUtils.createRadioButton((Composite)prefGroup, (String)CommonsMessages.keywordYes);
        SWTUtils.createRadioButton((Composite)prefGroup, (String)CommonsMessages.keywordNo);
        this.prefYes.setSelection(true);
        Group aclGroup = AImportExportWizardPage.createGroup(composite, String.valueOf(this.prefixName) + " " + ImportExportMessages.acl);
        this.aclYes = SWTUtils.createRadioButton((Composite)aclGroup, (String)CommonsMessages.keywordYes);
        SWTUtils.createRadioButton((Composite)aclGroup, (String)CommonsMessages.keywordNo);
        this.aclYes.setSelection(true);
        Group mediaGroup = AImportExportWizardPage.createGroup(composite, String.valueOf(this.prefixName) + " " + ImportExportMessages.media);
        this.mediaGate = SWTUtils.createRadioButton((Composite)mediaGroup, (String)ImportExportMessages.gateMedia);
        this.mediaAll = SWTUtils.createRadioButton((Composite)mediaGroup, (String)ImportExportMessages.allMedia);
        SWTUtils.createRadioButton((Composite)mediaGroup, (String)CommonsMessages.keywordNo);
        this.mediaGate.setSelection(true);
        Group templateGroup = AImportExportWizardPage.createGroup(composite, String.valueOf(this.prefixName) + " " + ImportExportMessages.linkTemplate);
        this.templateGate = SWTUtils.createRadioButton((Composite)templateGroup, (String)ImportExportMessages.gateLinkTemplate);
        this.templateAll = SWTUtils.createRadioButton((Composite)templateGroup, (String)ImportExportMessages.allLinkTemplate);
        SWTUtils.createRadioButton((Composite)templateGroup, (String)CommonsMessages.keywordNo);
        this.templateGate.setSelection(true);
        return composite;
    }

    public Point getPageSize() {
        return new Point(300, 300);
    }

    public boolean isPageComplete() {
        return !StringUtils.isNullEmptyOrBlank((String)this.fileField.getValue());
    }
}

