/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importexport;

import com.centreon.studio.client.acl.ACLRepository;
import com.centreon.studio.client.acl.ACLTypes;
import com.centreon.studio.client.commons.jface.dialogs.MessageDialogUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.popup.PopUpEvent;
import com.centreon.studio.client.media.model.DataWebService;
import com.centreon.studio.client.media.model.MediaPropertyDescriptors;
import com.centreon.studio.client.media.model.MediaRepository;
import com.centreon.studio.client.media.model.MediaTypes;
import com.centreon.studio.client.media.model.MediaWebService;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.XMLRepository;
import com.centreon.studio.client.preference.model.PreferenceRepository;
import com.centreon.studio.client.preference.model.PreferenceTypes;
import com.centreon.studio.client.utils.SequenceUtils;
import com.centreon.studio.client.utils.StreamUtils;
import com.centreon.studio.map.client.elements.messages.ElementMessages;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.model.repository.ElementRepository;
import com.centreon.studio.map.client.elements.templates.TemplateRepository;
import com.centreon.studio.map.client.gates.model.GatePropertyDescriptors;
import com.centreon.studio.map.client.importexport.AImportExportWizardPage;
import com.centreon.studio.map.client.importexport.messages.ImportExportMessages;
import com.centreon.studio.map.client.status.model.StatusTypes;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.ws.Holder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class GateExportWizardPage
extends AImportExportWizardPage {
    private static Set<INode> addBytePropertyToMedias(INode inode, MediaWebService service, DataWebService dataService, BrokerEventManager eventManager) {
        HashSet<INode> set = new HashSet<INode>(1);
        set.add(inode);
        return GateExportWizardPage.addBytePropertyToMedias(set, service, dataService, eventManager);
    }

    private static Set<INode> addBytePropertyToMedias(Set<INode> medias, MediaWebService service, DataWebService dataService, BrokerEventManager eventManager) {
        HashSet<INode> exportedMedias = new HashSet<INode>();
        for (INode media : medias) {
            if (media == null || ((Boolean)media.getProperty(PropertyDescriptors.READ_ONLY)).booleanValue()) continue;
            if (media.getType() != MediaTypes.MEDIA_GROUP) {
                File file = dataService.download((String)media.getProperty(MediaPropertyDescriptors.MD5));
                try {
                    Object object = null;
                    Object var9_11 = null;
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try {
                            try (FileInputStream fis = new FileInputStream(file);){
                                StreamUtils.copy((InputStream)fis, (OutputStream)baos);
                                media.addPropertyValue(MediaPropertyDescriptors.MEDIA_CONTENT, (Object)baos.toByteArray());
                                exportedMedias.add(media);
                            }
                            if (baos == null) continue;
                        }
                        catch (Throwable throwable) {
                            if (object == null) {
                                object = throwable;
                            } else if (object != throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            if (baos != null) {
                                baos.close();
                            }
                            throw object;
                        }
                        baos.close();
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (IOException e) {
                    eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
                }
                continue;
            }
            for (INodeRelation relation : media.getRelations(new TypeDescriptor[0])) {
                exportedMedias.addAll(GateExportWizardPage.addBytePropertyToMedias(relation.getTarget(), service, dataService, eventManager));
            }
        }
        return exportedMedias;
    }

    private static void exportACLs(IRepository repository, IRepository aclRepository, INode scope) {
        for (INodeRelation aclGroupRelation : aclRepository.getRelations(new TypeDescriptor[]{ACLTypes.ACL_GROUP})) {
            INodeRelation objectACLRule = INodeUtils.findRelationForTarget((INode)aclGroupRelation.getTarget(), (TypeDescriptor)scope.getType(), (Long)scope.getId(), (PropertyValue[])new PropertyValue[0]);
            if (objectACLRule == null) continue;
            INode copiedAclRule = INodeUtils.copy((INode)objectACLRule.getTarget(), (boolean)true, (boolean)false, null, (PropertyValue[])new PropertyValue[0]);
            INode exportedACLGroup = INodeUtils.findNode((INode)repository, (TypeDescriptor)aclGroupRelation.getTarget().getType(), (Long)aclGroupRelation.getTarget().getId(), (PropertyValue[])new PropertyValue[0]);
            if (exportedACLGroup == null) {
                exportedACLGroup = INodeUtils.copy((INode)aclGroupRelation.getTarget(), (boolean)true, (boolean)false, (IRepository)repository, (PropertyValue[])new PropertyValue[0]);
                repository.addRelation(NodeRelationFactories.INSTANCE.create(exportedACLGroup.getType(), exportedACLGroup.getId(), (INode)repository, exportedACLGroup));
            }
            exportedACLGroup.addRelation(NodeRelationFactories.INSTANCE.create(objectACLRule.getType(), copiedAclRule.getId(), exportedACLGroup, copiedAclRule));
        }
    }

    private static void exportElements(INode node, IRepository repository, IProgressMonitor monitor) {
        monitor.subTask("Element count");
        Long targetId = (Long)node.getProperty(GatePropertyDescriptors.TARGET_ID);
        for (INodeRelation relation : repository.getRelations(new TypeDescriptor[]{ElementTypes.RELATION_HIERARCHY})) {
            if (!relation.getTarget().getId().equals(targetId)) continue;
            monitor.setTaskName(relation.getTarget().getLabel());
            INode copiedElement = INodeUtils.copy((INode)relation.getTarget(), (boolean)true, (boolean)true, (IRepository)node.getRepository(), (PropertyValue[])new PropertyValue[]{new PropertyValue(ElementPropertyDescriptors.SYNCHRONIZED, (Object)Boolean.FALSE)});
            INodeRelation copiedRelation = NodeRelationFactories.INSTANCE.create(relation.getType(), relation.getId(), node, copiedElement, relation.getPropertyValues());
            node.addRelation(copiedRelation);
            monitor.internalWorked(1.0);
            break;
        }
    }

    private static INode exportGate(IRepository repository, INode gate) {
        INode copiedGate = INodeUtils.copy((INode)gate, (boolean)true, (boolean)true, (IRepository)repository, (PropertyValue[])new PropertyValue[0]);
        repository.addRelation(NodeRelationFactories.INSTANCE.create(gate.getType(), copiedGate.getId(), (INode)repository, copiedGate));
        return copiedGate;
    }

    private static Set<INode> exportMediaFromReposiroty(IRepository repository, Set<Long> ids) {
        HashSet<INode> inodes = new HashSet<INode>();
        for (INodeRelation relation : repository.getRelations(new TypeDescriptor[0])) {
            inodes.add(GateExportWizardPage.exportMedias(relation.getTarget(), ids));
        }
        return inodes;
    }

    private static INode exportMedias(INode node, Set<Long> ids) {
        INode root = null;
        if (node.getType() == MediaTypes.MEDIA_GROUP) {
            for (INodeRelation relation : node.getRelations(new TypeDescriptor[0])) {
                INode child = GateExportWizardPage.exportMedias(relation.getTarget(), ids);
                if (child == null) continue;
                if (root == null) {
                    root = INodeUtils.copy((INode)node, (boolean)true, (boolean)false, (IRepository)node.getRepository(), (PropertyValue[])new PropertyValue[0]);
                }
                root.addRelation(NodeRelationFactories.INSTANCE.create(child.getType(), SequenceUtils.next(), root, child));
            }
        } else if (ids == null || ids.contains(node.getId())) {
            root = INodeUtils.copy((INode)node, (boolean)true, (boolean)false, (IRepository)node.getRepository(), (PropertyValue[])new PropertyValue[0]);
        }
        return root;
    }

    private static void exportPreferences(INode node, IRepository repository) {
        INode prefNode = INodeUtils.findNode((INode)repository, (TypeDescriptor)node.getType(), (Long)node.getId(), (PropertyValue[])new PropertyValue[0]);
        if (prefNode != null) {
            INode copiedPrefNode = INodeUtils.copy((INode)prefNode, (boolean)true, (boolean)true, null, (PropertyValue[])new PropertyValue[0]);
            node.addRelation(NodeRelationFactories.INSTANCE.create(PreferenceTypes.PREFERENCE, copiedPrefNode.getId(), node, copiedPrefNode));
        }
    }

    private static void exportTemplates(INode node, IRepository templateRepository) {
        HashSet<Long> templateIds = new HashSet<Long>();
        GateExportWizardPage.findTemplates(node, templateIds);
        HashMap result = new HashMap();
        INodeUtils.findNodes((INode)templateRepository, templateIds, result);
        for (INode template : result.values()) {
            node.addRelation(NodeRelationFactories.INSTANCE.create(null, template.getId(), node, template));
        }
    }

    private static void findPropertyIds(INode element, Set<Long> mediaIds, PropertyDescriptor<Long> property) {
        Long mediaId = (Long)element.getProperty(property);
        if (mediaId != null) {
            mediaIds.add(mediaId);
        }
        for (INodeRelation relation : element.getRelations(new TypeDescriptor[0])) {
            GateExportWizardPage.findPropertyIds(relation.getTarget(), mediaIds, property);
        }
    }

    private static void findTemplates(INode node, Set<Long> templateIds) {
        Long templateId = (Long)node.getProperty(ElementPropertyDescriptors.TEMPLATE_ID);
        if (!templateId.equals(ElementPropertyDescriptors.TEMPLATE_ID.defaulValue)) {
            templateIds.add(templateId);
        }
        for (INodeRelation relation : node.getRelations(new TypeDescriptor[0])) {
            GateExportWizardPage.findTemplates(relation.getTarget(), templateIds);
        }
    }

    public GateExportWizardPage(String pageName, IRepository input, IEclipseContext context, BrokerEventManager eventManager) {
        super(GateExportWizardPage.class.getSimpleName(), ImportExportMessages.exportt, input, context, eventManager, 8192);
        this.setTitle(pageName);
    }

    protected boolean performFinish() {
        String filePath = this.fileField.getValue();
        File file = new File(filePath);
        Holder exportSuccessful = new Holder((Object)Boolean.FALSE);
        boolean exportGateTemplate = this.templateGate.getSelection();
        boolean exportAllTemplate = this.templateAll.getSelection();
        boolean exportPreference = this.prefYes.getSelection();
        boolean exportGateMedia = this.mediaGate.getSelection();
        boolean exportAllMedia = this.mediaAll.getSelection();
        boolean exportAcl = this.aclYes.getSelection();
        try {
            IRunnableWithProgress exportTask = monitor -> {
                Set<INode> exportedMedias;
                int totalNumberOfActions = 2 + (exportPreference ? 1 : 0) + (exportAcl ? 1 : 0) + (exportGateMedia || exportAllMedia ? 1 : 0) + (exportGateTemplate || exportAllTemplate ? 1 : 0);
                monitor.beginTask(String.valueOf(this.prefixName) + " " + ImportExportMessages.gate, totalNumberOfActions);
                IRepository aclRepository = (IRepository)ContextInjectionFactory.make(ACLRepository.class, (IEclipseContext)this.context);
                IRepository prefRepository = (IRepository)ContextInjectionFactory.make(PreferenceRepository.class, (IEclipseContext)this.context);
                IRepository elementRepository = (IRepository)ContextInjectionFactory.make(ElementRepository.class, (IEclipseContext)this.context);
                MediaRepository mediaRepository = (MediaRepository)ContextInjectionFactory.make(MediaRepository.class, (IEclipseContext)this.context);
                MediaWebService mediaService = (MediaWebService)ContextInjectionFactory.make(MediaWebService.class, (IEclipseContext)this.context);
                DataWebService dataService = (DataWebService)ContextInjectionFactory.make(DataWebService.class, (IEclipseContext)this.context);
                TemplateRepository templateRepository = (TemplateRepository)ContextInjectionFactory.make(TemplateRepository.class, (IEclipseContext)this.context);
                HashSet<INode> mediaNodes = new HashSet<INode>();
                XMLRepository repository = new XMLRepository("Export view", file, true, true, this.eventManager, new TypeDescriptor[]{StatusTypes.DOWNTIME, StatusTypes.METRIC});
                for (INodeRelation selected : this.input.getSelections()) {
                    INode selectedTarget = selected.getTarget();
                    String taskPrefix = String.valueOf(this.prefixName) + " " + ImportExportMessages.gate + " " + selectedTarget.getLabel() + " : ";
                    monitor.setTaskName(String.valueOf(this.prefixName) + " " + ImportExportMessages.gate + " " + selectedTarget.getLabel());
                    INode exportedGate = GateExportWizardPage.exportGate((IRepository)repository, selectedTarget);
                    monitor.internalWorked(1.0);
                    if (exportAcl) {
                        monitor.setTaskName(String.valueOf(taskPrefix) + ImportExportMessages.acl);
                        GateExportWizardPage.exportACLs((IRepository)repository, aclRepository, exportedGate);
                        monitor.internalWorked(1.0);
                    }
                    if (exportPreference) {
                        monitor.setTaskName(String.valueOf(taskPrefix) + ImportExportMessages.preference);
                        GateExportWizardPage.exportPreferences(exportedGate, prefRepository);
                        monitor.internalWorked(1.0);
                    }
                    monitor.setTaskName(String.valueOf(taskPrefix) + ElementMessages.labelElements);
                    GateExportWizardPage.exportElements(exportedGate, elementRepository, monitor);
                    monitor.internalWorked(1.0);
                }
                if (exportGateMedia || exportAllMedia) {
                    monitor.setTaskName(String.valueOf(ImportExportMessages.exportt) + " " + ImportExportMessages.media);
                    if (exportGateMedia) {
                        HashSet<Long> mediaIds = new HashSet<Long>();
                        GateExportWizardPage.findPropertyIds((INode)repository, mediaIds, (PropertyDescriptor<Long>)MediaPropertyDescriptors.MEDIA_ID);
                        mediaNodes.addAll(GateExportWizardPage.exportMediaFromReposiroty((IRepository)mediaRepository, mediaIds));
                    } else {
                        for (INodeRelation relation : mediaRepository.getRelations(new TypeDescriptor[0])) {
                            mediaNodes.add(relation.getTarget());
                        }
                    }
                    monitor.internalWorked(1.0);
                }
                if (!(exportedMedias = GateExportWizardPage.addBytePropertyToMedias(mediaNodes, mediaService, dataService, this.eventManager)).isEmpty()) {
                    for (INode media : mediaNodes) {
                        if (media == null) continue;
                        repository.addRelation(NodeRelationFactories.INSTANCE.create(media.getType(), media.getId(), (INode)repository, media));
                    }
                }
                if (exportGateTemplate || exportAllTemplate) {
                    monitor.setTaskName(String.valueOf(ImportExportMessages.exportt) + " " + ImportExportMessages.linkTemplate);
                    if (exportGateTemplate) {
                        GateExportWizardPage.exportTemplates((INode)repository, (IRepository)templateRepository);
                    } else {
                        for (INodeRelation relation : templateRepository.getRelations(new TypeDescriptor[0])) {
                            INode target = relation.getTarget();
                            repository.addRelation(NodeRelationFactories.INSTANCE.create(target.getType(), target.getId(), (INode)repository, target));
                        }
                    }
                    monitor.internalWorked(1.0);
                }
                monitor.setTaskName("Save file");
                try {
                    repository.save();
                    monitor.internalWorked(1.0);
                }
                catch (IOException e) {
                    this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
                    MessageDialogUtils.openError((String)e.getMessage());
                    return;
                }
                for (INode media : exportedMedias) {
                    media.addPropertyValue(MediaPropertyDescriptors.MEDIA_CONTENT, null);
                }
                monitor.done();
                holder.value = Boolean.TRUE;
                this.eventManager.async((StudioEvent)new PopUpEvent().setTexts(ImportExportMessages.exportt, "Export done").setImagePath("platform:/plugin/com.centreon.studio.client.events/img/ok.png"));
            };
            this.getContainer().run(true, false, exportTask);
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
        return (Boolean)exportSuccessful.value;
    }
}

