/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.importexport;

import com.centreon.studio.client.acl.ACLRepository;
import com.centreon.studio.client.acl.ACLTypes;
import com.centreon.studio.client.acl.ACLWebService;
import com.centreon.studio.client.commons.jface.dialogs.MessageDialogUtils;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.exception.ExceptionEventHandler;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.events.popup.PopUpEvent;
import com.centreon.studio.client.media.model.MediaPropertyDescriptors;
import com.centreon.studio.client.media.model.MediaRepository;
import com.centreon.studio.client.media.model.MediaTypes;
import com.centreon.studio.client.media.model.MediaUtils;
import com.centreon.studio.client.media.model.MediaWebService;
import com.centreon.studio.client.model.IWebService;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.repository.XMLRepository;
import com.centreon.studio.client.preference.model.PreferenceRepository;
import com.centreon.studio.client.preference.model.PreferenceTypes;
import com.centreon.studio.client.preference.model.PreferenceWebService;
import com.centreon.studio.client.utils.SequenceUtils;
import com.centreon.studio.client.utils.StreamUtils;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.client.elements.ElementAddon;
import com.centreon.studio.map.client.elements.ElementWebService;
import com.centreon.studio.map.client.elements.messages.ElementMessages;
import com.centreon.studio.map.client.elements.model.ElementPropertyDescriptors;
import com.centreon.studio.map.client.elements.model.ElementTypes;
import com.centreon.studio.map.client.elements.model.repository.ElementRepository;
import com.centreon.studio.map.client.elements.templates.TemplateRepository;
import com.centreon.studio.map.client.elements.templates.TemplateTypes;
import com.centreon.studio.map.client.elements.templates.TemplateWebService;
import com.centreon.studio.map.client.gates.model.ContextWebService;
import com.centreon.studio.map.client.gates.model.GatePropertyDescriptors;
import com.centreon.studio.map.client.gates.model.GateRepository;
import com.centreon.studio.map.client.gates.model.GateTypes;
import com.centreon.studio.map.client.gates.model.GateWebService;
import com.centreon.studio.map.client.gates.ui.CloseGateAction;
import com.centreon.studio.map.client.importexport.AImportExportWizardPage;
import com.centreon.studio.map.client.importexport.GateImportAction;
import com.centreon.studio.map.client.importexport.messages.ImportExportMessages;
import com.centreon.studio.map.client.resources.bam.model.BAMResourcePropertyDescriptors;
import com.centreon.studio.map.client.resources.bam.model.BAMResourceTypes;
import com.centreon.studio.map.client.resources.model.ResourcePropertyDescriptors;
import com.centreon.studio.map.client.resources.model.ResourceTypes;
import com.centreon.studio.map.client.resources.model.repository.ResourceRepository;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.ws.Holder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class GateImportWizardPage
extends AImportExportWizardPage {
    private static final String RESOURCE_NOT_FOUND = "Resource not found.";
    private static final Collection<TypeDescriptor> RESOURCE_WHICH_NEED_KPI_MAPPING = new ArrayList<TypeDescriptor>(5);
    private final ACLWebService aclService;
    private final GateWebService gateService;
    private final MediaWebService mediaService;
    private final ContextWebService contextService;
    private final ElementWebService elementService;
    private final TemplateWebService templateService;
    private final PreferenceWebService preferenceService;
    private final PreferenceRepository preferenceRepository;
    private final ResourceRepository resourceRepository;
    private final TemplateRepository templateRepository;
    private final ElementRepository elementRepository;
    private final MediaRepository mediaRepository;
    private final GateRepository gateRepository;
    private final ACLRepository aclRepository;

    static {
        RESOURCE_WHICH_NEED_KPI_MAPPING.add(BAMResourceTypes.RESOURCE_KPI);
        RESOURCE_WHICH_NEED_KPI_MAPPING.add(BAMResourceTypes.RESOURCE_KPI_BA);
        RESOURCE_WHICH_NEED_KPI_MAPPING.add(BAMResourceTypes.RESOURCE_KPI_META);
        RESOURCE_WHICH_NEED_KPI_MAPPING.add(BAMResourceTypes.RESOURCE_KPI_BOOLEAN);
        RESOURCE_WHICH_NEED_KPI_MAPPING.add(BAMResourceTypes.RESOURCE_KPI_SERVICE);
    }

    private static void applyContext(INode node, INode scope, String contextId) {
        node.addPropertyValues(Arrays.asList(new PropertyValue(PropertyDescriptors.CONTEXT_ID, (Object)contextId), new PropertyValue(PropertyDescriptors.SCOPE, (Object)scope)));
        for (INodeRelation relation : node.getRelations(new TypeDescriptor[0])) {
            relation.addPropertyValues(Arrays.asList(new PropertyValue(PropertyDescriptors.CONTEXT_ID, (Object)contextId), new PropertyValue(PropertyDescriptors.SCOPE, (Object)scope)));
            GateImportWizardPage.applyContext(relation.getTarget(), scope, contextId);
        }
    }

    private static boolean applyKPIMapping(INode target, Map<TypeDescriptor, Map<String, INode>> resourceMapping, StringBuilder errors) {
        Map<String, INode> bas = resourceMapping.get(BAMResourceTypes.RESOURCE_BA);
        if (bas == null) {
            errors.append("No ");
            errors.append(BAMResourceTypes.RESOURCE_BA);
            errors.append(" has been found on destination platform.");
            errors.append(StringUtils.NEW_LINE);
            return false;
        }
        Long parentId = (Long)target.getProperty(BAMResourcePropertyDescriptors.PARENT_BA);
        INode actualParent = null;
        for (INode ba : bas.values()) {
            if (!ba.getId().equals(parentId)) continue;
            actualParent = ba;
            break;
        }
        if (actualParent == null) {
            errors.append(BAMResourceTypes.RESOURCE_BA);
            errors.append(" ");
            errors.append(parentId);
            errors.append("' could been found on destination platform.");
            errors.append(StringUtils.NEW_LINE);
            return false;
        }
        String resourceLabel = (String)target.getProperty(ResourcePropertyDescriptors.RESOURCE_NAME);
        String parentResourceLabel = (String)target.getProperty(ResourcePropertyDescriptors.PARENT_RESOURCE_NAME);
        for (INodeRelation relation : actualParent.getRelations(new TypeDescriptor[0])) {
            if (!((String)relation.getTarget().getProperty(ResourcePropertyDescriptors.RESOURCE_NAME)).equals(resourceLabel) || !((String)relation.getTarget().getProperty(ResourcePropertyDescriptors.PARENT_RESOURCE_NAME)).equals(parentResourceLabel)) continue;
            target.addPropertyValue(ElementPropertyDescriptors.RESOURCE_ID, (Object)relation.getTarget().getId());
            return true;
        }
        return false;
    }

    private static void applyMapping(INode element, PropertyDescriptor<Long> property, Map<Long, INode> mapping, IWebService service) {
        INode mappedValue;
        Long value = (Long)element.getProperty(property);
        if (value != null && !value.equals(property.defaulValue) && (mappedValue = mapping.get(value)) != null && !mappedValue.getId().equals(value)) {
            element.addPropertyValue(property, (Object)mappedValue.getId());
            if (service != null) {
                service.update(Arrays.asList(element));
            }
        }
        for (INodeRelation relation : element.getRelations(new TypeDescriptor[0])) {
            GateImportWizardPage.applyMapping(relation.getTarget(), property, mapping, service);
        }
    }

    private static boolean applyResourceMapping(INode target, Map<TypeDescriptor, Map<String, INode>> resourceMapping, StringBuilder errors) {
        TypeDescriptor type = (TypeDescriptor)target.getProperty(ElementPropertyDescriptors.RESOURCE_TYPE);
        if (type != null) {
            if (ResourceTypes.RESOURCE_SERVICE.equals((Object)type)) {
                return GateImportWizardPage.applyServiceMapping(target, resourceMapping, errors);
            }
            if (RESOURCE_WHICH_NEED_KPI_MAPPING.contains(type)) {
                return GateImportWizardPage.applyKPIMapping(target, resourceMapping, errors);
            }
            Map<String, INode> labelToNode = resourceMapping.get(type);
            if (labelToNode != null) {
                String resourceLabel = (String)target.getProperty(ResourcePropertyDescriptors.RESOURCE_NAME);
                INode actualResource = labelToNode.get(resourceLabel);
                if (actualResource == null) {
                    errors.append(type);
                    errors.append(" ");
                    errors.append(resourceLabel);
                    errors.append(" could been found by its name on destination platform.");
                    errors.append(StringUtils.NEW_LINE);
                    return false;
                }
                target.addPropertyValue(ElementPropertyDescriptors.RESOURCE_ID, (Object)actualResource.getId());
            }
            return true;
        }
        return true;
    }

    private static boolean applyServiceMapping(INode target, Map<TypeDescriptor, Map<String, INode>> resourceMapping, StringBuilder errors) {
        String parentLabel = (String)target.getProperty(ResourcePropertyDescriptors.PARENT_RESOURCE_NAME);
        String resourceLabel = (String)target.getProperty(ResourcePropertyDescriptors.RESOURCE_NAME);
        Map<String, INode> labelToNode = resourceMapping.get(ResourceTypes.RESOURCE_HOST);
        if (labelToNode == null) {
            errors.append("No ");
            errors.append(ResourceTypes.RESOURCE_HOST);
            errors.append(" could been found on destination platform");
            errors.append(StringUtils.NEW_LINE);
            return false;
        }
        INode actualParentResource = labelToNode.get(parentLabel);
        if (actualParentResource == null) {
            errors.append(ResourceTypes.RESOURCE_HOST);
            errors.append(" ");
            errors.append(parentLabel);
            errors.append(" could been found on destination platform");
            errors.append(StringUtils.NEW_LINE);
            return false;
        }
        for (INodeRelation relation : actualParentResource.getRelations(new TypeDescriptor[0])) {
            if (!ResourceTypes.RESOURCE_SERVICE.equals((Object)relation.getTarget().getType()) || !relation.getTarget().getLabel().equals(resourceLabel)) continue;
            target.addPropertyValue(ElementPropertyDescriptors.RESOURCE_ID, (Object)relation.getTarget().getId());
            return true;
        }
        errors.append(ResourceTypes.RESOURCE_SERVICE);
        errors.append(" ");
        errors.append(resourceLabel);
        errors.append(" on ");
        errors.append(ResourceTypes.RESOURCE_HOST);
        errors.append(" ");
        errors.append(parentLabel);
        errors.append(" could been found on destination platform.");
        errors.append(StringUtils.NEW_LINE);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyFiles(Collection<INodeRelation> relations, BrokerEventManager eventManager) {
        Iterator<INodeRelation> iterator = relations.iterator();
        while (true) {
            INodeRelation relation;
            block34: {
                Throwable throwable;
                if (!iterator.hasNext()) {
                    return;
                }
                relation = iterator.next();
                INode media = relation.getTarget();
                if (MediaTypes.MEDIA_GROUP.equals((Object)media.getType())) {
                    GateImportWizardPage.copyFiles(media.getRelations(new TypeDescriptor[0]), eventManager);
                    continue;
                }
                File file = MediaUtils.getMediaLocalFile((INode)media);
                if (file.exists()) {
                    try {
                        Throwable throwable2 = null;
                        throwable = null;
                        try {
                            FileInputStream inputStream = new FileInputStream(file);
                            try {
                                String md5 = StreamUtils.md5((InputStream)inputStream);
                                if (md5.equals(media.getProperty(MediaPropertyDescriptors.MD5))) {
                                    eventManager.async((StudioEvent)LogEvent.trace(GateImportAction.class, (String)"File {} already exists with same MD5", (Object[])new Object[]{file.getAbsolutePath()}));
                                } else {
                                    eventManager.async((StudioEvent)LogEvent.error(GateImportAction.class, (String)"File {} already exists with different MD5", (Object[])new Object[]{file.getAbsolutePath()}));
                                }
                                continue;
                            }
                            catch (Throwable throwable3) {
                                throw throwable3;
                            }
                            finally {
                                if (inputStream == null) continue;
                                ((InputStream)inputStream).close();
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                                throw throwable2;
                            }
                            if (throwable2 == throwable4) throw throwable2;
                            throwable2.addSuppressed(throwable4);
                            throw throwable2;
                        }
                    }
                    catch (IOException iOException) {}
                }
                try {
                    if (!file.createNewFile()) {
                        throw new IOException("file.createNewFile() returned false");
                    }
                }
                catch (IOException e) {
                    eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
                    continue;
                }
                byte[] content = (byte[])media.getProperty(MediaPropertyDescriptors.MEDIA_CONTENT);
                if (content == null) {
                    eventManager.async((StudioEvent)LogEvent.error(GateImportAction.class, (String)"Imported media content property is null, nothing to copy", (Object[])new Object[0]));
                    continue;
                }
                try {
                    throwable = null;
                    Object var8_13 = null;
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(content);
                        try {
                            try (FileOutputStream fos = new FileOutputStream(file);){
                                StreamUtils.copy((InputStream)bais, (OutputStream)fos);
                            }
                            if (bais == null) break block34;
                        }
                        catch (Throwable throwable5) {
                            if (throwable == null) {
                                throwable = throwable5;
                            } else if (throwable != throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            if (bais == null) throw throwable;
                            bais.close();
                            throw throwable;
                        }
                        bais.close();
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                            throw throwable;
                        }
                        if (throwable == throwable6) throw throwable;
                        throwable.addSuppressed(throwable6);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
                }
            }
            relation.getTarget().addPropertyValue(MediaPropertyDescriptors.MEDIA_CONTENT, null);
        }
    }

    private static INode importNode(INode repository, IWebService service, INode toImport) {
        INode imported = INodeUtils.copy((INode)toImport, (boolean)false, (boolean)false, (IRepository)repository.getRepository(), (PropertyValue[])new PropertyValue[0]);
        INodeRelation relation = NodeRelationFactories.INSTANCE.create(ElementTypes.RELATION_HIERARCHY, imported.getId(), repository, imported);
        HashMap<INode, List<INodeRelation>> toCreate = new HashMap<INode, List<INodeRelation>>(1);
        toCreate.put(repository, Arrays.asList(relation));
        Map createdRelations = service.create(toCreate);
        Assert.isTrue((createdRelations.size() == 1 && ((Collection)createdRelations.values().iterator().next()).size() == 1 ? 1 : 0) != 0);
        Iterator iterator = ((Collection)createdRelations.get(repository)).iterator();
        if (iterator.hasNext()) {
            INodeRelation createdRelation = (INodeRelation)iterator.next();
            return createdRelation.getTarget();
        }
        return null;
    }

    private static void importPreferences(List<INodeRelation> relations, IRepository prefRepository, PreferenceWebService prefService, Map<Long, INode> gateMapping) {
        ArrayList<INodeRelation> children = new ArrayList<INodeRelation>();
        for (INodeRelation relation : relations) {
            INode importedGate = relation.getTarget();
            for (INodeRelation preferenceRelation : importedGate.getRelations(new TypeDescriptor[]{PreferenceTypes.PREFERENCE})) {
                INode existingScope;
                INode importedScope = preferenceRelation.getTarget();
                INode actualScope = gateMapping.get(importedScope.getId());
                if (actualScope == null) {
                    actualScope = importedScope;
                }
                if ((existingScope = INodeUtils.findNode((INode)prefRepository, (TypeDescriptor)actualScope.getType(), (Long)actualScope.getId(), (PropertyValue[])new PropertyValue[0])) == null) {
                    existingScope = NodeFactories.INSTANCE.create(actualScope.getType(), actualScope.getId(), null, prefRepository);
                    children.add(NodeRelationFactories.INSTANCE.create(existingScope.getType(), existingScope.getId(), (INode)prefRepository, existingScope));
                }
                INodeUtils.performDelta((INode)existingScope, (INode)importedScope);
                prefService.saveScope(existingScope);
            }
        }
        prefRepository.addRelations(children);
    }

    private static Map<Long, INode> importRelations(List<INodeRelation> toImport, INode repository, IWebService service, PropertyDescriptor<?> toMatch, boolean recursive) {
        HashMap<Long, INode> idMapping = new HashMap<Long, INode>();
        for (INodeRelation relation : toImport) {
            INode nodeToImport = relation.getTarget();
            INode existingNode = null;
            if (nodeToImport.getType() == MediaTypes.MEDIA_IMAGE || nodeToImport.getType() == MediaTypes.MEDIA_GROUP) {
                PropertyValue md5 = new PropertyValue(MediaPropertyDescriptors.MD5, (Object)((String)nodeToImport.getProperty(MediaPropertyDescriptors.MD5)));
                existingNode = INodeUtils.findNode((INode)repository, (TypeDescriptor)nodeToImport.getType(), null, (PropertyValue[])new PropertyValue[]{md5});
            } else if (nodeToImport.getType() == TemplateTypes.TEMPLATE_LINK) {
                for (INodeRelation templateRelation : repository.getRelations(new TypeDescriptor[0])) {
                    existingNode = templateRelation.getTarget();
                    for (PropertyValue pv : nodeToImport.getPropertyValues()) {
                        if (Objects.equals(existingNode.getProperty(pv.getProperty()), pv.getValue())) continue;
                        existingNode = null;
                        break;
                    }
                    if (existingNode == null) {
                        continue;
                    }
                    break;
                }
            } else {
                existingNode = INodeUtils.findNode((INode)repository, (TypeDescriptor)nodeToImport.getType(), (Long)nodeToImport.getId(), (PropertyValue[])new PropertyValue[0]);
            }
            if (existingNode != null && (toMatch == null || Objects.equals(existingNode.getProperty(toMatch), nodeToImport.getProperty(toMatch)))) {
                idMapping.put(nodeToImport.getId(), existingNode);
                if (!recursive) continue;
                idMapping.putAll(GateImportWizardPage.importRelations(nodeToImport.getRelations(new TypeDescriptor[0]), existingNode, service, toMatch, recursive));
                continue;
            }
            INode importedNode = GateImportWizardPage.importNode(repository, service, nodeToImport);
            idMapping.put(nodeToImport.getId(), importedNode);
            if (!recursive) continue;
            idMapping.putAll(GateImportWizardPage.importRelations(nodeToImport.getRelations(new TypeDescriptor[0]), importedNode, service, toMatch, recursive));
        }
        return idMapping;
    }

    protected GateImportWizardPage(String pageName, IRepository input, IEclipseContext context, BrokerEventManager eventManager) {
        super(GateImportWizardPage.class.getSimpleName(), ImportExportMessages.importt, input, context, eventManager, 4096);
        this.setTitle(pageName);
        this.aclService = (ACLWebService)ContextInjectionFactory.make(ACLWebService.class, (IEclipseContext)context);
        this.gateService = (GateWebService)ContextInjectionFactory.make(GateWebService.class, (IEclipseContext)context);
        this.mediaService = (MediaWebService)ContextInjectionFactory.make(MediaWebService.class, (IEclipseContext)context);
        this.contextService = (ContextWebService)ContextInjectionFactory.make(ContextWebService.class, (IEclipseContext)context);
        this.elementService = (ElementWebService)ContextInjectionFactory.make(ElementWebService.class, (IEclipseContext)context);
        this.templateService = (TemplateWebService)ContextInjectionFactory.make(TemplateWebService.class, (IEclipseContext)context);
        this.preferenceService = (PreferenceWebService)ContextInjectionFactory.make(PreferenceWebService.class, (IEclipseContext)context);
        this.preferenceRepository = (PreferenceRepository)ContextInjectionFactory.make(PreferenceRepository.class, (IEclipseContext)context);
        this.resourceRepository = (ResourceRepository)ContextInjectionFactory.make(ResourceRepository.class, (IEclipseContext)context);
        this.templateRepository = (TemplateRepository)ContextInjectionFactory.make(TemplateRepository.class, (IEclipseContext)context);
        this.elementRepository = (ElementRepository)ContextInjectionFactory.make(ElementRepository.class, (IEclipseContext)context);
        this.mediaRepository = (MediaRepository)ContextInjectionFactory.make(MediaRepository.class, (IEclipseContext)context);
        this.gateRepository = (GateRepository)ContextInjectionFactory.make(GateRepository.class, (IEclipseContext)context);
        this.aclRepository = (ACLRepository)ContextInjectionFactory.make(ACLRepository.class, (IEclipseContext)context);
    }

    protected boolean performFinish() {
        String filePath = this.fileField.getValue();
        File file = new File(filePath);
        if (!file.exists()) {
            MessageDialogUtils.openError((String)("File '" + file.getAbsolutePath() + "' does not exist"));
            return false;
        }
        Holder importSuccessful = new Holder((Object)Boolean.FALSE);
        boolean importGateTemplate = this.templateGate.getSelection();
        boolean importAllTemplate = this.templateAll.getSelection();
        boolean importPreference = this.prefYes.getSelection();
        boolean importGateMedia = this.mediaGate.getSelection();
        boolean importAllMedia = this.mediaAll.getSelection();
        boolean importAcl = this.aclYes.getSelection();
        try {
            IRunnableWithProgress importTask = monitor -> {
                int globalActions = 2 + (importPreference ? 1 : 0) + (importAcl ? 1 : 0) + (importGateMedia || importAllMedia ? 1 : 0) + (importGateTemplate || importAllTemplate ? 1 : 0);
                monitor.beginTask(String.valueOf(this.prefixName) + " " + ImportExportMessages.gate, globalActions);
                monitor.subTask(ImportExportMessages.readingXmlFile);
                XMLRepository importedRepository = new XMLRepository(file, this.eventManager);
                try {
                    importedRepository.load();
                    monitor.worked(1);
                }
                catch (Exception e) {
                    this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
                    MessageDialogUtils.openError((String)("Could not load file'" + file.getAbsolutePath() + "'"));
                    return;
                }
                HashMap<Long, INode> mediaMapping = new HashMap<Long, INode>(50);
                if (importGateMedia || importAllMedia) {
                    monitor.subTask(ImportExportMessages.copyMediaFilesToServer);
                    GateImportWizardPage.copyFiles(importedRepository.getRelations(new TypeDescriptor[]{MediaTypes.MEDIA_IMAGE, MediaTypes.MEDIA_GROUP}), this.eventManager);
                    Display.getDefault().syncExec(() -> mediaMapping.putAll(GateImportWizardPage.importRelations(importedRepository.getRelations(new TypeDescriptor[]{MediaTypes.MEDIA_IMAGE, MediaTypes.MEDIA_GROUP}), (INode)this.mediaRepository, (IWebService)this.mediaService, MediaPropertyDescriptors.MD5, true)));
                    monitor.worked(1);
                }
                HashMap<Long, INode> templateMapping = new HashMap<Long, INode>(0);
                if (importGateTemplate || importAllTemplate) {
                    monitor.subTask(String.valueOf(this.prefixName) + " " + ImportExportMessages.linkTemplate);
                    Display.getDefault().syncExec(() -> templateMapping.putAll(GateImportWizardPage.importRelations(importedRepository.getRelations(new TypeDescriptor[]{TemplateTypes.TEMPLATE_LINK}), (INode)this.templateRepository, (IWebService)this.templateService, null, false)));
                    monitor.worked(1);
                }
                monitor.subTask(ImportExportMessages.gateMapping);
                for (INodeRelation relation : importedRepository.getRelations(new TypeDescriptor[]{GateTypes.GATE})) {
                    relation.getTarget().addPropertyValue(GatePropertyDescriptors.TARGET_ID, (Object)-1L);
                    if (INodeUtils.findNode((INode)this.gateRepository, (TypeDescriptor)GateTypes.GATE, null, (PropertyValue[])new PropertyValue[]{new PropertyValue(AObject.LABEL, (Object)relation.getTarget().getLabel())}) == null) continue;
                    int i = 1;
                    PropertyValue value = new PropertyValue(AObject.LABEL, (Object)(String.valueOf(relation.getTarget().getLabel()) + "-" + i));
                    while (INodeUtils.findNode((INode)this.gateRepository, (TypeDescriptor)GateTypes.GATE, null, (PropertyValue[])new PropertyValue[]{value}) != null) {
                        value = new PropertyValue(AObject.LABEL, (Object)(String.valueOf(relation.getTarget().getLabel()) + "-" + ++i));
                    }
                    relation.getTarget().addPropertyValues(Arrays.asList(value));
                }
                HashMap<Long, INode> gateMapping = new HashMap<Long, INode>(10);
                Display.getDefault().syncExec(() -> gateMapping.putAll(GateImportWizardPage.importRelations(importedRepository.getRelations(new TypeDescriptor[]{GateTypes.GATE}), (INode)this.gateRepository, (IWebService)this.gateService, GatePropertyDescriptors.TARGET_ID, false)));
                monitor.worked(1);
                if (importAcl) {
                    monitor.subTask(String.valueOf(this.prefixName) + " " + ImportExportMessages.acl);
                    this.importACLs(importedRepository.getRelations(new TypeDescriptor[]{ACLTypes.ACL_GROUP}), (IRepository)this.aclRepository, (IWebService)this.aclService, GateTypes.GATE, gateMapping);
                    monitor.worked(1);
                }
                if (importPreference) {
                    monitor.subTask(String.valueOf(this.prefixName) + " " + ImportExportMessages.preference);
                    GateImportWizardPage.importPreferences(importedRepository.getRelations(new TypeDescriptor[]{GateTypes.GATE}), (IRepository)this.preferenceRepository, this.preferenceService, gateMapping);
                    monitor.worked(1);
                }
                final Holder count = new Holder((Object)0);
                this.eventManager.sync((StudioEvent)ExceptionEvent.addFilter((String)RESOURCE_NOT_FOUND));
                ExceptionEventHandler handler = new ExceptionEventHandler(){

                    public void handleEvent(ExceptionEvent event) {
                        String causeMessage;
                        Throwable exception = event.getException();
                        if (exception == null) {
                            return;
                        }
                        String string = causeMessage = exception.getCause() != null ? exception.getCause().toString() : exception.toString();
                        if (causeMessage.contains(GateImportWizardPage.RESOURCE_NOT_FOUND)) {
                            count.value = (Integer)count.value + 1;
                        }
                    }
                };
                this.eventManager.subscribe("studio/exceptions", true, (StudioEventHandler)handler);
                monitor.subTask(String.valueOf(this.prefixName) + " " + ElementMessages.labelElements);
                HashMap<TypeDescriptor, Map<String, INode>> resourceMapping = new HashMap<TypeDescriptor, Map<String, INode>>(10);
                this.getResourceMapping(resourceMapping, (INode)this.resourceRepository);
                List importedRepoToGateRelations = importedRepository.getRelations(new TypeDescriptor[]{GateTypes.GATE});
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                StringBuilder errors = new StringBuilder();
                this.importElements(importedRepoToGateRelations, gateMapping, mediaMapping, templateMapping, resourceMapping, errors, (IProgressMonitor)subMonitor);
                String errorsString = errors.toString();
                int errorsNumber = StringUtils.count((String)errorsString, (String)StringUtils.NEW_LINE);
                if (errorsNumber > 0) {
                    MessageDialogUtils.openError((String)(String.valueOf(errorsNumber) + " element(s) could not be imported because the associated resource does not exist on target platform"));
                }
                this.eventManager.unsubscribe((StudioEventHandler)handler);
                this.eventManager.sync((StudioEvent)ExceptionEvent.removeFilter((String)RESOURCE_NOT_FOUND));
                Display.getDefault().syncExec(() -> {
                    if ((Integer)holder.value > 0) {
                        MessageDialogUtils.openError((String)(holder.value + " element(s) could not be loaded because the associtated resource could not be found"));
                    }
                    ArrayList<INodeRelation> gateRelations = new ArrayList<INodeRelation>();
                    for (INode createdGate : gateMapping.values()) {
                        INodeRelation relation = INodeUtils.findRelationForTarget((INode)createdGate.getRepository(), (TypeDescriptor)createdGate.getType(), (Long)createdGate.getId(), (PropertyValue[])new PropertyValue[0]);
                        if (relation == null) continue;
                        gateRelations.add(relation);
                    }
                    this.gateRepository.setSelection(GateImportWizardPage.class, gateRelations);
                    new CloseGateAction((IRepository)this.gateRepository, this.context, this.contextService).run();
                });
                monitor.worked(1);
                monitor.done();
                holder.value = Boolean.TRUE;
                this.eventManager.async((StudioEvent)new PopUpEvent().setTexts(ImportExportMessages.importt, "Import done").setImagePath("platform:/plugin/com.centreon.studio.client.events/img/ok.png"));
            };
            this.getContainer().run(true, false, importTask);
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
        return (Boolean)importSuccessful.value;
    }

    private void getResourceMapping(Map<TypeDescriptor, Map<String, INode>> mapping, INode node) {
        Map<String, INode> nodes = mapping.get(node.getType());
        if (nodes == null) {
            nodes = new HashMap<String, INode>();
            mapping.put(node.getType(), nodes);
        }
        nodes.put(node.getLabel(), node);
        for (INodeRelation relation : node.getRelations(new TypeDescriptor[0])) {
            this.getResourceMapping(mapping, relation.getTarget());
        }
    }

    private void importACLs(List<INodeRelation> relations, IRepository repository, IWebService service, TypeDescriptor type, Map<Long, INode> idMapping) {
        ArrayList<INode> toUpdate = new ArrayList<INode>();
        for (INodeRelation aclGroupRelationToImport : relations) {
            INode aclGroupToImport = aclGroupRelationToImport.getTarget();
            PropertyValue pv = new PropertyValue(AObject.LABEL, (Object)((String)aclGroupToImport.getProperty(AObject.LABEL)));
            INode existingAclGroup = INodeUtils.findNode((INode)repository, (TypeDescriptor)aclGroupToImport.getType(), null, (PropertyValue[])new PropertyValue[]{pv});
            if (existingAclGroup == null) {
                this.eventManager.async((StudioEvent)LogEvent.error(GateImportWizardPage.class, (String)"could not find acl group {} {}", (Object[])new Object[]{aclGroupToImport.getType(), aclGroupToImport.getId()}));
                continue;
            }
            for (INodeRelation aclRuleRelationToImport : aclGroupToImport.getRelations(new TypeDescriptor[]{type})) {
                INode aclRuleToImport = aclRuleRelationToImport.getTarget();
                INode actualNode = idMapping.get(aclRuleToImport.getId());
                if (actualNode == null) {
                    this.eventManager.async((StudioEvent)LogEvent.error(GateImportWizardPage.class, (String)"could not find actual acl rule for id {}", (Object[])new Object[]{aclRuleToImport.getId()}));
                    continue;
                }
                INode existingAclRule = INodeUtils.findNode((INode)existingAclGroup, (TypeDescriptor)actualNode.getType(), (Long)actualNode.getId(), (PropertyValue[])new PropertyValue[0]);
                if (existingAclRule == null) {
                    existingAclRule = NodeFactories.INSTANCE.create(actualNode.getType(), actualNode.getId(), null, repository);
                    existingAclGroup.addRelation(NodeRelationFactories.INSTANCE.create(type, SequenceUtils.next(), existingAclGroup, existingAclRule));
                }
                INodeUtils.updateProperties((IObject)existingAclRule, (Collection)aclRuleToImport.getPropertyValues(), (boolean)true, (boolean)true, (String[])new String[0]);
                toUpdate.add(existingAclRule);
            }
        }
        service.update(toUpdate);
    }

    private void importElement(INode element, List<INodeRelation> relations, Map<Long, INode> elementMapping, Map<Long, INode> mediaMapping, Map<Long, INode> templateMapping, Map<TypeDescriptor, Map<String, INode>> resourceMapping, StringBuilder errors, IProgressMonitor monitor) {
        monitor.subTask(element.getLabel());
        for (INodeRelation relation : relations) {
            HashMap<INode, List<INodeRelation>> toCreate = new HashMap<INode, List<INodeRelation>>(1);
            INodeRelation relationToCreate = INodeUtils.copy((INodeRelation)relation, (INode)element, (boolean)false, (boolean)false, (IRepository)element.getRepository(), (PropertyValue[])new PropertyValue[0]);
            GateImportWizardPage.applyMapping(relationToCreate.getTarget(), (PropertyDescriptor<Long>)MediaPropertyDescriptors.MEDIA_ID, mediaMapping, null);
            GateImportWizardPage.applyMapping(relationToCreate.getTarget(), (PropertyDescriptor<Long>)ElementPropertyDescriptors.TEMPLATE_ID, templateMapping, null);
            if (!GateImportWizardPage.applyResourceMapping(relationToCreate.getTarget(), resourceMapping, errors)) continue;
            toCreate.put(element, Arrays.asList(relationToCreate));
            try {
                Map createdRelations = this.elementService.create(toCreate);
                INode createdElement = ((INodeRelation)((Collection)createdRelations.get(element)).iterator().next()).getTarget();
                elementMapping.put(relation.getTarget().getId(), createdElement);
                this.importElement(createdElement, relation.getTarget().getRelations(new TypeDescriptor[0]), elementMapping, mediaMapping, templateMapping, resourceMapping, errors, monitor);
            }
            catch (Exception exception) {}
        }
    }

    private Map<Long, INode> importElements(Collection<INodeRelation> importedRepoToGateRelations, Map<Long, INode> gateMapping, Map<Long, INode> mediaMapping, Map<Long, INode> templateMapping, Map<TypeDescriptor, Map<String, INode>> resourceMapping, StringBuilder errors, IProgressMonitor monitor) {
        monitor.beginTask(ElementMessages.labelElements, importedRepoToGateRelations.size());
        for (INodeRelation importedRepoToGateRelation : importedRepoToGateRelations) {
            monitor.subTask(String.valueOf(ElementMessages.labelElements) + " : ");
            List gateToElementRelations = importedRepoToGateRelation.getTarget().getRelations(new TypeDescriptor[]{ElementTypes.RELATION_HIERARCHY});
            INodeRelation gateToElementRelation = (INodeRelation)gateToElementRelations.get(0);
            INode actualGate = gateMapping.get(gateToElementRelation.getSource().getId());
            this.importRootElement(actualGate, gateToElementRelation.getTarget(), mediaMapping, templateMapping, resourceMapping, errors, monitor);
            monitor.worked(1);
        }
        monitor.done();
        return null;
    }

    private void importRootElement(INode createdGate, INode rootElement, Map<Long, INode> mediaMapping, Map<Long, INode> templateMapping, Map<TypeDescriptor, Map<String, INode>> resourceMapping, StringBuilder errors, IProgressMonitor monitor) {
        String contextId = this.contextService.openGate(createdGate.getId());
        GateImportWizardPage.applyContext(rootElement, createdGate, contextId);
        ArrayList<PropertyValue> gateProperties = new ArrayList<PropertyValue>(4);
        gateProperties.add(new PropertyValue(GatePropertyDescriptors.OPEN, (Object)Boolean.TRUE));
        gateProperties.add(new PropertyValue(PropertyDescriptors.READ_ONLY, (Object)Boolean.TRUE));
        gateProperties.add(new PropertyValue(PropertyDescriptors.CONTEXT_ID, (Object)contextId));
        Display.getDefault().syncExec(() -> createdGate.addPropertyValues(gateProperties));
        Long targetId = (Long)createdGate.getProperty(GatePropertyDescriptors.TARGET_ID);
        Map elements = this.elementService.getElements(createdGate, Arrays.asList(targetId), (IRepository)this.elementRepository, -1);
        if (elements == null || elements.isEmpty()) {
            return;
        }
        INode element = (INode)elements.values().iterator().next();
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>(rootElement.getPropertyValues());
        propertyValues.add(new PropertyValue(AObject.LABEL, (Object)createdGate.getLabel()));
        propertyValues.add(new PropertyValue(PropertyDescriptors.READ_ONLY, (Object)Boolean.TRUE));
        INodeUtils.updateProperties((IObject)element, propertyValues, (boolean)true, (boolean)true, (String[])new String[0]);
        HashMap<Long, INode> elementMapping = new HashMap<Long, INode>();
        Display.getDefault().syncExec(() -> {
            INodeRelation relation = this.elementRepository.addRelation(NodeRelationFactories.INSTANCE.create(ElementTypes.RELATION_HIERARCHY, SequenceUtils.next(), (INode)this.elementRepository, element));
            ElementAddon.GATE_ID_TO_RELATION_ID.put(createdGate.getId(), relation.getId());
        });
        this.elementService.update(Arrays.asList(element));
        elementMapping.put(rootElement.getId(), element);
        SWTUtils.getDisplay().syncExec(() -> {
            this.importElement(element, rootElement.getRelations(new TypeDescriptor[0]), elementMapping, mediaMapping, templateMapping, resourceMapping, errors, monitor);
            GateImportWizardPage.applyMapping(element, (PropertyDescriptor<Long>)ElementPropertyDescriptors.LINK_SOURCE_ID, elementMapping, (IWebService)this.elementService);
            GateImportWizardPage.applyMapping(element, (PropertyDescriptor<Long>)ElementPropertyDescriptors.LINK_TARGET_ID, elementMapping, (IWebService)this.elementService);
        });
    }
}

