/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference;

import com.centreon.studio.client.acl.ACLTypes;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEvent;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.object.ObjectIdentifier;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.preference.PreferenceSyncEventHandler;
import com.centreon.studio.client.preference.model.PreferenceRepository;
import com.centreon.studio.client.preference.model.PreferenceWebService;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public final class PreferenceAddon
extends PreferenceSyncEventHandler {
    private final AuthenticationEventHandler authenticationEventHandler;

    @Inject
    public PreferenceAddon(final PreferenceRepository repository, final PreferenceWebService service, BrokerEventManager eventManager) {
        super(service, eventManager);
        this.authenticationEventHandler = new AuthenticationEventHandler(){

            protected void loggedIn() {
                AuthenticationEvent finalEvent = this.lastEvent;
                service.loadScopes(Arrays.asList(new ObjectIdentifier(finalEvent.getId().longValue(), ACLTypes.USER)));
            }

            protected void loggedOut() {
                repository.setSelection((Object)this, null);
                repository.removeRelations(repository.getRelations(new TypeDescriptor[0]));
            }
        };
    }

    @PreDestroy
    public void preDestroy(BrokerEventManager eventManager) {
        eventManager.unsubscribe((StudioEventHandler)this);
        eventManager.unsubscribe((StudioEventHandler)this.authenticationEventHandler);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Preference addon destroyed", (Object[])new Object[0]));
    }

    @PostConstruct
    final void postConstruct(BrokerEventManager eventManager) {
        eventManager.subscribe("studio/sync", true, (StudioEventHandler)this);
        eventManager.subscribe("studio/authentication", true, (StudioEventHandler)this.authenticationEventHandler);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Preference addon loaded", (Object[])new Object[0]));
    }
}

